/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.gsc.HostGSCsComponent;
import com.gigaspaces.admin.ui.grid.gsc.PanelDropTarget;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTransferHandler;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeCellRenderer;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTableModel;
import com.gigaspaces.admin.ui.grid.treenode.BasicPUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.DeployedServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.JeePUServiceNode;
import com.gigaspaces.admin.ui.jtreetable.JTreeTable;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.id.Uuid;
import org.jini.rio.core.provision.ServiceRecord;

public class ServiceTreeTable
extends JTreeTable
implements Autoscroll {
    private final ServiceTreeTableModel _dataModel;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");
    private final ServiceTreeCellRenderer _treeCellRenderer;
    private final HostGSCsComponent _hostGSCsComponent;
    private final TableColumnModel cm;
    private final List<Integer> treeNodeLengthsList = new ArrayList<Integer>();
    private final FontMetrics _fontMetrics;
    private final int margin = 31;
    private int _curColumnWidth;

    public ServiceTreeTable(HostGSCsComponent hostGSCsComponent, ServiceTreeTableModel dataModel) {
        super(dataModel);
        this._dataModel = dataModel;
        this._hostGSCsComponent = hostGSCsComponent;
        this._treeCellRenderer = new ServiceTreeCellRenderer(dataModel);
        this.tree.setCellRenderer(this._treeCellRenderer);
        this.setAutoCreateColumnsFromModel(true);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.cm = this.getColumnModel();
        this.cm.getColumn(0).setPreferredWidth(320);
        this.getTree().setRootVisible(false);
        this.getTree().setShowsRootHandles(true);
        ((DefaultTreeCellRenderer)this.getTree().getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)this.getTree().getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.getTree().getCellRenderer()).setClosedIcon(null);
        this.setTransferHandler(ServiceTransferHandler.getInstance(this._hostGSCsComponent.getGSCPanel().getServiceRelocator(), this._hostGSCsComponent.getParentFrame()));
        this.setDropTarget(new DropTarget(this, new PanelDropTarget(this._hostGSCsComponent.getParentFrame(), this, this._hostGSCsComponent.getGSCPanel().getServiceRelocator())));
        this.setDragEnabled(true);
        this._fontMetrics = this.tree.getFontMetrics(this.getFont());
    }

    public void resizeColumnWidth(int newWidth) {
        this._curColumnWidth = newWidth;
        this.cm.getColumn(0).setPreferredWidth(newWidth);
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.tree.getRowForLocation(p.x, p.y);
        if (realrow >= 0) {
            Rectangle outer = this.getBounds();
            realrow = p.y + outer.y <= 31 ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
            this.tree.scrollRowToVisible(realrow);
            Rectangle treeBounds = this.tree.getRowBounds(realrow);
            this.scrollRectToVisible(treeBounds);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + 31, inner.x - outer.x + 31, outer.height - inner.height - inner.y + outer.y + 31, outer.width - inner.width - inner.x + outer.x + 31);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Object obj;
        String tip = null;
        Point p = event.getPoint();
        int rowIndex = this.rowAtPoint(p);
        if (rowIndex != -1 && (obj = this.getNodeAt(rowIndex)) != null) {
            if (obj instanceof BasicPUServiceNode) {
                return ((BasicPUServiceNode)obj).getLongDescription();
            }
            if (obj instanceof PUNode) {
                return "<HTML>" + ((PUNode)obj).getPresentationName() + "<BR>" + ((PUNode)obj).getServiceRecord().getServiceID() + "</HTML>";
            }
            if (obj instanceof GSCNode) {
                return ((GSCNode)obj).getServiceID();
            }
            return obj.toString();
        }
        return tip;
    }

    public Object getNodeAt(int rowIndex) {
        TreePath treePath = this.tree.getPathForRow(rowIndex);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    public void addService(ServiceRecord record, ServiceItem gscServiceItem) {
        block5: {
            if (record == null) {
                return;
            }
            Uuid uuid = record.getServiceID();
            ServiceID serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            Repository.addServiceBeanConfig(serviceID, record.getServiceElement().getServiceBeanConfig());
            try {
                ServiceItem item = Repository.getInstance().getServiceItem(serviceID);
                DefaultMutableTreeNode puNode = this._dataModel.addService(serviceID, record, gscServiceItem);
                if (puNode != null) {
                    if (item != null) {
                        HostGSCsComponent.addDeployedServicesNodes(item, puNode, false);
                    }
                    this.updateTreeTableColumnWidth(this._curColumnWidth);
                    TreePath treePath = new TreePath(puNode.getPath());
                    this.getTree().collapsePath(treePath);
                    this.getTree().expandPath(treePath);
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block5;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTreeTableColumnWidth(int curCompWidth) {
        List<Integer> list = this.treeNodeLengthsList;
        synchronized (list) {
            this.treeNodeLengthsList.clear();
            this.fillTreeNodeLengths((DefaultMutableTreeNode)this._dataModel.getRoot(), 0);
            Collections.sort(this.treeNodeLengthsList);
            int maxLength = 0;
            if (this.treeNodeLengthsList.size() > 0) {
                maxLength = this.treeNodeLengthsList.get(this.treeNodeLengthsList.size() - 1);
            }
            this.resizeColumnWidth(Math.max(curCompWidth, maxLength));
        }
    }

    private void fillTreeNodeLengths(DefaultMutableTreeNode treeNode, int row) {
        int childCount = treeNode.getChildCount();
        for (int index = 0; index < childCount; ++index) {
            DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(index);
            BasicTreeUI basicTreeUI = (BasicTreeUI)this.tree.getUI();
            this.treeNodeLengthsList.add(this._fontMetrics.stringWidth(childTreeNode.toString()) + (row + 1) * (basicTreeUI.getLeftChildIndent() + 32));
            this.fillTreeNodeLengths(childTreeNode, row + 1);
        }
    }

    public boolean removeService(ServiceID removedServiceID) {
        if (removedServiceID == null) {
            return false;
        }
        boolean ret = this._dataModel.removeService(removedServiceID);
        this.updateTreeTableColumnWidth(this._hostGSCsComponent.getCurSize().width - 3);
        return ret;
    }

    public void reloadServices() {
        ServiceTreeTableModel.ServiceRecordWrapper[] existingRecordWrappers = this._dataModel.getServiceRecords(true);
        HashSet<ServiceID> existingPUServiceIds = new HashSet<ServiceID>(existingRecordWrappers.length);
        Collection<GSCNode> gsNodes = this._dataModel.getGSCNodes();
        Iterator<GSCNode> iterator = gsNodes.iterator();
        HashMap<ServiceID, PUNode> puNodesMap = new HashMap<ServiceID, PUNode>();
        while (iterator.hasNext()) {
            GSCNode gscNode = iterator.next();
            int n = gscNode.getChildCount();
            for (int index = 0; index < n; ++index) {
                PUNode puNode = (PUNode)gscNode.getChildAt(index);
                Uuid puServiceID = puNode.getServiceRecord().getServiceID();
                ServiceID puID = new ServiceID(puServiceID.getMostSignificantBits(), puServiceID.getLeastSignificantBits());
                puNodesMap.put(puID, puNode);
            }
        }
        for (ServiceTreeTableModel.ServiceRecordWrapper serviceRecordWrapper : existingRecordWrappers) {
            ServiceRecord[] serviceRecords;
            ServiceItem gscServicetem = serviceRecordWrapper.getGscItem();
            for (ServiceRecord existingServiceRecord : serviceRecords = serviceRecordWrapper.getServiceRecords()) {
                Uuid existingID = existingServiceRecord.getServiceID();
                ServiceID existingPuId = new ServiceID(existingID.getMostSignificantBits(), existingID.getLeastSignificantBits());
                existingPUServiceIds.add(existingPuId);
                if (!puNodesMap.containsKey(existingPuId)) {
                    this.addService(existingServiceRecord, gscServicetem);
                    continue;
                }
                if (!puNodesMap.containsKey(existingPuId) || ((PUNode)puNodesMap.get(existingPuId)).getChildCount() != 0) continue;
                this.addService(existingServiceRecord, gscServicetem);
            }
        }
        for (Map.Entry entry : puNodesMap.entrySet()) {
            if (existingPUServiceIds.contains(entry.getKey())) continue;
            this.removePUNode((PUNode)entry.getValue(), (ServiceID)entry.getKey());
        }
    }

    private void removePUNode(PUNode puNode, ServiceID puServiceID) {
        this._dataModel.clear(puServiceID);
        puNode.removeFromParent();
        this.updateTreeTableColumnWidth(this._hostGSCsComponent.getCurSize().width - 3);
    }

    public ServiceRecord getServiceRecordAt(Point point) {
        TreePath treePath = this.getTree().getPathForRow(this.rowAtPoint(point));
        return this.getServiceRecordForPath(treePath);
    }

    public Object getSelectedUserObject(Point point) {
        TreePath treePath = this.getTree().getPathForRow(this.rowAtPoint(point));
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return selTreeNode == null ? null : selTreeNode.getUserObject();
    }

    public DefaultMutableTreeNode getSelectedTreeNode(Point point) {
        TreePath treePath = this.getTree().getPathForRow(this.rowAtPoint(point));
        return treePath == null ? null : (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public void selectRow(Point point) {
        int row = this.rowAtPoint(point);
        if (row >= 0 && row < this.getRowCount()) {
            this.setRowSelectionInterval(row, row);
        }
    }

    public ServiceRecord getSelectedServiceRecord() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        return this.getServiceRecordForPath(selTreePath);
    }

    public ServiceTreeTableModel.GSCHolder getSelectedGSCHolder() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        return this.getSelectedGSCHolder(selTreePath);
    }

    private ServiceTreeTableModel.GSCHolder getSelectedGSCHolder(TreePath treePath) {
        DefaultMutableTreeNode selTreeNode;
        if (treePath == null) {
            return null;
        }
        ServiceTreeTableModel.GSCHolder gscHolder = null;
        for (selTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent(); selTreeNode != null && !(selTreeNode instanceof GSCNode); selTreeNode = (DefaultMutableTreeNode)selTreeNode.getParent()) {
        }
        if (selTreeNode != null) {
            gscHolder = (ServiceTreeTableModel.GSCHolder)selTreeNode.getUserObject();
        }
        return gscHolder;
    }

    public boolean isPUSelected() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        if (selTreePath == null) {
            return false;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent();
        return selTreeNode instanceof PUNode;
    }

    public boolean isSpaceSelected() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        if (selTreePath == null) {
            return false;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent();
        return selTreeNode instanceof DeployedServiceNode;
    }

    public boolean isJ2eePUSelected() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        if (selTreePath == null) {
            return false;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent();
        return selTreeNode instanceof JeePUServiceNode;
    }

    private ServiceRecord getServiceRecordForPath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        ServiceRecord selServiceRecord = null;
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (selTreeNode instanceof DeployedServiceNode) {
            selServiceRecord = ((DeployedServiceNode)selTreeNode).getServiceRecord();
        } else if (selTreeNode instanceof PUNode) {
            selServiceRecord = ((PUNode)selTreeNode).getServiceRecord();
        }
        return selServiceRecord;
    }

    public String getSelectedURL() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        if (selTreePath == null) {
            return null;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent();
        String result = null;
        if (selTreeNode instanceof JeePUServiceNode) {
            result = ((JeePUServiceNode)selTreeNode).getUrl();
        }
        return result;
    }

    public boolean isGSCSelected() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        if (selTreePath == null) {
            return false;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent();
        return selTreeNode instanceof GSCNode;
    }

    public boolean isGSServiceSelected() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        if (selTreePath == null) {
            return false;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent();
        return selTreeNode.getUserObject() instanceof ServiceTreeTableModel.ServiceUserObject;
    }

    public ServiceTreeTableModel.ServiceUserObject getSelectedService() {
        TreePath selTreePath = this.getTree().getSelectionPath();
        if (selTreePath == null) {
            return null;
        }
        DefaultMutableTreeNode selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent();
        return (ServiceTreeTableModel.ServiceUserObject)selTreeNode.getUserObject();
    }

    public void updateTreeTableColumnWidth() {
        this.updateTreeTableColumnWidth(this._curColumnWidth);
    }

    public static class GSCNode
    extends DefaultMutableTreeNode {
        GSCNode(ServiceTreeTableModel.GSCHolder gscHolder) {
            super(gscHolder);
        }

        @Override
        public String toString() {
            return ((ServiceTreeTableModel.GSCHolder)this.getUserObject()).getPresentationName(true);
        }

        public String getServiceID() {
            return ((ServiceTreeTableModel.GSCHolder)this.getUserObject()).getServiceItem().serviceID.toString();
        }
    }

    public static class PUNode
    extends DefaultMutableTreeNode {
        private final String _presentationName;
        private final String _operationalStringName;

        public PUNode(ServiceRecord serviceRecord) {
            super(serviceRecord);
            this._presentationName = serviceRecord.getPresentationName();
            this._operationalStringName = serviceRecord.getServiceElement().getOperationalStringName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("~~~~~~ PUNode constructor, " + this.toString() + ", service ID:" + serviceRecord.getServiceID());
            }
        }

        @Override
        public String toString() {
            return this.getPresentationName();
        }

        public String getPresentationName() {
            return this._presentationName;
        }

        public String getOperationalStringName() {
            return this._operationalStringName;
        }

        public ServiceRecord getServiceRecord() {
            return (ServiceRecord)this.getUserObject();
        }
    }
}

