/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.gsc.HostGSCsComponent;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTable;
import com.gigaspaces.admin.ui.grid.treenode.BasicPUServiceNode;
import com.gigaspaces.admin.ui.jtreetable.AbstractTreeTableModel;
import com.gigaspaces.admin.ui.jtreetable.TreeTableModel;
import com.gigaspaces.grid.esm.ESM;
import com.gigaspaces.grid.gsa.AgentIdAware;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.JConsoleUIUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lookup.entry.Name;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.cybernode.CybernodeAdmin;
import org.jini.rio.entry.ApplianceInfo;
import org.jini.rio.entry.ComputeResourceUtilization;

public class ServiceTreeTableModel
extends AbstractTreeTableModel {
    private HostGSCsComponent _hostGSCsComponent;
    private MainUI _mainUI;
    final String[] columnNames = new String[]{"Services"};
    private Class[] cTypes = new Class[]{TreeTableModel.class};
    private Map<ServiceID, DefaultMutableTreeNode> _serviceRecordsNodesMap = new HashMap<ServiceID, DefaultMutableTreeNode>();
    private ConcurrentMap<ServiceID, ServiceTreeTable.GSCNode> _gscsNodesMap = new ConcurrentHashMap<ServiceID, ServiceTreeTable.GSCNode>();
    private Map<ServiceID, DefaultMutableTreeNode> _servicesNodesMap = new HashMap<ServiceID, DefaultMutableTreeNode>();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public ServiceTreeTableModel(HostGSCsComponent hostGSCsComponent, MainUI mainUI) {
        super(new DefaultMutableTreeNode("JTreeTableRoot"));
        this._hostGSCsComponent = hostGSCsComponent;
        this._mainUI = mainUI;
    }

    public ServiceUserObject getServiceUserObject(ServiceID serviceID) {
        DefaultMutableTreeNode treeNode = this._servicesNodesMap.get(serviceID);
        if (treeNode != null) {
            return (ServiceUserObject)treeNode.getUserObject();
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    @Override
    public Object getChild(Object node, int i) {
        return ((TreeNode)node).getChildAt(i);
    }

    @Override
    public Class getColumnClass(int column) {
        return this.cTypes[column];
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node instanceof ServiceTreeTable.PUNode) {
            ServiceTreeTable.PUNode puNode = (ServiceTreeTable.PUNode)node;
            switch (column) {
                case 0: {
                    return puNode.getPresentationName();
                }
            }
        }
        if (node instanceof ServiceTreeTable.GSCNode) {
            ServiceTreeTable.GSCNode gscNode = (ServiceTreeTable.GSCNode)node;
            switch (column) {
                case 0: {
                    return gscNode.toString();
                }
            }
        }
        if (node instanceof BasicPUServiceNode) {
            switch (column) {
                case 0: {
                    return node.toString();
                }
            }
        }
        return node == null ? "" : node.toString();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public MutableTreeNode getGSCNode(ServiceID gscID) {
        return (MutableTreeNode)this._gscsNodesMap.get(gscID);
    }

    public Collection<ServiceTreeTable.GSCNode> getGSCNodes() {
        return this._gscsNodesMap.values();
    }

    public int getGSCCount() {
        return this._gscsNodesMap.size();
    }

    public int getServicesCount() {
        return this._servicesNodesMap.size() + this.getGSCCount();
    }

    public DefaultMutableTreeNode addService(ServiceID serviceID, ServiceRecord record, ServiceItem gscServiceItem) {
        int childCount;
        MutableTreeNode gscNode = this.createGSCNodeIfNeededGSC(gscServiceItem);
        if (gscNode == null) {
            return null;
        }
        DefaultMutableTreeNode puNode = this._serviceRecordsNodesMap.get(serviceID);
        if (puNode == null) {
            puNode = new ServiceTreeTable.PUNode(record);
            this.insertNodeInto(puNode, gscNode, gscNode.getChildCount());
            this._serviceRecordsNodesMap.put(serviceID, puNode);
        }
        if ((childCount = puNode.getChildCount()) > 0) {
            int[] childIndexes = new int[childCount];
            for (int index = 0; index < childCount; ++index) {
                childIndexes[index] = index;
            }
            this.nodesWereInserted(puNode, childIndexes);
        }
        return puNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableTreeNode createGSCNodeIfNeededGSC(ServiceItem gscServiceItem) {
        ServiceID gscID = gscServiceItem.serviceID;
        ServiceTreeTable.GSCNode gscNode = null;
        GSCHolder gscHolder = null;
        boolean gscFound = true;
        ConcurrentMap<ServiceID, ServiceTreeTable.GSCNode> concurrentMap = this._gscsNodesMap;
        synchronized (concurrentMap) {
            block7: {
                gscNode = (ServiceTreeTable.GSCNode)this._gscsNodesMap.get(gscID);
                if (gscNode == null) {
                    gscFound = false;
                    try {
                        gscHolder = new GSCHolder(gscServiceItem, this._hostGSCsComponent);
                        gscNode = new ServiceTreeTable.GSCNode(gscHolder);
                        this._gscsNodesMap.put(gscID, gscNode);
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block7;
                        _logger.log(Level.SEVERE, e.toString());
                    }
                }
            }
        }
        if (!gscFound && gscNode != null && gscHolder != null) {
            this.addTreeNode(gscNode);
            gscHolder.updateHolder();
            TreePath treePath = new TreePath(gscNode.getPath());
            JTree tree = this._hostGSCsComponent.getServiceTreeTable().getTree();
            tree.collapsePath(treePath);
            tree.expandPath(treePath);
        }
        return gscNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableTreeNode createServiceNode(ServiceItem serviceItem) {
        ServiceID serviceID = serviceItem.serviceID;
        DefaultMutableTreeNode serviceNode = null;
        ServiceUserObject serviceUserObject = null;
        boolean serviceNodeFoundFound = true;
        Map<ServiceID, DefaultMutableTreeNode> map = this._servicesNodesMap;
        synchronized (map) {
            block8: {
                serviceNode = this._servicesNodesMap.get(serviceID);
                if (serviceNode == null) {
                    serviceNodeFoundFound = false;
                    try {
                        serviceUserObject = this.createServiceUserObject(serviceItem);
                        if (serviceUserObject != null) {
                            serviceNode = new DefaultMutableTreeNode(serviceUserObject);
                            this._servicesNodesMap.put(serviceID, serviceNode);
                        }
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block8;
                        _logger.log(Level.SEVERE, e.toString());
                    }
                }
            }
        }
        if (!serviceNodeFoundFound && serviceNode != null) {
            this.addTreeNode(serviceNode);
            TreePath treePath = new TreePath(serviceNode.getPath());
            JTree tree = this._hostGSCsComponent.getServiceTreeTable().getTree();
            tree.collapsePath(treePath);
            tree.expandPath(treePath);
        }
        return serviceNode;
    }

    private synchronized void addTreeNode(DefaultMutableTreeNode newTreeNode) {
        if (newTreeNode instanceof ServiceTreeTable.GSCNode) {
            int lastGSCNodeIndex = 0;
            int childCount = ((DefaultMutableTreeNode)this.getRoot()).getChildCount();
            for (int index = 0; index < childCount; ++index) {
                TreeNode childNode = ((DefaultMutableTreeNode)this.getRoot()).getChildAt(index);
                if (childNode instanceof ServiceTreeTable.GSCNode) continue;
                lastGSCNodeIndex = index;
                break;
            }
            ((DefaultMutableTreeNode)this.getRoot()).insert(newTreeNode, lastGSCNodeIndex);
            this.nodesWereInserted((TreeNode)this.getRoot(), new int[]{lastGSCNodeIndex});
        } else {
            ((DefaultMutableTreeNode)this.getRoot()).add(newTreeNode);
            this.nodesWereInserted((TreeNode)this.getRoot(), new int[]{((TreeNode)this.getRoot()).getChildCount() - 1});
        }
    }

    private ServiceUserObject createServiceUserObject(ServiceItem serviceItem) {
        Object service = serviceItem.service;
        ServiceUserObject serviceUserObject = null;
        if (service instanceof GSM) {
            serviceUserObject = new ServiceUserObject(serviceItem, "gsm");
        } else if (service instanceof GSA) {
            serviceUserObject = new ServiceUserObject(serviceItem, "gsa");
        } else if (service instanceof ServiceRegistrar) {
            serviceUserObject = new ServiceUserObject(serviceItem, "lus");
        } else if (service instanceof ESM) {
            serviceUserObject = new ServiceUserObject(serviceItem, "esm");
        }
        return serviceUserObject;
    }

    protected boolean removeService(ServiceID removedServiceID) {
        MutableTreeNode serviceNode = this._servicesNodesMap.remove(removedServiceID);
        if (serviceNode != null) {
            this.removeNodeFromParent(serviceNode);
            return true;
        }
        boolean isRemoved = false;
        MutableTreeNode gscNode = (MutableTreeNode)this._gscsNodesMap.remove(removedServiceID);
        if (gscNode != null) {
            int childIndex;
            HashMap<String, ArrayList<ServiceID>> operStringNameMap = new HashMap<String, ArrayList<ServiceID>>();
            int childCount = gscNode.getChildCount();
            ArrayList<ServiceTreeTable.PUNode> puChildNodes = new ArrayList<ServiceTreeTable.PUNode>(childCount);
            for (childIndex = 0; childIndex < childCount; ++childIndex) {
                puChildNodes.add((ServiceTreeTable.PUNode)gscNode.getChildAt(childIndex));
            }
            for (childIndex = 0; childIndex < childCount; ++childIndex) {
                ServiceTreeTable.PUNode puNode = (ServiceTreeTable.PUNode)puChildNodes.get(childIndex);
                String operStringName = puNode.getOperationalStringName();
                ServiceRecord serviceRecord = (ServiceRecord)puNode.getUserObject();
                Uuid uuid = serviceRecord.getServiceID();
                ServiceID puInstanceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                ArrayList<ServiceID> removedPUInstanceIds = (ArrayList<ServiceID>)operStringNameMap.get(operStringName);
                if (removedPUInstanceIds == null) {
                    removedPUInstanceIds = new ArrayList<ServiceID>();
                    operStringNameMap.put(operStringName, removedPUInstanceIds);
                }
                removedPUInstanceIds.add(puInstanceID);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "--removeService method, serviceID=" + removedServiceID);
                    _logger.log(Level.FINE, "" + removedServiceID + " " + JSpaceUtilities.getStackTrace((Throwable)new Exception("DEBUG removeService")));
                }
                this.clear(puInstanceID);
            }
            Set entrySet = operStringNameMap.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                String opStringName = (String)mapEntry.getKey();
                List removedPUInstanceIds = (List)mapEntry.getValue();
                this._mainUI.removePUInstances(removedPUInstanceIds, opStringName);
            }
            this.removeNodeFromParent(gscNode);
            isRemoved = true;
        }
        if (this.clear(removedServiceID)) {
            isRemoved = true;
        }
        return isRemoved;
    }

    public boolean clear(ServiceID removedServiceID) {
        boolean isRemoved = false;
        MutableTreeNode treeNode = this._serviceRecordsNodesMap.remove(removedServiceID);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("---BEFORE IF( treeNode != null ) removeService method,  treeNode=" + treeNode + ",  serviceid=" + removedServiceID);
        }
        if (treeNode != null) {
            isRemoved = true;
            int childCount = treeNode.getChildCount();
            int index = childCount - 1;
            while (index >= 0) {
                MutableTreeNode childNode = (MutableTreeNode)treeNode.getChildAt(index);
                treeNode.remove(childNode);
                this.nodesWereRemoved(treeNode, new int[]{index--}, new TreeNode[]{childNode});
            }
            MutableTreeNode parentTreeNode = (MutableTreeNode)treeNode.getParent();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("---removeService method,  treeNode=" + treeNode + ",  BEFORE IF  parentTreeNode=" + parentTreeNode);
            }
            if (parentTreeNode != null) {
                int index2 = parentTreeNode.getIndex(treeNode);
                parentTreeNode.remove(treeNode);
                this.nodesWereRemoved(parentTreeNode, new int[]{index2}, new TreeNode[]{treeNode});
            }
        }
        return isRemoved;
    }

    public int getGSCsInUseCount() {
        int inUse = 0;
        for (DefaultMutableTreeNode gscTreeNode : this._gscsNodesMap.values()) {
            GSCHolder gscHolder = (GSCHolder)gscTreeNode.getUserObject();
            if (gscHolder.getServiceRecords(false).length <= 0) continue;
            ++inUse;
        }
        return inUse;
    }

    public List<ServiceItem> getGSCItemsList() {
        ArrayList<ServiceItem> list = new ArrayList<ServiceItem>();
        for (DefaultMutableTreeNode gscTreeNode : this._gscsNodesMap.values()) {
            GSCHolder gscHolder = (GSCHolder)gscTreeNode.getUserObject();
            list.add(gscHolder.getServiceItem());
        }
        return list;
    }

    public ServiceRecordWrapper[] getServiceRecords(boolean b) {
        ArrayList<ServiceRecordWrapper> serviceRecordWrappersList = new ArrayList<ServiceRecordWrapper>();
        for (DefaultMutableTreeNode gscTreeNode : this._gscsNodesMap.values()) {
            GSCHolder gscHolder = (GSCHolder)gscTreeNode.getUserObject();
            ServiceRecord[] serviceRecords = gscHolder.getServiceRecords(b);
            serviceRecordWrappersList.add(new ServiceRecordWrapper(gscHolder.getServiceItem(), serviceRecords));
        }
        ServiceRecordWrapper[] resultArray = new ServiceRecordWrapper[serviceRecordWrappersList.size()];
        return serviceRecordWrappersList.toArray(resultArray);
    }

    public String getGscOwnerName(ServiceID puInstanceServiceID) {
        DefaultMutableTreeNode puInstanceNode = this._serviceRecordsNodesMap.get(puInstanceServiceID);
        String gscName = null;
        if (puInstanceNode != null) {
            DefaultMutableTreeNode gscNode = (DefaultMutableTreeNode)puInstanceNode.getParent();
            GSCHolder gscHolder = (GSCHolder)gscNode.getUserObject();
            gscName = gscHolder.getPresentationName(false);
        }
        return gscName;
    }

    public ServiceID getGscOwnerServiceID(ServiceID puInstanceServiceID) {
        DefaultMutableTreeNode puInstanceNode = this._serviceRecordsNodesMap.get(puInstanceServiceID);
        ServiceID serviceID = null;
        if (puInstanceNode != null) {
            DefaultMutableTreeNode gscNode = (DefaultMutableTreeNode)puInstanceNode.getParent();
            GSCHolder gscHolder = (GSCHolder)gscNode.getUserObject();
            serviceID = gscHolder.getServiceItem().serviceID;
        }
        return serviceID;
    }

    public void addService(ServiceItem item) {
        if (item.service instanceof GSC) {
            this.createGSCNodeIfNeededGSC(item);
        } else {
            this.createServiceNode(item);
        }
    }

    public static class ServiceRecordWrapper {
        private ServiceItem _gscItem;
        private ServiceRecord[] _serviceRecords;
        private Set<ServiceID> _serviceRecordIDsSet = new HashSet<ServiceID>();

        public ServiceRecordWrapper(ServiceItem gscItem, ServiceRecord[] serviceRecords) {
            this._gscItem = gscItem;
            for (ServiceRecord serviceRecord : this._serviceRecords = serviceRecords) {
                Uuid id = serviceRecord.getServiceID();
                this._serviceRecordIDsSet.add(new ServiceID(id.getMostSignificantBits(), id.getLeastSignificantBits()));
            }
        }

        public ServiceItem getGscItem() {
            return this._gscItem;
        }

        public ServiceRecord[] getServiceRecords() {
            return this._serviceRecords;
        }

        public Set<ServiceID> getServiceRecordIDsSet() {
            return this._serviceRecordIDsSet;
        }
    }

    public static class GSCHolder {
        ServiceItem item;
        Cybernode cybernode;
        CybernodeAdmin admin;
        ComputeResourceUtilization cru;
        ApplianceInfo aInfo;
        String hostName;
        String hostAddress;
        ServiceRecord[] records;
        String[] zones;
        private JMenuItem _jConsoleMenuItem;
        private JMenuItem _jVisualVmMenuItem;
        private HostGSCsComponent _hostGSCsComponent;
        private Name serviceName;
        private boolean isManuallyRemovedFromPanel;
        private boolean isSecuredService;

        public GSCHolder(ServiceItem item, HostGSCsComponent hostGSCsComponent) throws RemoteException {
            block2: {
                this.isSecuredService = false;
                this.item = item;
                this._hostGSCsComponent = hostGSCsComponent;
                this.cybernode = (Cybernode)item.service;
                this.updateHolder(item);
                this.admin = (CybernodeAdmin)this.cybernode.getAdmin();
                try {
                    this.isSecuredService = ((SecuredService)this.cybernode).isServiceSecured();
                    this.hostAddress = JSpaceUtilities.retriveHostAddress((NIOInfoProvider)((NIOInfoProvider)this.cybernode));
                    this.hostName = JSpaceUtilities.retriveHostName((NIOInfoProvider)((NIOInfoProvider)this.cybernode));
                    this.zones = ((GridZoneProvider)this.cybernode).getZones();
                }
                catch (RemoteException re) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, re.toString(), re);
                }
            }
            String jmxServiceUrl = JSpaceUtilities.getJMXConnectionUrl((ServiceItem)item);
            boolean isJmxRemotePortDefined = JSpaceUtilities.isJMXRemotePortDefined((ServiceItem)item);
            this._jConsoleMenuItem = new JMenuItem("Launch JConsole...");
            this._jVisualVmMenuItem = new JMenuItem("Launch VisualVM...");
            JConsoleUIUtils.manageJConsoleMenuItem(hostGSCsComponent.getParentFrame(), this._jConsoleMenuItem, jmxServiceUrl, !isJmxRemotePortDefined, _logger, true, true, hostGSCsComponent.getParentFrame());
            JConsoleUIUtils.manageJVisualVmMenuItem(hostGSCsComponent.getParentFrame(), this._jVisualVmMenuItem, jmxServiceUrl, _logger, true, true, hostGSCsComponent.getParentFrame(), false);
        }

        public JMenuItem getJConsoleMenuItem() {
            return this._jConsoleMenuItem;
        }

        public JMenuItem getJVisualVmMenuItem() {
            return this._jVisualVmMenuItem;
        }

        public HostGSCsComponent getHostGSCsComponent() {
            return this._hostGSCsComponent;
        }

        public void removeService(ServiceID serviceID) {
            for (ServiceRecord serviceRecord : this.records) {
                Uuid uuid = serviceRecord.getServiceID();
                ServiceID servID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                if (!serviceID.equals((Object)servID)) continue;
                List list = this.copyServiceRecordArrayToList();
                list.remove(serviceRecord);
                this.records = list.toArray(new ServiceRecord[list.size()]);
                break;
            }
        }

        private List copyServiceRecordArrayToList() {
            ArrayList<ServiceRecord> list = new ArrayList<ServiceRecord>(this.records.length);
            for (ServiceRecord serviceRecord : this.records) {
                list.add(serviceRecord);
            }
            return list;
        }

        public boolean equals(Object obj) {
            GSCHolder gscHolder = (GSCHolder)obj;
            return this.item.serviceID.equals((Object)gscHolder.getServiceItem().serviceID);
        }

        public int hashCode() {
            return this.item.serviceID.hashCode();
        }

        public boolean isSecuredService() {
            return this.isSecuredService;
        }

        void updateHolder(ServiceItem item) {
            this.item = item;
            this.initServiceBasicProperties();
        }

        public void updateHolder() {
            this._hostGSCsComponent.reloadServices();
            this._hostGSCsComponent.repaint();
        }

        public ServiceRecord[] getServiceRecords(boolean refresh) {
            if (refresh || this.records == null) {
                try {
                    this.records = this.cybernode.getServiceRecords(1);
                }
                catch (RemoteException e) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, e.toString(), e);
                    }
                    this._hostGSCsComponent.getGSCPanel().remove(this.item);
                    String addr = "unknown";
                    if (this._hostGSCsComponent.getHostAddress() != null) {
                        addr = this._hostGSCsComponent.getHostAddress();
                    }
                    String s = ResourceBundleHandler.getInstance().getResource("tooltip.GridServiceContainerAt");
                    System.out.println(s + "[" + addr + "] unreachable");
                }
            }
            return this.records;
        }

        public ServiceRecord getServiceRecord(Uuid serviceUid) {
            for (ServiceRecord serviceRecord : this.records) {
                Uuid serviceRecordUid = serviceRecord.getServiceID();
                if (!serviceRecordUid.equals((Object)serviceUid)) continue;
                return serviceRecord;
            }
            return null;
        }

        private void initServiceBasicProperties() {
            for (int i = 0; i < this.item.attributeSets.length; ++i) {
                if (!(this.item.attributeSets[i] instanceof Name)) continue;
                this.serviceName = (Name)this.item.attributeSets[i];
                break;
            }
        }

        public ServiceItem getServiceItem() {
            return this.item;
        }

        public Name getServiceName() {
            return this.serviceName;
        }

        public boolean isManuallyRemovedFromPanel() {
            return this.isManuallyRemovedFromPanel;
        }

        public void setManuallyRemovedFromPanel(boolean isManuallyRemovedFromPanel) {
            this.isManuallyRemovedFromPanel = isManuallyRemovedFromPanel;
        }

        public String getPresentationName(boolean includingZones) {
            int gsAgentId = Repository.getInstance().getGSAgentID(this.item.serviceID);
            JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(this.item, true);
            long pid = -1L;
            if (jvmDetails != null) {
                pid = jvmDetails.getPid();
            }
            if (includingZones) {
                return JSpaceUtilities.createServiceName((String)"gsc", (int)gsAgentId, (long)pid, (String[])this.zones);
            }
            return JSpaceUtilities.createServiceName((String)"gsc", (int)gsAgentId, (long)pid);
        }
    }

    static class ServiceUserObject {
        private ServiceItem _serviceItem;
        private long _pid;
        private boolean _isSecured;
        private int _gsaAgentID;
        private String _gsaOwnerServiceID;
        private String _serviceName;
        private String[] _zones;

        public ServiceUserObject(ServiceItem serviceItem, String serviceName) {
            block19: {
                Object service;
                block18: {
                    block17: {
                        block16: {
                            this._serviceItem = serviceItem;
                            this._serviceName = serviceName;
                            service = serviceItem.service;
                            JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(serviceItem, true);
                            this._gsaAgentID = Repository.getInstance().getGSAgentID(this._serviceItem.serviceID);
                            if (jvmDetails != null) {
                                this._pid = jvmDetails.getPid();
                            }
                            if (this._serviceItem.service instanceof ServiceRegistrar) {
                                service = ((ServiceRegistrar)service).getRegistrar();
                            }
                            if (service instanceof GridZoneProvider) {
                                try {
                                    this._zones = ((GridZoneProvider)service).getZones();
                                }
                                catch (RemoteException re) {
                                    if (!_logger.isLoggable(Level.SEVERE)) break block16;
                                    _logger.log(Level.SEVERE, re.toString(), re);
                                }
                            }
                        }
                        if (service instanceof AgentIdAware) {
                            try {
                                this._gsaOwnerServiceID = ((AgentIdAware)service).getGSAServiceID();
                            }
                            catch (RemoteException re) {
                                if (!_logger.isLoggable(Level.SEVERE)) break block17;
                                _logger.log(Level.SEVERE, re.toString(), re);
                            }
                        }
                    }
                    if (service instanceof SecuredService) {
                        try {
                            this._isSecured = ((SecuredService)service).isServiceSecured();
                        }
                        catch (RemoteException re) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block18;
                            _logger.log(Level.SEVERE, re.toString(), re);
                        }
                    }
                }
                if (this._serviceItem.service instanceof ServiceRegistrar) {
                    service = ((ServiceRegistrar)this._serviceItem.service).getRegistrar();
                    ServiceItem gsaOwnerServiceItem = Repository.getInstance().getGSAServiceItem(this._gsaOwnerServiceID);
                    if (gsaOwnerServiceItem == null && this._gsaOwnerServiceID != null && this._gsaOwnerServiceID.trim().length() > 0) {
                        Uuid uuid = UuidFactory.create((String)this._gsaOwnerServiceID);
                        ServiceID gsaOwnerServiceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                        gsaOwnerServiceItem = MainUI.lookupServiceItem(gsaOwnerServiceID);
                    }
                    if (gsaOwnerServiceItem != null) {
                        try {
                            this._isSecured = ((SecuredService)gsaOwnerServiceItem.service).isServiceSecured();
                        }
                        catch (RemoteException re) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block19;
                            _logger.log(Level.SEVERE, re.toString(), re);
                        }
                    }
                }
            }
        }

        public int hashCode() {
            return this._serviceItem.serviceID.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceUserObject other = (ServiceUserObject)obj;
            return !(this._serviceItem == null ? other._serviceItem != null : !this._serviceItem.serviceID.equals((Object)other._serviceItem.serviceID));
        }

        public long getPid() {
            return this._pid;
        }

        public String getGSAOwnerServiceID() {
            return this._gsaOwnerServiceID;
        }

        public int getGSAAgentID() {
            return this._gsaAgentID;
        }

        public ServiceItem getServiceItem() {
            return this._serviceItem;
        }

        public boolean isSecured() {
            return this._isSecured;
        }

        public void setSecured(boolean secured) {
            this._isSecured = secured;
        }

        public String toString() {
            return JSpaceUtilities.createServiceName((String)this._serviceName, (int)this._gsaAgentID, (long)this._pid, (String[])this._zones);
        }
    }
}

