/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.gsc.GSCPanel;
import com.gigaspaces.admin.ui.views.hosts.HostsViewPanel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ServicesInstancesInfoPanel
extends JPanel {
    private GSCPanel _gscPanel;
    private HostsViewPanel _hostsView;
    private Font _boldFont;
    private Font _regularFont;
    private static final String GSC_TOTAL_LABEL = "Total GSCs:";
    private static final String GSC_USED_LABEL = "Used GSCs:";
    private static final String LUS_TOTAL_LABEL = "Total LUS:";
    private static final String GSA_TOTAL_LABEL = "Total GSAs:";
    private static final String GSM_TOTAL_LABEL = "Total GSMs:";
    private static final String MANAGERS_TOTAL_LABEL = "Total Managers:";
    private static final String HOSTS_TOTAL_LABEL = "Total Hosts:";
    private static final int LEFT_MARGIN = 3;
    private static final int SENTENCES_MARGIN = 10;
    private static final int BASE_LINE = 16;

    public ServicesInstancesInfoPanel(GSCPanel gscPanel, HostsViewPanel hostsView) {
        this._gscPanel = gscPanel;
        this._hostsView = hostsView;
        this._regularFont = UIManager.getFont("Label.font");
        this._boldFont = new Font(this._regularFont.getName(), 1, this._regularFont.getSize());
        this.setDoubleBuffered(true);
        Dimension size = new Dimension(700, 20);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = g.getFontMetrics(this._regularFont);
        int totalGSA = Repository.getInstance().getGSACount();
        int totalGSM = Repository.getInstance().getMonitorCount();
        int totalManagers = Repository.getInstance().getManagersCount();
        int usedGSC = this._gscPanel.getGSCsInUseCount();
        int totalGSC = this._gscPanel.getGSCCount();
        int totalLUS = Repository.getInstance().getLookups().length;
        int totalHosts = this._hostsView.getHostsCount();
        int sLen = fontMetrics.stringWidth(GSA_TOTAL_LABEL);
        g.setFont(this._regularFont);
        g.drawString(GSA_TOTAL_LABEL, 3, 16);
        g.setFont(this._boldFont);
        int x = 3 + sLen + 3;
        g.drawString(String.valueOf(totalGSA), x, 16);
        x = x + 10 + fontMetrics.stringWidth(String.valueOf(totalGSA));
        sLen = fontMetrics.stringWidth(GSM_TOTAL_LABEL);
        g.setFont(this._regularFont);
        g.drawString(GSM_TOTAL_LABEL, x + 3, 16);
        g.setFont(this._boldFont);
        x = x + 3 + sLen + 3;
        g.drawString(String.valueOf(totalGSM), x, 16);
        x = x + 10 + fontMetrics.stringWidth(String.valueOf(totalGSM));
        sLen = fontMetrics.stringWidth(LUS_TOTAL_LABEL);
        g.setFont(this._regularFont);
        g.drawString(LUS_TOTAL_LABEL, x + 3, 16);
        g.setFont(this._boldFont);
        x = x + 3 + sLen + 3;
        g.drawString(String.valueOf(totalLUS), x, 16);
        x = x + 10 + fontMetrics.stringWidth(String.valueOf(totalLUS));
        sLen = fontMetrics.stringWidth(GSC_TOTAL_LABEL);
        g.setFont(this._regularFont);
        g.drawString(GSC_TOTAL_LABEL, x + 3, 16);
        g.setFont(this._boldFont);
        x = x + 3 + sLen + 3;
        g.drawString(String.valueOf(totalGSC), x, 16);
        x = x + 10 + fontMetrics.stringWidth(String.valueOf(totalGSC));
        sLen = fontMetrics.stringWidth(GSC_USED_LABEL);
        g.setFont(this._regularFont);
        g.drawString(GSC_USED_LABEL, x + 3, 16);
        g.setFont(this._boldFont);
        x = x + 3 + sLen + 3;
        g.drawString(String.valueOf(usedGSC), x, 16);
        x = x + 10 + fontMetrics.stringWidth(String.valueOf(usedGSC));
        sLen = fontMetrics.stringWidth(MANAGERS_TOTAL_LABEL);
        g.setFont(this._regularFont);
        g.drawString(MANAGERS_TOTAL_LABEL, x + 3, 16);
        g.setFont(this._boldFont);
        x = x + 3 + sLen + 3;
        g.drawString(String.valueOf(totalManagers), x, 16);
        sLen = fontMetrics.stringWidth(HOSTS_TOTAL_LABEL);
        g.setFont(this._regularFont);
        g.drawString(HOSTS_TOTAL_LABEL, x + 21, 16);
        g.setFont(this._boldFont);
        x = x + 3 + sLen + 21;
        g.drawString(String.valueOf(totalHosts), x, 16);
    }
}

