/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc.utils;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TypePlainDocument
extends PlainDocument {
    private int documentType;
    public static final int DT_INT = 1;
    public static final int DT_LONG = 2;
    public static final int DT_FLOAT = 3;
    public static final int DT_DOUBLE = 4;
    public static final int DT_STRING = 5;

    public TypePlainDocument(int docType) {
        this.documentType = docType;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (!this.isValid(offset, str)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.insertString(offset, str, a);
        }
    }

    private boolean isValid(int offs, String str) throws BadLocationException {
        String currStr = this.getText(0, this.getLength());
        String newStr = currStr.substring(0, offs) + str + currStr.substring(offs, currStr.length());
        if (newStr.length() == 0) {
            return true;
        }
        try {
            switch (this.documentType) {
                case 4: {
                    Double.parseDouble(newStr);
                    break;
                }
                case 3: {
                    Float.parseFloat(newStr);
                    break;
                }
                case 1: {
                    Integer.parseInt(newStr);
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    Long.parseLong(newStr);
                }
            }
        }
        catch (NumberFormatException ee) {
            return false;
        }
        return true;
    }
}

