/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc.utils;

public class Utils {
    public static final String EMPTY = "";
    public static final String EQUAL = "=";
    public static final String GREATER = ">";
    public static final String EQUAL_GREATER = ">=";
    public static final String LESS = "<";
    public static final String EQUAL_LESS = "<=";
    public static final String NOT_EQUAL = "!=";
    public static final int COMPARE_TYPE_EMPTY = 1;
    public static final int COMPARE_TYPE_EQUAL = 2;
    public static final int COMPARE_TYPE_GREATER = 3;
    public static final int COMPARE_TYPE_EQUAL_GREATER = 4;
    public static final int COMPARE_TYPE_LESS = 5;
    public static final int COMPARE_TYPE_EQUAL_LESS = 6;
    public static final int COMPARE_TYPE_NOT_EQUAL = 7;
    public static final String[] COMPARISON_TYPES = new String[]{"", "=", ">", ">=", "<", "<=", "!="};

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        return string.equals(EMPTY);
    }

    public static boolean isEmpty(String string, boolean isWithTrim) {
        if (null == string) {
            return true;
        }
        return isWithTrim ? Utils.isEmpty(string.trim()) : Utils.isEmpty(string);
    }

    public static boolean isStringEquals(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (Utils.isEmpty(str1) && Utils.isEmpty(str2)) {
            return true;
        }
        if (str1 == null && str2 != null || str1 != null && str2 == null) {
            return false;
        }
        return str1.trim().equals(str2.trim());
    }

    public static int convertCompareType(String compareOperation) {
        if (compareOperation.equals(EQUAL)) {
            return 2;
        }
        if (compareOperation.equals(EQUAL_GREATER)) {
            return 4;
        }
        if (compareOperation.equals(EQUAL_LESS)) {
            return 6;
        }
        if (compareOperation.equals(LESS)) {
            return 5;
        }
        if (compareOperation.equals(GREATER)) {
            return 3;
        }
        if (compareOperation.equals(NOT_EQUAL)) {
            return 7;
        }
        return 1;
    }

    public static String convertCompareType(int compareType) {
        switch (compareType) {
            case 2: {
                return EQUAL;
            }
            case 4: {
                return EQUAL_GREATER;
            }
            case 3: {
                return GREATER;
            }
            case 6: {
                return EQUAL_LESS;
            }
            case 5: {
                return LESS;
            }
            case 7: {
                return NOT_EQUAL;
            }
        }
        return EMPTY;
    }
}

