/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.space;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SpaceConfigurationPanel
extends JPanel {
    private static final Dimension labelSize = new Dimension(150, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension textFieldSize = new Dimension(270, 23);
    private static final Dimension maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension minTextFieldSize = new Dimension(20, 23);
    private static final int LEFT_ALLIGN = 3;
    private static final int RIGHT_ALLIGN = 3;
    private JLabel evictionBatchSizeLabel;
    private JLabel cacheSizeLabel;
    private JTextField _spaceNameTextField;
    private JTextField _instanceIdTextField;
    private JTextField _spaceSchemaNameTextField;
    private JTextField _clusterSchemaNameTextField;
    private JTextField _securedTextField;
    private JTextField _evictionPolicyTextField;
    private JTextField _evictionBatchSizeTextField;
    private JTextField _cacheSizeTextField;
    private JTextField _memoryManagerStateTextField;
    private JTextField _highWatermarkTextField;
    private JTextField _lowWatermarkTextField;
    private JTextField _writeOperationRejectionTextField;
    private JTextField _writeOperationInspectionTextField;
    private JTextField _homeDirectoryTextField;
    private JTextField _hostNameTextField;
    private JTextField _lookupGroupsTextField;
    private JTextField _rmiPortTextField;
    private JTextField _locatorsTextField;
    private JTextField _jmxServiceUrlTextField;
    private JTextField _suspendTypeTextField;
    private Box _curBlobStoreSection;
    private static final String EVICTION_POLICY_LRU = "LRU";
    private static final String EVICTION_POLICY_ALL_IN_CACHE = "All in Cache";
    private static final String EVICTION_POLICY_CUSTOM = "Custom";
    private static final String EVICTION_POLICY_BLOBSTORE = "Blob Store";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public SpaceConfigurationPanel() {
        Box generalSectionBox = this.createGeneralSection();
        Box memoryManagementBox = this.createMemoryManagementSection();
        Box networkSection = this.createNetworkSection();
        this.setLayout(new GridLayout(2, 2));
        this.add(generalSectionBox);
        this.add(networkSection);
        this.add(memoryManagementBox);
        this.setPreferredSize(new Dimension(4000, 3000));
    }

    public void setSpace(IJSpace space) {
        block4: {
            this.clear();
            ContainerConfig containerConfig = null;
            try {
                IJSpaceContainerAdmin spaceContainerAdmin = (IJSpaceContainerAdmin)space.getDirectProxy().getContainer();
                containerConfig = Repository.addContainerToMap(spaceContainerAdmin);
                IRemoteJSpaceAdmin spaceAdmin = null;
                SpaceConfig spaceConfig = null;
                try {
                    spaceAdmin = Repository.addSpaceAdminObjectToMap(space);
                    spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                }
                catch (SpaceSecurityException spaceSecurityException) {
                    // empty catch block
                }
                this.refresh(space, spaceAdmin, spaceConfig, containerConfig);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public void clear() {
        this._spaceNameTextField.setText("");
        this._instanceIdTextField.setText("");
        this._spaceSchemaNameTextField.setText("");
        this._clusterSchemaNameTextField.setText("");
        this._securedTextField.setText("");
        this._evictionPolicyTextField.setText("");
        this._evictionBatchSizeTextField.setText("");
        this._cacheSizeTextField.setText("");
        this._memoryManagerStateTextField.setText("");
        this._highWatermarkTextField.setText("");
        this._lowWatermarkTextField.setText("");
        this._writeOperationRejectionTextField.setText("");
        this._writeOperationInspectionTextField.setText("");
        this._homeDirectoryTextField.setText("");
        this._hostNameTextField.setText("");
        this._lookupGroupsTextField.setText("");
        this._rmiPortTextField.setText("");
        this._locatorsTextField.setText("");
        this._suspendTypeTextField.setText("");
    }

    private void refresh(IJSpace space, IRemoteJSpaceAdmin spaceAdmin, SpaceConfig spaceConfig, ContainerConfig containerConfig) {
        block13: {
            SpaceURL spaceURL = space.getURL();
            String spaceInstanceId = JSpaceUIUtils.getSpaceInstanceID(space);
            this._instanceIdTextField.setText(spaceInstanceId);
            boolean isBlobStoreCachePolicy = false;
            if (spaceConfig != null) {
                String evictionModeLabel;
                String spaceSchemaName = spaceConfig.getSchemaName();
                this._spaceSchemaNameTextField.setText(spaceSchemaName);
                SpaceClusterInfo clusterInfo = spaceConfig.getClusterInfo();
                if (clusterInfo.isClustered()) {
                    this._clusterSchemaNameTextField.setText(clusterInfo.getClusterSchema());
                }
                int evictionMode = Integer.parseInt(spaceConfig.getProperty("space-config.engine.cache_policy"));
                boolean isLRUCachePolicy = false;
                switch (evictionMode) {
                    case 0: {
                        evictionModeLabel = EVICTION_POLICY_LRU;
                        isLRUCachePolicy = true;
                        break;
                    }
                    case 1: {
                        evictionModeLabel = EVICTION_POLICY_ALL_IN_CACHE;
                        break;
                    }
                    case 2: {
                        evictionModeLabel = EVICTION_POLICY_CUSTOM;
                        break;
                    }
                    case 3: {
                        evictionModeLabel = EVICTION_POLICY_BLOBSTORE;
                        isBlobStoreCachePolicy = true;
                        break;
                    }
                    default: {
                        evictionModeLabel = "n/a";
                    }
                }
                this._evictionPolicyTextField.setText(evictionModeLabel);
                this._evictionBatchSizeTextField.setText(isLRUCachePolicy ? spaceConfig.getProperty("space-config.engine.memory_usage.eviction_batch_size") : "");
                this._cacheSizeTextField.setText(isLRUCachePolicy ? spaceConfig.getCacheManagerSize() : "");
                this._evictionBatchSizeTextField.setEnabled(isLRUCachePolicy);
                this._cacheSizeTextField.setEnabled(isLRUCachePolicy);
                this.cacheSizeLabel.setEnabled(isLRUCachePolicy);
                this.evictionBatchSizeLabel.setEnabled(isLRUCachePolicy);
                this._memoryManagerStateTextField.setText(Boolean.parseBoolean(spaceConfig.isEngineMemoryUsageEnabled()) ? "Enabled" : "Disabled");
                this._highWatermarkTextField.setText(spaceConfig.getEngineMemoryUsageHighPercentageRatio() + "%");
                this._lowWatermarkTextField.setText(spaceConfig.getEngineMemoryUsageLowPercentageRatio() + "%");
                this._writeOperationRejectionTextField.setText(spaceConfig.getEngineMemoryUsageWriteOnlyBlockPercentageRatio() + "%");
                this._writeOperationInspectionTextField.setText(spaceConfig.getEngineMemoryWriteOnlyCheckPercentageRatio() + "%");
            }
            this._spaceNameTextField.setText(space.getName());
            this._securedTextField.setText(space.isSecured() ? "Yes" : "No");
            this._homeDirectoryTextField.setText(containerConfig.homeDir);
            this._homeDirectoryTextField.setToolTipText(containerConfig.homeDir);
            this._homeDirectoryTextField.setCaretPosition(0);
            this._lookupGroupsTextField.setText(containerConfig.lookupGroups);
            String jndiURL = containerConfig.jndiUrl;
            int delimiterIndex = jndiURL.indexOf(":");
            String hostName = jndiURL;
            String port = "";
            if (delimiterIndex > 0) {
                hostName = jndiURL.substring(0, delimiterIndex);
                port = jndiURL.substring(delimiterIndex + 1);
            }
            this._hostNameTextField.setText(hostName);
            this._rmiPortTextField.setText(port);
            String locators = spaceURL.getProperty("locators");
            this._locatorsTextField.setText(locators);
            String jmxServiceURL = JMXUtilities.createJMXUrl((String)jndiURL);
            this._jmxServiceUrlTextField.setText(jmxServiceURL);
            if (this._curBlobStoreSection != null) {
                this.remove(this._curBlobStoreSection);
            }
            if (isBlobStoreCachePolicy) {
                Properties blobStoreProperties = spaceConfig.getBlobStoreProperties();
                Box blobStoreSection = this.createBlobStoreSection(blobStoreProperties);
                this.add(blobStoreSection);
                this._curBlobStoreSection = blobStoreSection;
            }
            try {
                this._suspendTypeTextField.setText(SpaceBrowser.getSuspendTypeName((IInternalRemoteJSpaceAdmin)spaceAdmin));
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block13;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private Box createNetworkSection() {
        Box vertBox = new Box(1);
        JLabel homeDirectoryLabel = this.createLabel("Home Directory:");
        this._homeDirectoryTextField = this.createTextField();
        Box homeDirectoryBox = new Box(0);
        homeDirectoryBox.add(Box.createHorizontalStrut(3));
        homeDirectoryBox.add(homeDirectoryLabel);
        homeDirectoryBox.add(this._homeDirectoryTextField);
        homeDirectoryBox.add(Box.createHorizontalStrut(3));
        JLabel hostNameLabel = this.createLabel("Host Name:");
        this._hostNameTextField = this.createTextField();
        Box hostNameBox = new Box(0);
        hostNameBox.add(Box.createHorizontalStrut(3));
        hostNameBox.add(hostNameLabel);
        hostNameBox.add(this._hostNameTextField);
        hostNameBox.add(Box.createHorizontalStrut(3));
        JLabel lookupGroupsLabel = this.createLabel("Lookup Groups:");
        this._lookupGroupsTextField = this.createTextField();
        Box lookupGroupsBox = new Box(0);
        lookupGroupsBox.add(Box.createHorizontalStrut(3));
        lookupGroupsBox.add(lookupGroupsLabel);
        lookupGroupsBox.add(this._lookupGroupsTextField);
        lookupGroupsBox.add(Box.createHorizontalStrut(3));
        JLabel rmiPortLabel = this.createLabel("RMI Registry Port:");
        this._rmiPortTextField = this.createTextField();
        Box rmiPortBox = new Box(0);
        rmiPortBox.add(Box.createHorizontalStrut(3));
        rmiPortBox.add(rmiPortLabel);
        rmiPortBox.add(this._rmiPortTextField);
        rmiPortBox.add(Box.createHorizontalStrut(3));
        JLabel locatorsLabel = this.createLabel("Locators:");
        this._locatorsTextField = this.createTextField();
        Box locatorsBox = new Box(0);
        locatorsBox.add(Box.createHorizontalStrut(3));
        locatorsBox.add(locatorsLabel);
        locatorsBox.add(this._locatorsTextField);
        locatorsBox.add(Box.createHorizontalStrut(3));
        JLabel jmxServiceUrlLabel = this.createLabel("JMX service URL:");
        this._jmxServiceUrlTextField = this.createTextField();
        Box jmxServiceUrlBox = new Box(0);
        jmxServiceUrlBox.add(Box.createHorizontalStrut(3));
        jmxServiceUrlBox.add(jmxServiceUrlLabel);
        jmxServiceUrlBox.add(this._jmxServiceUrlTextField);
        jmxServiceUrlBox.add(Box.createHorizontalStrut(3));
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(homeDirectoryBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(hostNameBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(lookupGroupsBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(rmiPortBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(locatorsBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(jmxServiceUrlBox);
        vertBox.add(Box.createVerticalStrut(10));
        this.setBorder(vertBox, "Network & Environment");
        return vertBox;
    }

    private Box createMemoryManagementSection() {
        Box vertBox = new Box(1);
        JLabel evictionPolicyLabel = this.createLabel("Eviction Policy:");
        this._evictionPolicyTextField = this.createTextField();
        Box evictionPolicyBox = new Box(0);
        evictionPolicyBox.add(Box.createHorizontalStrut(3));
        evictionPolicyBox.add(evictionPolicyLabel);
        evictionPolicyBox.add(this._evictionPolicyTextField);
        evictionPolicyBox.add(Box.createHorizontalStrut(3));
        this.evictionBatchSizeLabel = this.createLabel("LRU Eviction Batch Size:");
        this._evictionBatchSizeTextField = this.createTextField();
        Box evictionBatchSizeBox = new Box(0);
        evictionBatchSizeBox.add(Box.createHorizontalStrut(3));
        evictionBatchSizeBox.add(this.evictionBatchSizeLabel);
        evictionBatchSizeBox.add(this._evictionBatchSizeTextField);
        evictionBatchSizeBox.add(Box.createHorizontalStrut(3));
        this.cacheSizeLabel = this.createLabel("Cache Size:");
        this._cacheSizeTextField = this.createTextField();
        Box cacheSizeBox = new Box(0);
        cacheSizeBox.add(Box.createHorizontalStrut(3));
        cacheSizeBox.add(this.cacheSizeLabel);
        cacheSizeBox.add(this._cacheSizeTextField);
        cacheSizeBox.add(Box.createHorizontalStrut(3));
        JLabel memoryManagerStateLabel = this.createLabel("Memory Manager State:");
        this._memoryManagerStateTextField = this.createTextField();
        Box memoryManagerStateBox = new Box(0);
        memoryManagerStateBox.add(Box.createHorizontalStrut(3));
        memoryManagerStateBox.add(memoryManagerStateLabel);
        memoryManagerStateBox.add(this._memoryManagerStateTextField);
        memoryManagerStateBox.add(Box.createHorizontalStrut(3));
        JLabel highWatermarkLabel = this.createLabel("High Watermark:");
        this._highWatermarkTextField = this.createTextField();
        Box highWatermarkBox = new Box(0);
        highWatermarkBox.add(Box.createHorizontalStrut(3));
        highWatermarkBox.add(highWatermarkLabel);
        highWatermarkBox.add(this._highWatermarkTextField);
        highWatermarkBox.add(Box.createHorizontalStrut(3));
        JLabel lowWatermarkLabel = this.createLabel("Low Watermark:");
        this._lowWatermarkTextField = this.createTextField();
        Box lowWatermarkBox = new Box(0);
        lowWatermarkBox.add(Box.createHorizontalStrut(3));
        lowWatermarkBox.add(lowWatermarkLabel);
        lowWatermarkBox.add(this._lowWatermarkTextField);
        lowWatermarkBox.add(Box.createHorizontalStrut(3));
        JLabel writeOperationRejectionLabel = this.createLabel("Write Operation Rejection:");
        this._writeOperationRejectionTextField = this.createTextField();
        Box writeOperationRejectionBox = new Box(0);
        writeOperationRejectionBox.add(Box.createHorizontalStrut(3));
        writeOperationRejectionBox.add(writeOperationRejectionLabel);
        writeOperationRejectionBox.add(this._writeOperationRejectionTextField);
        writeOperationRejectionBox.add(Box.createHorizontalStrut(3));
        JLabel writeOperationInspectionLabel = this.createLabel("Write Operation Inspection:");
        this._writeOperationInspectionTextField = this.createTextField();
        Box writeOperationInspectionBox = new Box(0);
        writeOperationInspectionBox.add(Box.createHorizontalStrut(3));
        writeOperationInspectionBox.add(writeOperationInspectionLabel);
        writeOperationInspectionBox.add(this._writeOperationInspectionTextField);
        writeOperationInspectionBox.add(Box.createHorizontalStrut(3));
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(evictionPolicyBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(evictionBatchSizeBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(cacheSizeBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(memoryManagerStateBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(highWatermarkBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(lowWatermarkBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(writeOperationRejectionBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(writeOperationInspectionBox);
        vertBox.add(Box.createVerticalStrut(2));
        this.setBorder(vertBox, "Memory Management");
        return vertBox;
    }

    private Box createBlobStoreSection(Properties properties) {
        Box vertBox = new Box(1);
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String label = entry.getKey().toString();
            Object value = entry.getValue();
            Box blobStoreFieldBox = this.createBlobStoreFieldBox(label, value);
            vertBox.add(Box.createVerticalStrut(2));
            vertBox.add(blobStoreFieldBox);
        }
        vertBox.add(Box.createVerticalStrut(80));
        this.setBorder(vertBox, EVICTION_POLICY_BLOBSTORE);
        return vertBox;
    }

    private Box createBlobStoreFieldBox(String labelProp, Object value) {
        JLabel blobStoreDevicesLabel = this.createLabel(JSpaceUIUtils.getBlobStorePropertyLabel(labelProp) + ":");
        JTextField textField = this.createTextField();
        textField.setText(value instanceof Boolean ? (((Boolean)value).booleanValue() ? "Yes" : "No") : value.toString());
        Box blobStoreDevicesBox = new Box(0);
        blobStoreDevicesBox.add(Box.createHorizontalStrut(3));
        blobStoreDevicesBox.add(blobStoreDevicesLabel);
        blobStoreDevicesBox.add(textField);
        blobStoreDevicesBox.add(Box.createHorizontalStrut(3));
        return blobStoreDevicesBox;
    }

    private Box createGeneralSection() {
        Box vertBox = new Box(1);
        JLabel spaceNameLabel = this.createLabel("Space Name:");
        this._spaceNameTextField = this.createTextField();
        Box spaceNameBox = new Box(0);
        spaceNameBox.add(Box.createHorizontalStrut(3));
        spaceNameBox.add(spaceNameLabel);
        spaceNameBox.add(this._spaceNameTextField);
        spaceNameBox.add(Box.createHorizontalStrut(3));
        JLabel instanceIdLabel = this.createLabel("Instance Id:");
        this._instanceIdTextField = this.createTextField();
        Box instanceIdBox = new Box(0);
        instanceIdBox.add(Box.createHorizontalStrut(3));
        instanceIdBox.add(instanceIdLabel);
        instanceIdBox.add(this._instanceIdTextField);
        instanceIdBox.add(Box.createHorizontalStrut(3));
        JLabel spaceSchemaNameLabel = this.createLabel("Space Schema:");
        this._spaceSchemaNameTextField = this.createTextField();
        Box spaceSchemaNameBox = new Box(0);
        spaceSchemaNameBox.add(Box.createHorizontalStrut(3));
        spaceSchemaNameBox.add(spaceSchemaNameLabel);
        spaceSchemaNameBox.add(this._spaceSchemaNameTextField);
        spaceSchemaNameBox.add(Box.createHorizontalStrut(3));
        JLabel clusterSchemaNameLabel = this.createLabel("Cluster Schema:");
        this._clusterSchemaNameTextField = this.createTextField();
        Box clusterSchemaNameBox = new Box(0);
        clusterSchemaNameBox.add(Box.createHorizontalStrut(3));
        clusterSchemaNameBox.add(clusterSchemaNameLabel);
        clusterSchemaNameBox.add(this._clusterSchemaNameTextField);
        clusterSchemaNameBox.add(Box.createHorizontalStrut(3));
        JLabel securedLabel = this.createLabel("Secured:");
        this._securedTextField = this.createTextField();
        Box securedBox = new Box(0);
        securedBox.add(Box.createHorizontalStrut(3));
        securedBox.add(securedLabel);
        securedBox.add(this._securedTextField);
        securedBox.add(Box.createHorizontalStrut(3));
        JLabel suspendTypeLabel = this.createLabel("Suspend Type:");
        this._suspendTypeTextField = this.createTextField();
        Box suspendTypeBox = new Box(0);
        suspendTypeBox.add(Box.createHorizontalStrut(3));
        suspendTypeBox.add(suspendTypeLabel);
        suspendTypeBox.add(this._suspendTypeTextField);
        suspendTypeBox.add(Box.createHorizontalStrut(3));
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(spaceNameBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(instanceIdBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(spaceSchemaNameBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(clusterSchemaNameBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(securedBox);
        vertBox.add(Box.createVerticalStrut(2));
        vertBox.add(suspendTypeBox);
        vertBox.add(Box.createVerticalStrut(50));
        this.setBorder(vertBox, "General");
        return vertBox;
    }

    private void setBorder(JComponent component, String borderTitle) {
        component.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), borderTitle));
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        textField.setEditable(false);
        textField.setBackground(SystemColor.control);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }
}

