/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.space;

import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.space.ISearchComponent;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.admin.ui.grid.space.SpaceMonitoringPanel;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.IndicationBox;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceID;
import net.jini.space.InternalSpaceException;

public class SpaceMonitorClassesPanel
extends JPanel
implements IRefreshable {
    private SpaceRuntimeInfo runtime;
    private Border border1;
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    protected MainUI _mainUI;
    private IInternalRemoteJSpaceAdmin _spaceAdmin;
    private IJSpace _spaceProxy;
    private static final String DIALOG_RUNTIME_COLUMN = "dialog.runtime.columnname";
    private JPanel tablePanel;
    static int clickCount = 0;
    protected IndicationBox _indicationBox;
    private String[] resColumn = JSpaceUIUtils.getResources("dialog.runtime.columnname");
    protected JTable table;
    protected RuntimeTableModel model;
    protected InstancesInfoBox _infoBox;
    private boolean _isPersistentLRUSpace = false;
    private SpaceMonitoringPanel _spaceMonitoringPanel;
    protected final int CI_CLASS_NAME = 0;
    protected final int CI_INSTANCES_COUNT = 1;
    protected final int CI_TEMPLATES_COUNT = 2;
    private ServiceID _spaceID;
    private JPopupMenu rightMenu;
    private JMenuItem queryMenu;
    private IConnectionProvider _connectionProvider;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    protected volatile Future<?> refreshThreadTask;
    private boolean _isInvokeRefresh = true;
    private SearchEditor _searchEditor;
    private TreeWorker _treeWorker;

    public SpaceMonitorClassesPanel(MainUI mainUI, TreeWorker treeWorker, SpaceMonitoringPanel spaceMonitoringPanel) {
        this._mainUI = mainUI;
        this._treeWorker = treeWorker;
        this._spaceMonitoringPanel = spaceMonitoringPanel;
        this.model = new RuntimeTableModel();
        this.table = new JTable(this.model);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this._searchEditor = new SearchEditor(this.model);
        Box searchBox = new Box(0);
        searchBox.add(Box.createHorizontalGlue());
        searchBox.add(this._searchEditor);
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.addMouseListener(new ColumnSortListener(0));
        TableColumnModel tableColummModel = this.table.getColumnModel();
        tableColummModel.getColumn(1).setPreferredWidth(100);
        tableColummModel.getColumn(1).setMaxWidth(110);
        tableColummModel.getColumn(2).setPreferredWidth(105);
        tableColummModel.getColumn(2).setMaxWidth(105);
        tableHeader.setReorderingAllowed(false);
        this.table.setAutoscrolls(true);
        this.table.setSelectionMode(0);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setAutoResizeMode(1);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    SpaceMonitorClassesPanel.this.queryRow();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int rowPoint = SpaceMonitorClassesPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                    SpaceMonitorClassesPanel.this.table.setRowSelectionInterval(rowPoint, rowPoint);
                    if (SpaceMonitorClassesPanel.this.table.getSelectedRow() > -1) {
                        SpaceMonitorClassesPanel.this.rightMenu.show(SpaceMonitorClassesPanel.this.table, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.setLayout(this.borderLayout2);
        this._infoBox = new InstancesInfoBox("data type");
        Box bottomBox = new Box(1);
        bottomBox.add(this._infoBox);
        this.tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.tablePanel.add((Component)bottomBox, "South");
        this.initPopupMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tablePanel, "Center");
        this.add((Component)this._infoBox, "South");
        ListSelectionModel tableRowSM = this.table.getSelectionModel();
        this.createIndicationBox();
        Box northRefreshBox = new Box(1);
        northRefreshBox.add(this._indicationBox);
        northRefreshBox.add(searchBox);
        northRefreshBox.add(Box.createVerticalStrut(3));
        this._indicationBox.setVisible(false);
        this.add((Component)northRefreshBox, "North");
    }

    private void initPopupMenu() {
        this.rightMenu = new JPopupMenu();
        this.queryMenu = new JMenuItem("Query");
        this.rightMenu.add(this.queryMenu);
        this.queryMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        SpaceMonitorClassesPanel.this.queryRow();
                    }
                });
            }
        });
    }

    protected void createIndicationBox() {
        this._indicationBox = new IndicationBox("<HTML>Objects of persistent LRU space are not displayed. It can be changed by selecting <B>View > Display Persistent LRU Space Metrics</B> menu item</HTML>", 1);
    }

    public void stopStatusRuntime() {
        this._spaceMonitoringPanel.stopStatusRuntime();
    }

    public void clearRuntimeDialog() {
        this.model.clear();
    }

    private void queryRow() {
        try {
            int selRow = this.table.getSelectedRow();
            if (selRow >= 0 && selRow < this.table.getRowCount()) {
                String querysSTR = "select uid,* from " + this.model.getValueAt(selRow, 0);
                this._treeWorker.getTreeServiceNotificationListener().selectSpaceOperationNode(this._spaceID, "Query");
                this._treeWorker.getTreeServiceNotificationListener().showSpaceQueryPanel(querysSTR, this._connectionProvider.getConnection(), this._spaceProxy.getName());
            }
        }
        catch (Exception e) {
            SpaceBrowser.showException("Query", e);
        }
    }

    public void setSpace(IJSpace space, ServiceID spaceID, IConnectionProvider connectionProvider) {
        block5: {
            this._spaceID = spaceID;
            this._spaceProxy = space;
            this._connectionProvider = connectionProvider;
            try {
                IRemoteJSpaceAdmin spaceAdminLocal = Repository.addSpaceAdminObjectToMap(space);
                this._spaceAdmin = (IInternalRemoteJSpaceAdmin)spaceAdminLocal;
                if (spaceAdminLocal == null) {
                    this._isPersistentLRUSpace = false;
                    return;
                }
                SpaceConfig spaceConfig = Repository.addSpaceConfigToMap((IRemoteJSpaceAdmin)this._spaceAdmin);
                this._isPersistentLRUSpace = spaceConfig.isPersistent() && spaceConfig.getCachePolicy().equals(String.valueOf(0));
            }
            catch (SpaceSecurityException sse) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, sse.toString(), sse);
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block5;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.clearRuntimeDialog();
        this.refresh();
    }

    @Override
    public void refresh() {
        if (this._isPersistentLRUSpace && !this._mainUI.isRetrieveRuntimeForPersistentLRUSpace()) {
            this.clearRuntimeDialog();
            this._infoBox.setCount(this.model.getRowCount());
            this._indicationBox.setVisible(true);
            return;
        }
        this._indicationBox.setVisible(false);
        if (!this._isInvokeRefresh) {
            this._infoBox.setCount(this.model.getRowCount());
            return;
        }
        if (this.refreshThreadTask == null || this.refreshThreadTask.isDone()) {
            this.refreshThreadTask = AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "@@@ Refresh Space Classes Table. ");
                            _logger.finest(" ------- in refresh() Calling spaceAdmin.getRuntimeInfo() ------");
                            long time1 = System.currentTimeMillis();
                            _logger.finest("> TIME1:" + time1);
                        }
                        SpaceMonitorClassesPanel.this.runtime = SpaceMonitorClassesPanel.this._spaceAdmin.getRuntimeInfo();
                        SpaceMonitorClassesPanel.this.updateRuntimeTable(SpaceMonitorClassesPanel.this.runtime);
                    }
                    catch (UnmarshalException ex) {
                        SpaceMonitorClassesPanel.this.stopStatusRuntime();
                        SpaceBrowser.showException("getting runtime information", ex);
                    }
                    catch (RemoteException ex) {
                        SpaceMonitorClassesPanel.this.stopStatusRuntime();
                    }
                    catch (InternalSpaceException ex) {
                        SpaceMonitorClassesPanel.this.stopStatusRuntime();
                        if (_logger.isLoggable(Level.FINEST)) {
                            long time5 = System.currentTimeMillis();
                            _logger.finest("> TIME6:" + time5);
                        }
                        SpaceMonitorClassesPanel.this._infoBox.setCount(SpaceMonitorClassesPanel.this.model.getRowCount());
                    }
                }
            });
        }
    }

    protected void updateRuntimeTable(SpaceRuntimeInfo spaceRuntimeInfo) {
        String className;
        if (_logger.isLoggable(Level.FINEST)) {
            long time2 = System.currentTimeMillis();
            _logger.finest("> TIME2:" + time2);
        }
        if (spaceRuntimeInfo.m_NumOFEntries.size() == 0 && this.model.getRowCount() != 0) {
            this.clearRuntimeDialog();
        }
        int[] existEntryArray = new int[spaceRuntimeInfo.m_NumOFEntries.size()];
        if (_logger.isLoggable(Level.FINEST)) {
            long time3 = System.currentTimeMillis();
            _logger.finest("> TIME3:" + time3);
        }
        boolean isTableModelChanged = false;
        for (int numRow = 0; numRow < this.model.getRowCount(); ++numRow) {
            int inxObj;
            RuntimeInfoWrapper runtimeInfoWrapper = this.model.getWrapperAt(numRow);
            className = runtimeInfoWrapper.getClassName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(">>>> runtime.m_ClassNames=" + spaceRuntimeInfo.m_ClassNames);
            }
            if ((inxObj = spaceRuntimeInfo.m_ClassNames.indexOf(className)) != -1) {
                Object templatesNum;
                existEntryArray[inxObj] = -1;
                Object newEntryNum = spaceRuntimeInfo.m_NumOFEntries.get(inxObj);
                if (!newEntryNum.equals(this.model.getValueAt(numRow, 1))) {
                    runtimeInfoWrapper.setInstancesCount((Integer)newEntryNum);
                    this.model.fireTableRowsUpdated(numRow, numRow);
                }
                if ((templatesNum = spaceRuntimeInfo.m_NumOFTemplates.get(inxObj)).equals(this.model.getValueAt(numRow, 2))) continue;
                runtimeInfoWrapper.setTemplatesCount((Integer)templatesNum);
                this.model.fireTableRowsUpdated(numRow, numRow);
                continue;
            }
            this.model.removeRow(numRow);
            isTableModelChanged = true;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            long time4 = System.currentTimeMillis();
            _logger.finest("> TIME4:" + time4);
        }
        for (int c = 0; c < existEntryArray.length; ++c) {
            Object newEntryNum = spaceRuntimeInfo.m_NumOFEntries.get(c);
            Object templateNum = spaceRuntimeInfo.m_NumOFTemplates.get(c);
            if (existEntryArray[c] == -1) continue;
            className = (String)spaceRuntimeInfo.m_ClassNames.get(c);
            RuntimeInfoWrapper runtimeInfoWrapper = new RuntimeInfoWrapper(className, (Integer)newEntryNum, (Integer)templateNum);
            this.model.addRuntimeInfoWrapper(runtimeInfoWrapper);
            isTableModelChanged = true;
        }
        if (isTableModelChanged) {
            this.model.filterList();
        }
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
        this.clearRuntimeDialog();
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
        this._isInvokeRefresh = invokeRefresh;
    }

    @Override
    public void stop() {
    }

    private class RuntimeInfoWrapper {
        private String className;
        private Integer instancesCount;
        private Integer templatesCount;

        RuntimeInfoWrapper(String className) {
            this(className, 0, 0);
        }

        RuntimeInfoWrapper(String className, Integer instancesCount, Integer templatesCount) {
            this.className = className;
            this.instancesCount = instancesCount;
            this.templatesCount = templatesCount;
        }

        public Integer getInstancesCount() {
            return this.instancesCount;
        }

        public void setInstancesCount(Integer instancesCount) {
            this.instancesCount = instancesCount;
        }

        public Integer getTemplatesCount() {
            return this.templatesCount;
        }

        public void setTemplatesCount(Integer templatesCount) {
            this.templatesCount = templatesCount;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object object) {
            RuntimeInfoWrapper runtimeInfoWrapper = (RuntimeInfoWrapper)object;
            return this.className.equals(runtimeInfoWrapper.getClassName());
        }
    }

    class RuntimeTableModel
    extends DefaultTableModel
    implements ISearchComponent {
        protected List<RuntimeInfoWrapper> runtimeInfoList = Collections.synchronizedList(new ArrayList());
        protected List<RuntimeInfoWrapper> filteredRuntimeInfoList = Collections.synchronizedList(new ArrayList());
        private String _searchedText = "";

        RuntimeTableModel() {
        }

        public void clear() {
            int listSize = this.filteredRuntimeInfoList.size();
            this.filteredRuntimeInfoList.clear();
            this.runtimeInfoList.clear();
            if (listSize > 0) {
                this.fireTableRowsDeleted(0, listSize - 1);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return SpaceMonitorClassesPanel.this.resColumn.length;
        }

        @Override
        public String getColumnName(int column) {
            return SpaceMonitorClassesPanel.this.resColumn[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            RuntimeInfoWrapper runtimeInfoWrapper = this.getWrapperAt(row);
            if (runtimeInfoWrapper != null) {
                return this.getCellValue(runtimeInfoWrapper, column);
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.filteredRuntimeInfoList == null ? 0 : this.filteredRuntimeInfoList.size();
        }

        public Object getCellValue(RuntimeInfoWrapper runtimeInfoWrapper, int column) {
            switch (column) {
                case 0: {
                    return runtimeInfoWrapper.getClassName();
                }
                case 1: {
                    return runtimeInfoWrapper.getInstancesCount();
                }
                case 2: {
                    return runtimeInfoWrapper.getTemplatesCount();
                }
            }
            return "";
        }

        public RuntimeInfoWrapper getWrapperAt(int row) {
            if (row < this.filteredRuntimeInfoList.size()) {
                return this.filteredRuntimeInfoList.get(row);
            }
            return null;
        }

        public int getWrapperIndex(RuntimeInfoWrapper runtimeInfoWrapper) {
            return this.filteredRuntimeInfoList.indexOf(runtimeInfoWrapper);
        }

        public void addRuntimeInfoWrapper(RuntimeInfoWrapper runtimeInfoWrapper) {
            this.filteredRuntimeInfoList.add(runtimeInfoWrapper);
            this.runtimeInfoList.add(runtimeInfoWrapper);
            this.fireTableRowsInserted(this.filteredRuntimeInfoList.size() - 1, this.filteredRuntimeInfoList.size() - 1);
        }

        @Override
        public void removeRow(int rowNum) {
            RuntimeInfoWrapper removedRuntimeInfoWrapper = this.filteredRuntimeInfoList.remove(rowNum);
            this.runtimeInfoList.remove(removedRuntimeInfoWrapper);
            super.removeRow(rowNum);
        }

        @Override
        public void search(String searchedText) {
            this._searchedText = searchedText;
            this.filterList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void filterList() {
            int selRow = SpaceMonitorClassesPanel.this.table.getSelectedRow();
            RuntimeInfoWrapper selRuntimeInfoWrapper = null;
            if (selRow >= 0) {
                selRuntimeInfoWrapper = this.getWrapperAt(selRow);
            }
            if (this._searchedText.length() == 0) {
                for (RuntimeInfoWrapper runtimeInfoWrapper : this.runtimeInfoList) {
                    if (this.filteredRuntimeInfoList.contains(runtimeInfoWrapper)) continue;
                    this.filteredRuntimeInfoList.add(runtimeInfoWrapper);
                    int index = this.filteredRuntimeInfoList.indexOf(runtimeInfoWrapper);
                    this.fireTableRowsInserted(index, index);
                }
                int filteredListSize = this.filteredRuntimeInfoList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    if (this.runtimeInfoList.contains(this.filteredRuntimeInfoList.get(index))) continue;
                    this.filteredRuntimeInfoList.remove(index);
                    this.fireTableRowsDeleted(index, index);
                }
            } else {
                int filteredListSize = this.filteredRuntimeInfoList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    RuntimeInfoWrapper runtimeInfoWrapper = this.filteredRuntimeInfoList.get(index);
                    if (this.isDisplayRuntimeClassInfo(runtimeInfoWrapper) && this.runtimeInfoList.contains(runtimeInfoWrapper)) continue;
                    this.filteredRuntimeInfoList.remove(runtimeInfoWrapper);
                    this.fireTableRowsDeleted(index, index);
                }
                List<RuntimeInfoWrapper> list = this.runtimeInfoList;
                synchronized (list) {
                    for (RuntimeInfoWrapper runtimeInfoWrapper : this.runtimeInfoList) {
                        if (!this.isDisplayRuntimeClassInfo(runtimeInfoWrapper) || this.filteredRuntimeInfoList.contains(runtimeInfoWrapper)) continue;
                        this.filteredRuntimeInfoList.add(runtimeInfoWrapper);
                        int index = this.filteredRuntimeInfoList.indexOf(runtimeInfoWrapper);
                        this.fireTableRowsInserted(index, index);
                    }
                }
            }
            if (selRuntimeInfoWrapper != null) {
                this.selectWrapper(selRuntimeInfoWrapper);
            }
        }

        private boolean isDisplayRuntimeClassInfo(RuntimeInfoWrapper runtimeInfoWrapper) {
            return runtimeInfoWrapper.getClassName().toUpperCase().indexOf(this._searchedText.toUpperCase()) >= 0;
        }

        private void selectWrapper(RuntimeInfoWrapper selRuntimeInfoWrapper) {
            int selIndex;
            if (selRuntimeInfoWrapper != null && (selIndex = this.getWrapperIndex(selRuntimeInfoWrapper)) >= 0) {
                SpaceMonitorClassesPanel.this.table.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpaceMonitorClassesPanel.this.table.scrollRectToVisible(SpaceMonitorClassesPanel.this.table.getCellRect(selIndex, -1, true));
                    }
                });
            }
        }
    }
}

