/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.space;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.space.ISearchComponent;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.admin.ui.grid.space.SpaceMonitoringPanel;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SpaceMonitorTransactionsPanel
extends JPanel {
    protected JTable _transactionsTable;
    protected TransactionsTableModel _transactionsTableModel;
    private static final int CI_TRANSACTION_ID = 0;
    private static final int CI_TRANSACTION_TYPE = 1;
    private static final int CI_TRANSACTION_STATUS = 2;
    private static final int CI_TRANSACTION_START_TIME = 3;
    private static final int CI_TRANSACTION_END_TIME = 4;
    private static final int CI_NUMBER_OF_LOCKED_OBJECTS = 5;
    private SpaceMonitoringPanel _spaceMonitoringPanel;
    private IJSpace curSpaceProxy;
    private IInternalRemoteJSpaceAdmin spaceAdmin;
    protected InstancesInfoBox _infoBox;
    private MainUI _mainUI;
    private SearchEditor _searchEditor;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public SpaceMonitorTransactionsPanel(MainUI mainUI, SpaceMonitoringPanel spaceMonitoringPanel) {
        this._mainUI = mainUI;
        this._spaceMonitoringPanel = spaceMonitoringPanel;
        this.init();
    }

    public TransactionsTableModel getTransactionsTableModel() {
        return this._transactionsTableModel;
    }

    public void setInvokeRefresh(boolean isRefresh) {
        this._transactionsTableModel.setInvokeRefresh(isRefresh);
    }

    public void setSpace(IJSpace spaceProxy) {
        block4: {
            this.curSpaceProxy = spaceProxy;
            try {
                this.spaceAdmin = (IInternalRemoteJSpaceAdmin)Repository.addSpaceAdminObjectToMap(spaceProxy);
            }
            catch (SpaceSecurityException sse) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, sse.toString(), sse);
                }
            }
            catch (RemoteException re) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, re.toString(), re);
            }
        }
        this._transactionsTableModel.refresh();
    }

    protected void initTableModel() {
        this._transactionsTableModel = new TransactionsTableModel();
    }

    private void init() {
        this.initTableModel();
        this._transactionsTable = new JTable(this._transactionsTableModel);
        this._searchEditor = new SearchEditor(this._transactionsTableModel);
        JPanel topPanel = new JPanel(new BorderLayout());
        JScrollPane tableScrollPane = new JScrollPane(this._transactionsTable);
        TableColumnModel tableColumnModel = this._transactionsTable.getColumnModel();
        TableColumn transactionTypeTableColumn = tableColumnModel.getColumn(1);
        TableColumn transactionStatusTableColumn = tableColumnModel.getColumn(2);
        TableColumn numOfLockedObjectsTableColumn = tableColumnModel.getColumn(5);
        transactionTypeTableColumn.setPreferredWidth(100);
        transactionTypeTableColumn.setMaxWidth(100);
        transactionStatusTableColumn.setPreferredWidth(100);
        transactionStatusTableColumn.setMaxWidth(100);
        numOfLockedObjectsTableColumn.setPreferredWidth(120);
        numOfLockedObjectsTableColumn.setMaxWidth(120);
        JTableHeader header = this._transactionsTable.getTableHeader();
        header.setReorderingAllowed(false);
        this._transactionsTable.setAutoCreateColumnsFromModel(false);
        this._transactionsTable.setSelectionMode(0);
        this._transactionsTable.setAutoResizeMode(1);
        this._transactionsTable.setAutoscrolls(true);
        this.setLayout(new BorderLayout());
        this._infoBox = new InstancesInfoBox("transaction");
        Box searchBox = new Box(0);
        searchBox.add(Box.createHorizontalGlue());
        searchBox.add(this._searchEditor);
        searchBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        topPanel.add((Component)searchBox, "North");
        topPanel.add((Component)tableScrollPane, "Center");
        topPanel.add((Component)this._infoBox, "South");
        this.add((Component)topPanel, "Center");
    }

    protected List<UnderTxnLockedObject> retrieveLockedObjects(TransactionInfo transactionInfo) throws RemoteException {
        return this.spaceAdmin.getLockedObjects(transactionInfo.getTrasaction());
    }

    public static String getTransactionTypeName(int transactionType) {
        switch (transactionType) {
            case 0: {
                return "All";
            }
            case 2: {
                return "Jini";
            }
            case 1: {
                return "Local";
            }
            case 3: {
                return "XA";
            }
        }
        return "";
    }

    public static String getTransactionStatusName(int transactionStatus) {
        switch (transactionStatus) {
            case 6: {
                return "Aborted";
            }
            case 1: {
                return "Active";
            }
            case 5: {
                return "Commited";
            }
            case 4: {
                return "Not changed";
            }
            case 3: {
                return "Prepared";
            }
            case 2: {
                return "Voting";
            }
        }
        return "";
    }

    protected class TransactionsTableModel
    extends DefaultTableModel
    implements IRefreshable,
    ISearchComponent {
        protected final String CN_TRANSACTION_ID = "ID";
        protected final String CN_TRANSACTION_TYPE = "Type";
        protected final String CN_TRANSACTION_STATUS = "Status";
        protected final String CN_TRANSACTION_START_TIME = "Start Time";
        protected final String CN_TRANSACTION_END_TIME = "End Time";
        protected final String CN_TRANSACTION_LOCKED_OBJECTS = "Locked Objects";
        protected String[] columnNames;
        protected List<TransactionInfo> transactionInfoList = new ArrayList<TransactionInfo>();
        protected List<TransactionInfo> filteredTransactionInfoList = new ArrayList<TransactionInfo>();
        protected DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        protected boolean _isInvokeRefresh = true;
        private String _searchedText = "";

        public TransactionsTableModel() {
            this.initColumnNames();
        }

        protected void initColumnNames() {
            this.columnNames = new String[6];
            this.columnNames[0] = "ID";
            this.columnNames[1] = "Type";
            this.columnNames[2] = "Status";
            this.columnNames[3] = "Start Time";
            this.columnNames[4] = "End Time";
            this.columnNames[5] = "Locked Objects";
        }

        @Override
        public Object getValueAt(int row, int column) {
            TransactionInfo transactionInfo;
            if (row >= 0 && row < this.filteredTransactionInfoList.size() && (transactionInfo = this.filteredTransactionInfoList.get(row)) != null) {
                return this.getCellValue(transactionInfo, column);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.filteredTransactionInfoList == null ? 0 : this.filteredTransactionInfoList.size();
        }

        public List<TransactionInfo> getWrappersList() {
            return this.filteredTransactionInfoList;
        }

        public TransactionInfo getTransactionInfoAt(int row) {
            if (this.filteredTransactionInfoList.size() > row && row >= 0) {
                return this.filteredTransactionInfoList.get(row);
            }
            return null;
        }

        public int getTransactionInfoIndex(TransactionInfo transactionInfo) {
            return this.filteredTransactionInfoList.indexOf(transactionInfo);
        }

        public Object getCellValue(TransactionInfo transactionInfo, int column) {
            switch (column) {
                case 1: {
                    return SpaceMonitorTransactionsPanel.getTransactionTypeName(transactionInfo.getType());
                }
                case 2: {
                    return SpaceMonitorTransactionsPanel.getTransactionStatusName(transactionInfo.getStatus());
                }
                case 5: {
                    return String.valueOf(transactionInfo.getNumberOfLockedObjects());
                }
                case 0: {
                    return String.valueOf(transactionInfo.getTxnId());
                }
                case 4: {
                    long lease = transactionInfo.getLease();
                    if (lease < 0L) {
                        return " - ";
                    }
                    return this.df.format(new Date(System.currentTimeMillis() + lease));
                }
                case 3: {
                    return this.df.format(new Date(transactionInfo.getStartTime()));
                }
            }
            return "";
        }

        @Override
        public void setInvokeRefresh(boolean invokeRefresh) {
            this._isInvokeRefresh = invokeRefresh;
        }

        public TransactionInfo getWrapperAt(int row) {
            if (row < this.filteredTransactionInfoList.size()) {
                return this.filteredTransactionInfoList.get(row);
            }
            return null;
        }

        @Override
        public void refresh() {
            if (this._isInvokeRefresh && SpaceMonitorTransactionsPanel.this.spaceAdmin != null) {
                boolean isTableModelChanged = false;
                boolean isTableModelUpdated = false;
                int selRow = SpaceMonitorTransactionsPanel.this._transactionsTable.getSelectedRow();
                TransactionInfo selTransactionWrapper = null;
                if (selRow >= 0) {
                    selTransactionWrapper = SpaceMonitorTransactionsPanel.this._transactionsTableModel.getTransactionInfoAt(selRow);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "@@@ Refresh Space Transactions Table. ");
                }
                TransactionInfo[] transactionInfoArray = null;
                try {
                    transactionInfoArray = SpaceMonitorTransactionsPanel.this.spaceAdmin.getTransactionsInfo(0, 1);
                }
                catch (RemoteException e) {
                    _logger.log(Level.FINE, e.toString(), e);
                    SpaceMonitorTransactionsPanel.this._spaceMonitoringPanel.stopStatusRuntime();
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                    SpaceMonitorTransactionsPanel.this._spaceMonitoringPanel.stopStatusRuntime();
                }
                if (transactionInfoArray == null) {
                    transactionInfoArray = new TransactionInfo[]{};
                }
                ArrayList<TransactionInfo> newTransactionInfoList = new ArrayList<TransactionInfo>(transactionInfoArray.length);
                for (TransactionInfo newTransactionInfo : transactionInfoArray) {
                    newTransactionInfoList.add(newTransactionInfo);
                }
                int curListSize = this.transactionInfoList.size();
                for (int listIndex = curListSize - 1; listIndex >= 0; --listIndex) {
                    TransactionInfo transactionInfo = this.transactionInfoList.get(listIndex);
                    if (newTransactionInfoList.indexOf(transactionInfo) < 0) {
                        this.transactionInfoList.remove(transactionInfo);
                        isTableModelChanged = true;
                        continue;
                    }
                    TransactionInfo updateTransactionInfo = (TransactionInfo)newTransactionInfoList.get(newTransactionInfoList.indexOf(transactionInfo));
                    this.transactionInfoList.set(listIndex, updateTransactionInfo);
                    isTableModelUpdated = true;
                }
                int listSize = newTransactionInfoList.size();
                for (int listIndex = listSize - 1; listIndex >= 0; --listIndex) {
                    TransactionInfo newTransactionInfo;
                    newTransactionInfo = (TransactionInfo)newTransactionInfoList.get(listIndex);
                    if (this.transactionInfoList.contains(newTransactionInfo)) continue;
                    this.transactionInfoList.add(newTransactionInfo);
                    isTableModelChanged = true;
                }
                if (isTableModelChanged) {
                    this.filterList(isTableModelUpdated);
                }
                this.selectWrapper(selTransactionWrapper);
            }
            SpaceMonitorTransactionsPanel.this._infoBox.setCount(this.transactionInfoList.size());
        }

        private void selectWrapper(TransactionInfo selTransactionWrapper) {
            int selIndex;
            if (selTransactionWrapper != null && (selIndex = SpaceMonitorTransactionsPanel.this._transactionsTableModel.getTransactionInfoIndex(selTransactionWrapper)) >= 0) {
                SpaceMonitorTransactionsPanel.this._transactionsTable.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpaceMonitorTransactionsPanel.this._transactionsTable.scrollRectToVisible(SpaceMonitorTransactionsPanel.this._transactionsTable.getCellRect(selIndex, -1, true));
                    }
                });
            }
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void search(String searchedText) {
            this._searchedText = searchedText;
            this.filterList(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void filterList(boolean isTableModelUpdated) {
            int selRow = SpaceMonitorTransactionsPanel.this._transactionsTable.getSelectedRow();
            TransactionInfo selTransactionInfo = null;
            if (selRow >= 0) {
                selTransactionInfo = this.getWrapperAt(selRow);
            }
            if (this._searchedText.length() == 0) {
                for (TransactionInfo transactionInfo : this.transactionInfoList) {
                    int index;
                    if (!this.filteredTransactionInfoList.contains(transactionInfo)) {
                        this.filteredTransactionInfoList.add(transactionInfo);
                        index = this.filteredTransactionInfoList.indexOf(transactionInfo);
                        this.fireTableRowsInserted(index, index);
                        continue;
                    }
                    if (!isTableModelUpdated) continue;
                    index = this.filteredTransactionInfoList.indexOf(transactionInfo);
                    this.filteredTransactionInfoList.set(index, transactionInfo);
                    this.fireTableRowsUpdated(index, index);
                }
                int filteredListSize = this.filteredTransactionInfoList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    if (this.transactionInfoList.contains(this.filteredTransactionInfoList.get(index))) continue;
                    this.filteredTransactionInfoList.remove(index);
                    this.fireTableRowsDeleted(index, index);
                }
            } else {
                int filteredListSize = this.filteredTransactionInfoList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    TransactionInfo transactionInfo = this.filteredTransactionInfoList.get(index);
                    if (this.isDisplayTransaction(transactionInfo) && this.transactionInfoList.contains(transactionInfo)) continue;
                    this.filteredTransactionInfoList.remove(transactionInfo);
                    this.fireTableRowsDeleted(index, index);
                }
                List<TransactionInfo> list = this.transactionInfoList;
                synchronized (list) {
                    for (TransactionInfo transactionInfo : this.transactionInfoList) {
                        int index;
                        if (!this.isDisplayTransaction(transactionInfo)) continue;
                        if (!this.filteredTransactionInfoList.contains(transactionInfo)) {
                            this.filteredTransactionInfoList.add(transactionInfo);
                            index = this.filteredTransactionInfoList.indexOf(transactionInfo);
                            this.fireTableRowsInserted(index, index);
                            continue;
                        }
                        if (!isTableModelUpdated) continue;
                        index = this.filteredTransactionInfoList.indexOf(transactionInfo);
                        this.filteredTransactionInfoList.set(index, transactionInfo);
                        this.fireTableRowsUpdated(index, index);
                    }
                }
            }
            if (selTransactionInfo != null) {
                this.selectWrapper(selTransactionInfo);
            }
        }

        private boolean isDisplayTransaction(TransactionInfo transactionInfo) {
            return SpaceMonitorTransactionsPanel.getTransactionTypeName(transactionInfo.getType()).toUpperCase().startsWith(this._searchedText.toUpperCase()) || SpaceMonitorTransactionsPanel.getTransactionStatusName(transactionInfo.getStatus()).toUpperCase().startsWith(this._searchedText.toUpperCase()) || String.valueOf(transactionInfo.getTxnId()).toUpperCase().startsWith(this._searchedText.toUpperCase());
        }
    }
}

