/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.space;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.space.SpaceMoniorConnectionsPanel;
import com.gigaspaces.admin.ui.grid.space.SpaceMonitorClassesPanel;
import com.gigaspaces.admin.ui.grid.space.SpaceMonitorTransactionsPanel;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.jini.core.lookup.ServiceID;

public class SpaceMonitoringPanel
extends JPanel
implements IRefreshable {
    private RefreshPanel _refreshPanel;
    private SpaceMonitorClassesPanel _spaceMonitorClassesPanel;
    private SpaceMonitorTransactionsPanel _spaceMonitorTransactionsPanel;
    private SpaceMoniorConnectionsPanel _spaceMonitorConnectionsPanel;
    private IJSpace _curSpace;
    private ServiceID _curSpaceID;
    private IConnectionProvider _connectionProvider;
    private boolean isFailedDueSecurity;
    private MainUI _mainUI;
    private TreeWorker _treeWorker;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public SpaceMonitoringPanel(MainUI mainUI, TreeWorker treeWorker) {
        super(new BorderLayout());
        this._mainUI = mainUI;
        this._treeWorker = treeWorker;
        this.init();
    }

    private void init() {
        this._spaceMonitorClassesPanel = new SpaceMonitorClassesPanel(this._mainUI, this._treeWorker, this);
        this._spaceMonitorTransactionsPanel = new SpaceMonitorTransactionsPanel(this._mainUI, this);
        this._spaceMonitorConnectionsPanel = new SpaceMoniorConnectionsPanel(this);
        ArrayList<IRefreshable> refreshComponentsList = new ArrayList<IRefreshable>(1);
        refreshComponentsList.add(this);
        this._refreshPanel = new RefreshPanel(refreshComponentsList, false);
        this._spaceMonitorClassesPanel.setBorder(BorderFactory.createTitledBorder("Data Types"));
        this._spaceMonitorTransactionsPanel.setBorder(BorderFactory.createTitledBorder("Active Transactions"));
        this._spaceMonitorConnectionsPanel.setBorder(BorderFactory.createTitledBorder("Connections"));
        JSplitPane centerTableSplitPane = new JSplitPane(1, this._spaceMonitorClassesPanel, this._spaceMonitorConnectionsPanel);
        JPanel splitPanePanel = new JPanel(new BorderLayout());
        splitPanePanel.add((Component)centerTableSplitPane, "Center");
        centerTableSplitPane.setDividerLocation(500);
        JSplitPane vertSplitPane = new JSplitPane(0, splitPanePanel, this._spaceMonitorTransactionsPanel);
        vertSplitPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        vertSplitPane.setDividerLocation(370);
        this.add((Component)this._refreshPanel, "North");
        this.add((Component)vertSplitPane, "Center");
    }

    public void stopStatusRuntime() {
        this._refreshPanel.stopStatusRuntime();
    }

    public void setSpace(IJSpace space, ServiceID spaceID, IConnectionProvider connectionProvider) {
        block8: {
            block7: {
                this._curSpace = space;
                this._curSpaceID = spaceID;
                this._connectionProvider = connectionProvider;
                if (space == null) {
                    return;
                }
                try {
                    space.getAdmin();
                    this.isFailedDueSecurity = false;
                }
                catch (SpaceSecurityException sse) {
                    this.isFailedDueSecurity = true;
                }
                catch (RemoteException re) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block7;
                    _logger.log(Level.SEVERE, re.toString(), re);
                }
            }
            if (this.isFailedDueSecurity) {
                return;
            }
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)space.getDirectProxy().getContainer();
            this._spaceMonitorClassesPanel.setSpace(space, spaceID, connectionProvider);
            this._spaceMonitorTransactionsPanel.setSpace(space);
            try {
                MBeanServerConnection mBeanServerConnection = Repository.getMBeanServerConnection(containerAdmin);
                this._spaceMonitorConnectionsPanel.initPanel(mBeanServerConnection, space);
            }
            catch (RemoteException re) {
                if (!_logger.isLoggable(Level.SEVERE)) break block8;
                _logger.log(Level.SEVERE, re.toString(), re);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void refresh() {
        if (this.isFailedDueSecurity) {
            this.setSpace(this._curSpace, this._curSpaceID, this._connectionProvider);
        }
        if (!this.isFailedDueSecurity) {
            this._spaceMonitorClassesPanel.refresh();
            this._spaceMonitorConnectionsPanel.getConnectionsTableModel().refresh();
            this._spaceMonitorTransactionsPanel.getTransactionsTableModel().refresh();
        }
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
        this._spaceMonitorClassesPanel.setInvokeRefresh(invokeRefresh);
        this._spaceMonitorConnectionsPanel.getConnectionsTableModel().setInvokeRefresh(invokeRefresh);
        this._spaceMonitorTransactionsPanel.getTransactionsTableModel().setInvokeRefresh(invokeRefresh);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

