/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.space;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.space.SpaceConfigurationPanel;
import com.gigaspaces.admin.ui.grid.space.SpaceMonitoringPanel;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceSecurityException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import net.jini.core.lookup.ServiceID;

public class SpaceViewPanel
extends JPanel {
    private SpaceMonitoringPanel _spaceMonitoringPanel;
    private SpaceConfigurationPanel _spaceConfigurationPanel;
    private JLabel indicationLabel;
    private ImageIcon warningIcon;
    private JTabbedPane _tabbedPane = new JTabbedPane();
    private static final String SPACE_MONITORING_TITLE = "Space Monitoring";
    private static final String SPACE_CONFIGURATION_TITLE = "Configuration";
    private static final String REMOTE_SPACE_MONITORING_TITLE = "Remote Space Monitoring";

    public SpaceViewPanel(MainUI mainUI, TreeWorker treeWorker) {
        this._spaceMonitoringPanel = new SpaceMonitoringPanel(mainUI, treeWorker);
        this._spaceConfigurationPanel = new SpaceConfigurationPanel();
        this._tabbedPane.addTab(SPACE_MONITORING_TITLE, this._spaceMonitoringPanel);
        this._tabbedPane.addTab(SPACE_CONFIGURATION_TITLE, this._spaceConfigurationPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedPane, "Center");
        this.indicationLabel = new JLabel();
        this.warningIcon = new ImageIcon(this.getClass().getResource("/image/browser/warning.gif"));
        this.indicationLabel.setIcon(this.warningIcon);
        this.indicationLabel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.RED, new Color(142, 142, 142)), ""));
        this.add((Component)this.indicationLabel, "North");
    }

    public void setSpace(IJSpace space, ServiceID spaceID, String type, IConnectionProvider connectionProvider) {
        this.indicationLabel.setVisible(false);
        try {
            Repository.addSpaceAdminObjectToMap(space);
        }
        catch (SpaceSecurityException sse) {
            this.indicationLabel.setText("<HTML>Space <FONT color=blue>" + space.getName() + "</FONT> is secured. Please perform login to space in order to see all its details.</HTML>");
            this.indicationLabel.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._spaceMonitoringPanel.setSpace(space, spaceID, connectionProvider);
        if (type != null && type.equals("remote")) {
            this._tabbedPane.remove(this._spaceConfigurationPanel);
            this._tabbedPane.setTitleAt(0, REMOTE_SPACE_MONITORING_TITLE);
        } else {
            if (this._tabbedPane.indexOfComponent(this._spaceConfigurationPanel) < 0) {
                this._tabbedPane.addTab(SPACE_CONFIGURATION_TITLE, this._spaceConfigurationPanel);
            }
            this._tabbedPane.setTitleAt(0, SPACE_MONITORING_TITLE);
            this._spaceConfigurationPanel.setSpace(space);
        }
    }

    public void setInvokeRefresh(boolean refresh) {
        this._spaceMonitoringPanel.setInvokeRefresh(refresh);
    }
}

