/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.treenode;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.descriptor.SpaceServiceDescriptor;
import com.gigaspaces.admin.ui.grid.treenode.BasicPUServiceNode;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.driver.GDriver;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.core.lookup.ServiceID;
import org.isqlviewer.sql.DatabaseConnection;
import org.jini.rio.core.provision.ServiceRecord;

public class DeployedServiceNode
extends BasicPUServiceNode
implements IConnectionProvider {
    private String _serviceName = "";
    private ServiceID _serviceID;
    private short _spaceMode;
    private IJSpace _proxy;
    private DatabaseConnection _dbConnect;
    private boolean _isClustered;
    public static final String TYPE_EMBEDDED = "embedded";
    public static final String TYPE_LOCALVIEW = "localview";
    public static final String TYPE_LOCALCACHE = "localcache";
    public static final String TYPE_REMOTE = "remote";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public DeployedServiceNode(SpaceServiceDescriptor spaceServiceDescriptor) {
        super(spaceServiceDescriptor);
        String spaceName;
        this._serviceID = spaceServiceDescriptor.getServiceID();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, ">> DeployedServiceNode added with service id=" + this._serviceID);
        }
        this._spaceMode = 1;
        this._isClustered = spaceServiceDescriptor.iSClustered();
        String spaceContainerName = spaceServiceDescriptor.getSpaceContainerName();
        this._serviceName = spaceContainerName.startsWith((spaceName = spaceServiceDescriptor.getSpaceName()) + "_container") ? spaceName : JSpaceUtilities.createFullSpaceName((String)spaceContainerName, (String)spaceName);
    }

    public ServiceID getServiceID() {
        return this._serviceID;
    }

    @Override
    public String toString() {
        if (this._type.equals(TYPE_LOCALCACHE) || this._type.equals(TYPE_LOCALVIEW) || this._type.equals(TYPE_REMOTE)) {
            return this._id + " [" + this._serviceName + "]";
        }
        return this._serviceName;
    }

    public short getSpaceMode() {
        return this._spaceMode;
    }

    public void setSpaceMode(short spaceMode) {
        this._spaceMode = spaceMode;
    }

    public ServiceRecord getServiceRecord() {
        return (ServiceRecord)((DefaultMutableTreeNode)this.getParent()).getUserObject();
    }

    @Override
    public synchronized DatabaseConnection getConnection() {
        if (this._dbConnect == null) {
            try {
                if (this._proxy == null) {
                    this.getSpaceProxy();
                }
                Properties props = JSpaceUIUtils.createSecuredContextProperties();
                this._dbConnect = new DatabaseConnection((Driver)new GDriver(), props, this._proxy);
                this._dbConnect.gsConnect();
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Exception in method getConnection() of SpaceTreeNode class:" + JSpaceUtilities.LINE_SEPARATOR + ex.toString(), ex);
                }
                SpaceBrowser.showException(ex.toString(), ex);
            }
        }
        return this._dbConnect;
    }

    public IJSpace getSpaceProxy() {
        if (this._type.equals(TYPE_REMOTE)) {
            IJSpace localSpaceProxy = Repository.getInstance().getPrimarySpace(this._description);
            if (!(this._proxy != null && localSpaceProxy != null && this._proxy.equals(localSpaceProxy) || this._dbConnect == null)) {
                try {
                    this._dbConnect.disconnect();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this._dbConnect = null;
            }
            this._proxy = localSpaceProxy;
            return this._proxy;
        }
        if (this._proxy == null) {
            this._proxy = MainUI.getSpace(this._serviceID);
        }
        return this._proxy;
    }

    public boolean isClustered() {
        return this._isClustered;
    }
}

