/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.utils;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.DeployFactory;
import com.gigaspaces.admin.ui.DeploymentControl;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.deploy.DeployControl;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.utils.SecurityUtils;
import com.gigaspaces.internal.utils.ValidationUtils;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.start.Locator;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.Statement;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.core.OperationalString;
import org.jini.rio.monitor.DeployAdmin;

public class DeploymentActionsManager
implements DeployFactory {
    private JButton[] toolBarButtonsRuntimeView;
    private JMenu[] menusArrayRuntimeView;
    private JButton[] toolBarButtonsMonitoringView;
    private JMenu[] menusArrayMonitoringView;
    private JMenuItem[] menuItemsArray;
    private JButton undeploy;
    private JMenu deploymentMenuRuntimeView;
    private JMenu deploymentMenuMonitoringView;
    private JMenuItem undeployApplicationMennuItem;
    private DeploymentControl dc;
    private MainUI _mainUI;
    private JTabbedPane _tabbedPane;
    private String deployDir;
    private boolean isTerminating = false;
    private static final String UNDEPLOY_APPL_TOOL_TIP = "Undeploy a deployed application";
    private static final String LAST_DEPLOYED_PATH = "ui.lastDeployPath";
    private static final String MESSAGE_THERE_IS_NO_GSM = "Unable to continue. Please make sure you have a running instance of GSM.";
    private static final String MESSAGE_THERE_IS_NO_GSC = "Unable to continue. Please make sure you have a running instance of GSC.";
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private static DeploymentActionsManager deploymentActionsBuilder;
    private DeployControl _deploymentControl;
    private JDialog _deploymentDialog;

    public void createToolBarButtons() {
        ImageIcon undeployIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/undeploy.gif");
        this.undeploy = new JButton(undeployIcon);
        this.undeploy.getAccessibleContext().setAccessibleName("undeploy");
        this.undeploy.setToolTipText(UNDEPLOY_APPL_TOOL_TIP);
        ArrayList<JButton> buttonsList = new ArrayList<JButton>(1);
        buttonsList.add(this.undeploy);
        this.toolBarButtonsRuntimeView = new JButton[buttonsList.size()];
        buttonsList.toArray(this.toolBarButtonsRuntimeView);
        buttonsList.remove(this.undeploy);
        this.toolBarButtonsMonitoringView = new JButton[buttonsList.size()];
        buttonsList.toArray(this.toolBarButtonsMonitoringView);
    }

    private void createMenu() {
        this.deploymentMenuRuntimeView = new JMenu("Deployment");
        this.deploymentMenuRuntimeView.setMnemonic('p');
        this.deploymentMenuMonitoringView = new JMenu("Deployment");
        this.deploymentMenuMonitoringView.setMnemonic('p');
        this.undeployApplicationMennuItem = new JMenuItem("Undeploy Application");
        this.undeployApplicationMennuItem.setToolTipText(UNDEPLOY_APPL_TOOL_TIP);
        this.deploymentMenuRuntimeView.add(this.undeployApplicationMennuItem);
        this.menusArrayRuntimeView = new JMenu[1];
        this.menusArrayRuntimeView[0] = this.deploymentMenuRuntimeView;
        this.menusArrayMonitoringView = new JMenu[1];
        this.menusArrayMonitoringView[0] = this.deploymentMenuMonitoringView;
        this.undeployApplicationMennuItem.getAccessibleContext().setAccessibleName("undeploy");
        this.menuItemsArray = new JMenuItem[1];
        this.menuItemsArray[0] = this.undeployApplicationMennuItem;
    }

    public void performDeploy(short deploymentOption) {
        if (!this.hasProvisionPUPriviliges()) {
            return;
        }
        if (this.isDeploymentCanBePerformed()) {
            Repository repository = Repository.getInstance();
            this.dc = this.getDeploymentControl(this._mainUI, deploymentOption);
            this.deployDir = this.dc.getLastSelectedPath();
        }
    }

    private boolean hasProvisionPUPriviliges() {
        boolean hasPermittedProvoisionPermission = false;
        Repository.ProvisionMonitorHolder[] provisionMonitorHolders = Repository.getInstance().getProvisionMonitorHolders();
        Repository.ProvisionMonitorHolder provisionMonitorHolder = null;
        for (int index = 0; index < provisionMonitorHolders.length; ++index) {
            provisionMonitorHolder = provisionMonitorHolders[index];
            ServiceID provisionMonitorServiceID = provisionMonitorHolder.getServiceItem().serviceID;
            SecuredService securedService = (SecuredService)provisionMonitorHolder.getProvisionMonitor();
            if (!JSpaceUIUtils.hasPermittedPermission(securedService, provisionMonitorServiceID, (Privilege)GridAuthority.GridPrivilege.PROVISION_PU)) continue;
            hasPermittedProvoisionPermission = true;
            break;
        }
        if (!hasPermittedProvoisionPermission && provisionMonitorHolders.length > 0) {
            if (SecurityServicesRepository.getInstance().isUserLoggedIn()) {
                JOptionPane.showMessageDialog(this._mainUI, ValidationUtils.MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM_ALREADY_LOOGED_IN, "Deployment", 1);
            } else {
                int returnedVal = JOptionPane.showConfirmDialog(this._mainUI, ValidationUtils.MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM, "Deployment", 0, 1);
                if (returnedVal == 0 && provisionMonitorHolder != null) {
                    SecurityUtils.login((Component)this._mainUI, provisionMonitorHolder.getServiceItem());
                }
            }
            return false;
        }
        return true;
    }

    private void deploySpace() throws Exception {
        Repository.ProvisionMonitorHolder[] pmh = Repository.getInstance().getProvisionMonitorHolders();
        if (pmh.length == 0) {
            return;
        }
        Repository.ProvisionMonitorHolder provisionMonitorHolder = null;
        Authentication authentication = null;
        for (int index = 0; index < pmh.length; ++index) {
            authentication = null;
            provisionMonitorHolder = pmh[index];
            if (!provisionMonitorHolder.isSecured()) break;
            ServiceID gsmServiceID = provisionMonitorHolder.getServiceItem().serviceID;
            authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(gsmServiceID);
            if (authentication != null && authentication.getGrantedAuthorities().isGranted((Privilege)GridAuthority.GridPrivilege.PROVISION_PU)) break;
        }
        if (provisionMonitorHolder.isSecured() && (authentication == null || !authentication.getGrantedAuthorities().isGranted((Privilege)GridAuthority.GridPrivilege.PROVISION_PU))) {
            JOptionPane.showMessageDialog(this._mainUI, ValidationUtils.MSG_UNABLE_TO_DEPLOY_SINGLE_SPACE, "Space Deployment", 2);
            return;
        }
        DeployAdmin deployAdmin = provisionMonitorHolder.getDeployAdmin();
        String[] argv = new String[]{"-properties", "embed://dataGridName=mySpace;", "-properties", "space", "embed://gs.space.url.arg.schema=default;", "-cluster", "total_members=1", "-override-name", "mySpace", "templates/datagrid"};
        Class<?> deployerClass = Class.forName("org.openspaces.pu.container.servicegrid.deploy.Deploy");
        Object deployer = deployerClass.newInstance();
        Statement setGroups = new Statement(deployer, "setGroups", new Object[]{SystemInfo.singleton().lookup().groupsArray()});
        setGroups.execute();
        Statement setDeployAdmin = new Statement(deployer, "initializeDiscovery", new Object[]{provisionMonitorHolder.getProvisionMonitor()});
        setDeployAdmin.execute();
        Method method = deployerClass.getMethod("buildOperationalString", String[].class);
        OperationalString operationalString = (OperationalString)method.invoke(deployer, new Object[]{argv});
        deployAdmin.deploy(operationalString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentControl getDeploymentControl(Component comp, short selDeploymentOption) {
        if (this._deploymentDialog != null) {
            this._deploymentDialog.toFront();
            return this._deploymentControl;
        }
        JFrame parentFrame = (JFrame)SwingUtilities.getRoot(comp);
        try {
            parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            this._deploymentControl = new DeployControl(this._mainUI, this.deployDir, this);
            this._deploymentDialog = this._deploymentControl.getDialog(parentFrame, "Deployment Wizard", false, selDeploymentOption);
        }
        finally {
            parentFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
        this._deploymentDialog.setVisible(true);
        this._deploymentControl.unexport();
        return this._deploymentControl;
    }

    public boolean isDeploymentCanBePerformed() {
        Repository repository = Repository.getInstance();
        int gsmCount = repository.getMonitorCount();
        if (gsmCount < 1) {
            JOptionPane.showMessageDialog(this._mainUI, MESSAGE_THERE_IS_NO_GSM, "Deployment", 1);
            return false;
        }
        int gscCount = repository.getGSCCount();
        if (gscCount < 1) {
            JOptionPane.showMessageDialog(this._mainUI, MESSAGE_THERE_IS_NO_GSC, "Deployment", 1);
            return false;
        }
        return true;
    }

    public JMenu[] getMenusRuntimeView() {
        return this.menusArrayRuntimeView;
    }

    public JButton[] getToolBarButtonsRuntimeView() {
        return this.toolBarButtonsRuntimeView;
    }

    public JMenu[] getMenusMonitoringView() {
        return this.menusArrayMonitoringView;
    }

    public JButton[] getToolBarButtonsMonitoringView() {
        return this.toolBarButtonsMonitoringView;
    }

    public static synchronized DeploymentActionsManager getInstance(MainUI mainUI) {
        if (deploymentActionsBuilder == null) {
            deploymentActionsBuilder = new DeploymentActionsManager(mainUI);
        }
        return deploymentActionsBuilder;
    }

    public void setTabbedPane(JTabbedPane tabbedPane) {
        this._tabbedPane = tabbedPane;
    }

    private DeploymentActionsManager(MainUI mainUI) {
        File ddFile;
        this._mainUI = mainUI;
        String baseDir = SystemInfo.singleton().getXapHome();
        Properties userProps = Repository.getInstance().getProperties();
        String dd = userProps.getProperty(LAST_DEPLOYED_PATH);
        if (dd != null && (ddFile = new File(dd)).exists()) {
            this.deployDir = dd;
        }
        if (this.deployDir == null) {
            this.deployDir = Locator.derivePath((String)baseDir, (String)"deploy");
        }
        this.createMenu();
        this.createToolBarButtons();
    }

    public JMenuItem[] getMenuItems() {
        return this.menuItemsArray;
    }

    public String getLastDeployPath() {
        return this.deployDir;
    }

    public void setLastDeployPath(String lastDeployDir) {
        this.deployDir = lastDeployDir;
    }

    public void dialogDisposed() {
        this._deploymentDialog = null;
    }
}

