/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.grid.descriptor.AsyncPollingEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.EventContainerServiceDescriptor;
import com.gigaspaces.admin.ui.grid.treenode.userobject.EventContainersHolder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class AsyncPollingContainersTableModel
extends DefaultTableModel {
    private static final String CN_NAME = "Name";
    private static final String CN_CONC_CONSUMERS = "Conc. Consumers";
    private static final String CN_TRANSACTIONAL = "Transactional";
    private static final String CN_RECEIVE_TIMEOUT = "Receive Timeout";
    private static final String CN_STATUS = "Status";
    private static final int CI_NAME = 0;
    private static final int CI_CONC_CONSUMERS = 1;
    private static final int CI_TRANSACTIONAL = 2;
    private static final int CI_RECEIVE_TIMEOUT = 3;
    private static final int CI_STATUS = 4;
    protected String[] columnNames;
    protected List<AsyncPollingEventContainerDescriptor> eventContainerDescriptorsList = new ArrayList<AsyncPollingEventContainerDescriptor>();

    public AsyncPollingContainersTableModel() {
        this.initColumnNames();
    }

    protected void initColumnNames() {
        this.columnNames = new String[5];
        this.columnNames[0] = CN_NAME;
        this.columnNames[1] = CN_CONC_CONSUMERS;
        this.columnNames[2] = CN_TRANSACTIONAL;
        this.columnNames[3] = CN_RECEIVE_TIMEOUT;
        this.columnNames[4] = CN_STATUS;
    }

    @Override
    public Object getValueAt(int row, int column) {
        AsyncPollingEventContainerDescriptor eventContainerDescriptor;
        if (row >= 0 && row < this.eventContainerDescriptorsList.size() && (eventContainerDescriptor = this.eventContainerDescriptorsList.get(row)) != null) {
            return this.getCellValue(eventContainerDescriptor, column);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.eventContainerDescriptorsList == null ? 0 : this.eventContainerDescriptorsList.size();
    }

    public Object getCellValue(AsyncPollingEventContainerDescriptor eventContainerDescriptor, int column) {
        switch (column) {
            case 0: {
                return eventContainerDescriptor.getId();
            }
            case 1: {
                return eventContainerDescriptor.getConcCustomers();
            }
            case 2: {
                return eventContainerDescriptor.isTransactional();
            }
            case 3: {
                return eventContainerDescriptor.getReceiveTimeout();
            }
            case 4: {
                return eventContainerDescriptor.getStatus();
            }
        }
        return "";
    }

    public void setEventContainersHolder(EventContainersHolder eventContainersHolder) {
        int curRowCount = this.eventContainerDescriptorsList.size();
        if (curRowCount > 0) {
            this.eventContainerDescriptorsList.clear();
            this.fireTableRowsDeleted(0, curRowCount - 1);
        }
        this.eventContainerDescriptorsList = new ArrayList<AsyncPollingEventContainerDescriptor>(eventContainersHolder.getAsyncPollingEventContainerDecriptorsList());
        curRowCount = this.eventContainerDescriptorsList.size();
        if (curRowCount > 0) {
            this.fireTableRowsInserted(0, curRowCount - 1);
        }
    }

    public void initProcessedAndFailedEvents(List<EventContainerServiceDescriptor> eventContainerServiceDescrList) {
        for (EventContainerServiceDescriptor descriptor : eventContainerServiceDescrList) {
            for (AsyncPollingEventContainerDescriptor asyncPollingEventContainerDescriptor : this.eventContainerDescriptorsList) {
                if (!descriptor.getId().equals(asyncPollingEventContainerDescriptor.getId())) continue;
                asyncPollingEventContainerDescriptor.setStatus(descriptor.getStatus());
            }
        }
    }
}

