/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.grid.descriptor.EventContainerServiceDescriptor;
import com.gigaspaces.admin.ui.grid.treenode.userobject.EventContainersHolder;
import com.gigaspaces.admin.ui.grid.views.AsyncPollingContainersTableModel;
import com.gigaspaces.admin.ui.grid.views.EventContainersTable;
import com.gigaspaces.admin.ui.grid.views.NotifyContainersTableModel;
import com.gigaspaces.admin.ui.grid.views.PollingContainersTableModel;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.openspaces.events.EventContainerServiceMonitors;
import org.openspaces.pu.container.servicegrid.PUMonitors;
import org.openspaces.pu.container.servicegrid.PUServiceBean;

public class EventContainersPanel
extends Box {
    private JTextField _pollingContainersTextField;
    private JTextField _asyncPollingContainersTextField;
    private JTextField _notifyContainersTextField;
    private EventContainersTable pollingContainersTable;
    private PollingContainersTableModel _pollingContainersTableModel;
    private EventContainersTable asyncPollingContainersTable;
    private AsyncPollingContainersTableModel _asyncPollingContainersTableModel;
    private EventContainersTable notifyContainersTable;
    private NotifyContainersTableModel _notifyContainersTableModel;
    private static final Dimension labelSize = new Dimension(150, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension textFieldSize = new Dimension(100, 23);
    private static final Dimension maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension minTextFieldSize = new Dimension(20, 23);
    private static final int LEFT_ALLIGN = 3;
    private InstancesInfoBox _pollingContainersInfoBox;
    private InstancesInfoBox _asyncPollingContainersInfoBox;
    private InstancesInfoBox _notifyContainersInfoBox;
    private boolean _isRefresh;
    private PUServiceBean _curPUServiceBean;
    private final long TIMEOUT = 1500L;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public EventContainersPanel() {
        super(1);
        this.init();
        new RefreshPUMonitors().start();
    }

    private void init() {
        JLabel pollingContainersLabel = this.createLabel("Polling Containers:");
        this._pollingContainersTextField = this.createTextField();
        Box pollingContainersBox = new Box(0);
        pollingContainersBox.add(Box.createHorizontalStrut(3));
        pollingContainersBox.add(pollingContainersLabel);
        pollingContainersBox.add(this._pollingContainersTextField);
        pollingContainersBox.add(Box.createHorizontalGlue());
        JLabel asyncPollingContainersLabel = this.createLabel("Async Polling Containers:");
        this._asyncPollingContainersTextField = this.createTextField();
        Box asyncPollingContainersBox = new Box(0);
        asyncPollingContainersBox.add(Box.createHorizontalStrut(3));
        asyncPollingContainersBox.add(asyncPollingContainersLabel);
        asyncPollingContainersBox.add(this._asyncPollingContainersTextField);
        asyncPollingContainersBox.add(Box.createHorizontalGlue());
        JLabel notifyContainersLabel = this.createLabel("Notify Containers:");
        this._notifyContainersTextField = this.createTextField();
        Box notifyContainersBox = new Box(0);
        notifyContainersBox.add(Box.createHorizontalStrut(3));
        notifyContainersBox.add(notifyContainersLabel);
        notifyContainersBox.add(this._notifyContainersTextField);
        notifyContainersBox.add(Box.createHorizontalGlue());
        JPanel pollingContainersPanel = this.initPollingContainersTable();
        JPanel asyncPollingContainersPanel = this.initAsyncPollingContainersTable();
        JPanel notifyContainersPanel = this.initNotifyContainersTable();
        this.add(Box.createVerticalStrut(3));
        this.add(pollingContainersBox);
        this.add(Box.createVerticalStrut(3));
        this.add(asyncPollingContainersBox);
        this.add(Box.createVerticalStrut(3));
        this.add(notifyContainersBox);
        this.add(Box.createVerticalStrut(4));
        this.add(pollingContainersPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(asyncPollingContainersPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(notifyContainersPanel);
        this.add(Box.createVerticalGlue());
        this.setBorder(BorderFactory.createTitledBorder("Event Containers Summary"));
    }

    private JPanel initPollingContainersTable() {
        this._pollingContainersTableModel = new PollingContainersTableModel();
        this.pollingContainersTable = new EventContainersTable(this._pollingContainersTableModel);
        this.setTableProperties(this.pollingContainersTable);
        TableColumnModel tableColumnModel = this.pollingContainersTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(45);
        tableColumnModel.getColumn(1).setPreferredWidth(140);
        tableColumnModel.getColumn(2).setPreferredWidth(90);
        tableColumnModel.getColumn(3).setPreferredWidth(105);
        tableColumnModel.getColumn(4).setPreferredWidth(100);
        tableColumnModel.getColumn(5).setPreferredWidth(100);
        JScrollPane scrollPane = new JScrollPane(this.pollingContainersTable);
        this._pollingContainersInfoBox = new InstancesInfoBox("polling container");
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        tablePanel.add((Component)this._pollingContainersInfoBox, "South");
        tablePanel.setBorder(BorderFactory.createTitledBorder("Polling Containers"));
        return tablePanel;
    }

    private JPanel initAsyncPollingContainersTable() {
        this._asyncPollingContainersTableModel = new AsyncPollingContainersTableModel();
        this.asyncPollingContainersTable = new EventContainersTable(this._asyncPollingContainersTableModel);
        this.setTableProperties(this.asyncPollingContainersTable);
        JScrollPane scrollPane = new JScrollPane(this.asyncPollingContainersTable);
        this._asyncPollingContainersInfoBox = new InstancesInfoBox("async polling container");
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        tablePanel.add((Component)this._asyncPollingContainersInfoBox, "South");
        tablePanel.setBorder(BorderFactory.createTitledBorder("Async Polling Containers"));
        return tablePanel;
    }

    private JPanel initNotifyContainersTable() {
        this._notifyContainersTableModel = new NotifyContainersTableModel();
        this.notifyContainersTable = new EventContainersTable(this._notifyContainersTableModel);
        this.setTableProperties(this.notifyContainersTable);
        JScrollPane scrollPane = new JScrollPane(this.notifyContainersTable);
        this._notifyContainersInfoBox = new InstancesInfoBox("notify container");
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        tablePanel.add((Component)this._notifyContainersInfoBox, "South");
        tablePanel.setBorder(BorderFactory.createTitledBorder("Notify Containers"));
        return tablePanel;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        textField.setEditable(false);
        textField.setBackground(SystemColor.control);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    public void setEventContainersHolder(EventContainersHolder eventContainersHolder, PUServiceBean puServiceBean) {
        this._curPUServiceBean = puServiceBean;
        this._pollingContainersTextField.setText("" + eventContainersHolder.getPollingContainersAmount());
        this._pollingContainersInfoBox.setCount(eventContainersHolder.getPollingContainersAmount());
        this._asyncPollingContainersTextField.setText("" + eventContainersHolder.getAsyncPollingContainersAmount());
        this._asyncPollingContainersInfoBox.setCount(eventContainersHolder.getAsyncPollingContainersAmount());
        this._notifyContainersTextField.setText("" + eventContainersHolder.getNotifyContainersAmount());
        this._notifyContainersInfoBox.setCount(eventContainersHolder.getNotifyContainersAmount());
        this._pollingContainersTableModel.setEventContainersHolder(eventContainersHolder);
        this._asyncPollingContainersTableModel.setEventContainersHolder(eventContainersHolder);
        this._notifyContainersTableModel.setEventContainersHolder(eventContainersHolder);
        this.updateProcessedAndFailedServices();
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
    }

    public void updateProcessedAndFailedServices() {
        block4: {
            try {
                PUMonitors puMonitors = this._curPUServiceBean.getPUMonitors();
                if (puMonitors != null) {
                    Object[] monitorsArray = puMonitors.getMonitors();
                    ArrayList<EventContainerServiceDescriptor> eventContainerServiceDescrList = new ArrayList<EventContainerServiceDescriptor>(monitorsArray.length);
                    for (Object monitor : monitorsArray) {
                        if (!(monitor instanceof EventContainerServiceMonitors)) continue;
                        EventContainerServiceDescriptor eventContainerServiceDescriptor = new EventContainerServiceDescriptor(monitor);
                        eventContainerServiceDescrList.add(eventContainerServiceDescriptor);
                    }
                    this._notifyContainersTableModel.initProcessedAndFailedEvents(eventContainerServiceDescrList);
                    this._pollingContainersTableModel.initProcessedAndFailedEvents(eventContainerServiceDescrList);
                    this._asyncPollingContainersTableModel.initProcessedAndFailedEvents(eventContainerServiceDescrList);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private class RefreshPUMonitors
    extends GSThread {
        public RefreshPUMonitors() {
            super("RefreshPUMonitors");
        }

        public void run() {
            while (true) {
                if (EventContainersPanel.this._isRefresh) {
                    EventContainersPanel.this.updateProcessedAndFailedServices();
                }
                try {
                    Thread.sleep(1500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, ie.toString(), ie);
                    continue;
                }
                break;
            }
        }
    }
}

