/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.descriptor.JEEPUServiceDescriptor;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.openspaces.pu.container.jee.stats.WebRequestsServiceMonitors;
import org.openspaces.pu.container.servicegrid.PUMonitors;
import org.openspaces.pu.container.servicegrid.PUServiceBean;

public class JEEConfigurationPanel
extends Box {
    private JTextField _jeeContainerTextField;
    private JTextField _hostNameTextField;
    private JTextField _portTextField;
    private JTextField _sslPortTextField;
    private JTextField _modeTextField;
    private JTextField _contextPathTextField;
    private JTextField _totalDurationRequestsTextField;
    private JTextField _activeRequestsTextField;
    private JTextField _totalRequestsTextField;
    private JLabel _urlLabel;
    private MainUI _mainUI;
    private JEEPUServiceDescriptor _curJeeServiceDescriptor;
    private long _prevTotalRequests;
    private long _prevTotalDuration;
    private long _prevPrevTotalRequests;
    private long _prevPrevTotalDuration;
    private static final Dimension labelSize = new Dimension(170, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension textFieldSize = new Dimension(140, 23);
    private static final Dimension maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension minTextFieldSize = new Dimension(20, 23);
    private PUServiceBean _curPUServiceBean;
    private boolean _isRefresh;
    private static final int LEFT_ALLIGN = 3;
    private static final long TIMEOUT = 1000L;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private Trace2DLtd _averageRequestLatencyTrace;
    private Trace2DLtd _requestsThroughputTrace;
    private int _time;

    public JEEConfigurationPanel(MainUI mainUI) {
        super(1);
        this._mainUI = mainUI;
        this.init();
        new RefreshThread("JEE-View-Refresh").start();
    }

    private void init() {
        this._urlLabel = new JLabel();
        Box urlBox = new Box(0);
        urlBox.add(Box.createHorizontalStrut(3));
        urlBox.add(this._urlLabel);
        urlBox.add(Box.createHorizontalGlue());
        this._urlLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JEEConfigurationPanel.this._mainUI.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JEEConfigurationPanel.this._mainUI.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JSpaceUIUtils.showInBrowser(JEEConfigurationPanel.this._mainUI, JEEConfigurationPanel.this._curJeeServiceDescriptor.getURL(), LOGGER);
            }
        });
        JLabel contextPathLabel = this.createLabel("Context Path:");
        this._contextPathTextField = this.createTextField();
        Box contextPathBox = new Box(0);
        contextPathBox.add(Box.createHorizontalStrut(3));
        contextPathBox.add(contextPathLabel);
        contextPathBox.add(this._contextPathTextField);
        contextPathBox.add(Box.createHorizontalGlue());
        JLabel jeeContainerLabel = this.createLabel("JEE Profile:");
        this._jeeContainerTextField = this.createTextField();
        Box jeeContainerBox = new Box(0);
        jeeContainerBox.add(Box.createHorizontalStrut(3));
        jeeContainerBox.add(jeeContainerLabel);
        jeeContainerBox.add(this._jeeContainerTextField);
        jeeContainerBox.add(Box.createHorizontalGlue());
        JLabel hostNameLabel = this.createLabel("Host name:");
        this._hostNameTextField = this.createTextField();
        Box hostNameBox = new Box(0);
        hostNameBox.add(Box.createHorizontalStrut(3));
        hostNameBox.add(hostNameLabel);
        hostNameBox.add(this._hostNameTextField);
        hostNameBox.add(Box.createHorizontalGlue());
        JLabel portLabel = this.createLabel("Port:");
        this._portTextField = this.createTextField();
        Box portVMBox = new Box(0);
        portVMBox.add(Box.createHorizontalStrut(3));
        portVMBox.add(portLabel);
        portVMBox.add(this._portTextField);
        portVMBox.add(Box.createHorizontalGlue());
        JLabel sslPortLabel = this.createLabel("HTTPS Port:");
        this._sslPortTextField = this.createTextField();
        Box sslPortBox = new Box(0);
        sslPortBox.add(Box.createHorizontalStrut(3));
        sslPortBox.add(sslPortLabel);
        sslPortBox.add(this._sslPortTextField);
        sslPortBox.add(Box.createHorizontalGlue());
        JLabel modeLabel = this.createLabel("Mode:");
        this._modeTextField = this.createTextField();
        Box modeBox = new Box(0);
        modeBox.add(Box.createHorizontalStrut(3));
        modeBox.add(modeLabel);
        modeBox.add(this._modeTextField);
        modeBox.add(Box.createHorizontalGlue());
        JLabel totalRequestsLabel = this.createLabel("Total Requests:");
        this._totalRequestsTextField = this.createTextField();
        Box totalRequestsBox = new Box(0);
        totalRequestsBox.add(Box.createHorizontalStrut(3));
        totalRequestsBox.add(totalRequestsLabel);
        totalRequestsBox.add(this._totalRequestsTextField);
        totalRequestsBox.add(Box.createHorizontalGlue());
        JLabel activeRequestsLabel = this.createLabel("Active Requests:");
        this._activeRequestsTextField = this.createTextField();
        Box activeRequestsBox = new Box(0);
        activeRequestsBox.add(Box.createHorizontalStrut(3));
        activeRequestsBox.add(activeRequestsLabel);
        activeRequestsBox.add(this._activeRequestsTextField);
        activeRequestsBox.add(Box.createHorizontalGlue());
        JLabel totalDurationLabel = this.createLabel("Total Duration:");
        this._totalDurationRequestsTextField = this.createTextField();
        Box totalDurationBox = new Box(0);
        totalDurationBox.add(Box.createHorizontalStrut(3));
        totalDurationBox.add(totalDurationLabel);
        totalDurationBox.add(this._totalDurationRequestsTextField);
        totalDurationBox.add(Box.createHorizontalGlue());
        Box jeeApplicationSummaryBox = new Box(1);
        Box jeeContainerDetailsBox = new Box(1);
        Box webStatisticsBox = new Box(1);
        jeeApplicationSummaryBox.setBorder(BorderFactory.createTitledBorder("JEE Application Summary"));
        jeeContainerDetailsBox.setBorder(BorderFactory.createTitledBorder("JEE Container Details"));
        webStatisticsBox.setBorder(BorderFactory.createTitledBorder("Web Requests Statistics"));
        jeeApplicationSummaryBox.add(urlBox);
        jeeApplicationSummaryBox.add(Box.createVerticalStrut(3));
        jeeApplicationSummaryBox.add(contextPathBox);
        jeeApplicationSummaryBox.add(Box.createVerticalStrut(3));
        jeeContainerDetailsBox.add(jeeContainerBox);
        jeeContainerDetailsBox.add(Box.createVerticalStrut(3));
        jeeContainerDetailsBox.add(hostNameBox);
        jeeContainerDetailsBox.add(Box.createVerticalStrut(3));
        jeeContainerDetailsBox.add(portVMBox);
        jeeContainerDetailsBox.add(Box.createVerticalStrut(3));
        jeeContainerDetailsBox.add(sslPortBox);
        jeeContainerDetailsBox.add(Box.createVerticalStrut(3));
        jeeContainerDetailsBox.add(modeBox);
        jeeContainerDetailsBox.add(Box.createVerticalStrut(3));
        webStatisticsBox.add(Box.createVerticalStrut(2));
        webStatisticsBox.add(activeRequestsBox);
        webStatisticsBox.add(Box.createVerticalStrut(3));
        webStatisticsBox.add(totalRequestsBox);
        webStatisticsBox.add(Box.createVerticalStrut(3));
        webStatisticsBox.add(totalDurationBox);
        webStatisticsBox.add(Box.createVerticalStrut(3));
        jeeContainerDetailsBox.setPreferredSize(new Dimension(1000, 176));
        jeeContainerDetailsBox.setMaximumSize(new Dimension(2000, 176));
        jeeApplicationSummaryBox.setPreferredSize(new Dimension(1000, 82));
        jeeApplicationSummaryBox.setMaximumSize(new Dimension(2000, 82));
        webStatisticsBox.setPreferredSize(new Dimension(1000, 118));
        webStatisticsBox.setMaximumSize(new Dimension(2000, 118));
        Chart2D requestsThroughputChart = new Chart2D();
        requestsThroughputChart.setBorder((Border)new TitledBorder(new LineBorder(new Color(127, 157, 185), 1, false), " Requests Throughput (requests/second)"));
        requestsThroughputChart.getAxisX().setPaintGrid(true);
        requestsThroughputChart.getAxisY().setPaintGrid(true);
        requestsThroughputChart.setGridColor(Color.LIGHT_GRAY);
        this._requestsThroughputTrace = new Trace2DLtd(300, "");
        this._requestsThroughputTrace.setColor(Color.RED);
        requestsThroughputChart.addTrace((ITrace2D)this._requestsThroughputTrace);
        Chart2D averageRequestLatencyChart = new Chart2D();
        averageRequestLatencyChart.setBorder((Border)new TitledBorder(new LineBorder(new Color(127, 157, 185), 1, false), " Average Request Latency (in millis)"));
        averageRequestLatencyChart.getAxisX().setPaintGrid(true);
        averageRequestLatencyChart.getAxisY().setPaintGrid(true);
        averageRequestLatencyChart.setGridColor(Color.LIGHT_GRAY);
        this._averageRequestLatencyTrace = new Trace2DLtd(300, "");
        this._averageRequestLatencyTrace.setColor(Color.RED);
        averageRequestLatencyChart.addTrace((ITrace2D)this._averageRequestLatencyTrace);
        Box graphsBox = new Box(0);
        graphsBox.add((Component)requestsThroughputChart);
        graphsBox.add(Box.createHorizontalStrut(3));
        graphsBox.add((Component)averageRequestLatencyChart);
        this.add(jeeApplicationSummaryBox);
        this.add(jeeContainerDetailsBox);
        this.add(webStatisticsBox);
        this.add(Box.createVerticalStrut(3));
        this.add(graphsBox);
        this.add(Box.createVerticalStrut(3));
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        textField.setEditable(false);
        textField.setBackground(SystemColor.control);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    public void setJEEConfiguration(JEEPUServiceDescriptor jeeServiceDescriptor, PUServiceBean puServiceBean) {
        this._curJeeServiceDescriptor = jeeServiceDescriptor;
        this._curPUServiceBean = puServiceBean;
        this.setInvokeRefresh(true);
        this.updateView();
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
    }

    private void updateView() {
        if (this._curJeeServiceDescriptor == null) {
            this.clear();
            return;
        }
        this.updateRuntimeView();
        this._hostNameTextField.setText(this._curJeeServiceDescriptor.getHost());
        this._portTextField.setText("" + this._curJeeServiceDescriptor.getPort());
        this._sslPortTextField.setText("" + this._curJeeServiceDescriptor.getSslPort());
        this._jeeContainerTextField.setText(this._curJeeServiceDescriptor.getType());
        this._contextPathTextField.setText(this._curJeeServiceDescriptor.getContextPath());
        this._modeTextField.setText(this._curJeeServiceDescriptor.getMode());
        FontMetrics fontMetrics = this._urlLabel.getFontMetrics(this._urlLabel.getFont());
        this._urlLabel.setText("<HTML><A HREF=\"" + this._curJeeServiceDescriptor.getURL() + "\">" + this._curJeeServiceDescriptor.getURL() + "</A></HTML>");
        int stringWidth = fontMetrics.stringWidth(this._curJeeServiceDescriptor.getURL());
        this._urlLabel.setPreferredSize(new Dimension(stringWidth + 5, 23));
        this._urlLabel.setMaximumSize(new Dimension(stringWidth + 5, 23));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRuntimeView() {
        try {
            PUMonitors puMonitors = this._curPUServiceBean.getPUMonitors();
            if (puMonitors != null) {
                Object[] monitorsArray;
                for (Object monitor : monitorsArray = puMonitors.getMonitors()) {
                    if (!(monitor instanceof WebRequestsServiceMonitors)) continue;
                    WebRequestsServiceMonitors webRequestsServiceMonitors = (WebRequestsServiceMonitors)monitor;
                    Long totalDuration = webRequestsServiceMonitors.getTotalDuration();
                    Long activeRequests = webRequestsServiceMonitors.getActive();
                    Long totalRequests = webRequestsServiceMonitors.getTotal();
                    this._totalDurationRequestsTextField.setText(JSpaceUIUtils.getFullTimeRepresentation(totalDuration, true));
                    this._totalRequestsTextField.setText(totalRequests.toString());
                    this._activeRequestsTextField.setText(activeRequests.toString());
                    long curTotalRequests = totalRequests;
                    long requestsThroughput = 1000L * (curTotalRequests - this._prevTotalRequests) / 1000L;
                    long curTotalDuration = totalDuration;
                    this._prevPrevTotalDuration = this._prevTotalDuration;
                    this._prevPrevTotalRequests = this._prevTotalRequests;
                    this._prevTotalDuration = curTotalDuration;
                    this._prevTotalRequests = curTotalRequests;
                    if (this._time == 0) continue;
                    this.updateRequestsThroughputGraph(requestsThroughput);
                    this.updateAverageRequestsGraph();
                }
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        finally {
            ++this._time;
        }
    }

    private void updateRequestsThroughputGraph(long requestsThroughput) {
        this._requestsThroughputTrace.addPoint((double)this._time, (double)requestsThroughput);
    }

    private void updateAverageRequestsGraph() {
        long totalDurartionDelta;
        float averageRequestsDuration = -1.0f;
        float requestsDelta = this._prevTotalRequests - this._prevPrevTotalRequests;
        if (requestsDelta == 0.0f) {
            averageRequestsDuration = 0.0f;
        }
        if ((totalDurartionDelta = this._prevTotalDuration - this._prevPrevTotalDuration) != 0L) {
            averageRequestsDuration = requestsDelta / (float)totalDurartionDelta;
        }
        if (averageRequestsDuration >= 0.0f) {
            this._averageRequestLatencyTrace.addPoint((double)this._time, (double)averageRequestsDuration);
        }
    }

    public void clear() {
        this._isRefresh = false;
        this._curPUServiceBean = null;
        this._curJeeServiceDescriptor = null;
        this._jeeContainerTextField.setText("");
        this._hostNameTextField.setText("");
        this._portTextField.setText("");
        this._sslPortTextField.setText("");
        this._modeTextField.setText("");
        this._contextPathTextField.setText("");
        this._urlLabel.setText("");
        this._totalDurationRequestsTextField.setText("");
        this._totalRequestsTextField.setText("");
        this._activeRequestsTextField.setText("");
    }

    private class RefreshThread
    extends GSThread {
        public RefreshThread(String name) {
            super(name);
        }

        public void run() {
            while (true) {
                if (JEEConfigurationPanel.this._isRefresh) {
                    JEEConfigurationPanel.this.updateRuntimeView();
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, ie.toString(), ie);
                    continue;
                }
                break;
            }
        }
    }
}

