/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.grid.descriptor.EventContainerServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.NotifyEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.treenode.userobject.EventContainersHolder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class NotifyContainersTableModel
extends DefaultTableModel {
    private static final String CN_NAME = "Name";
    private static final String CN_BATCH_SIZE = "Batch Size";
    private static final String CN_BATCH_TIME = "Batch Time";
    private static final String CN_TRANSACTIONAL = "Transactional";
    private static final String CN_COMM_TYPE = "Comm. Type";
    private static final String CN_NOTIFY_OPERATIONS = "Notify Operations";
    private static final String CN_FIFO = "FIFO";
    private static final String CN_TAKE_ON_NOTIFY = "Take on Notify";
    private static final String CN_PASS_ARRAY_AS_IS = "Pass Array As Is";
    private static final String CN_PROCESSED = "Processed";
    private static final String CN_FAILED = "Failed";
    private static final String CN_STATUS = "Status";
    private static final int CI_NAME = 0;
    private static final int CI_BATCH_SIZE = 1;
    private static final int CI_BATCH_TIME = 2;
    private static final int CI_TRANSACTIONAL = 3;
    private static final int CI_COMM_TYPE = 4;
    private static final int CI_NOTIFY_OPERATIONS = 5;
    private static final int CI_FIFO = 6;
    private static final int CI_TAKE_ON_NOTIFY = 7;
    private static final int CI_PASS_ARRAY_AS_IS = 8;
    private static final int CI_PROCESSED = 9;
    private static final int CI_FAILED = 10;
    private static final int CI_STATUS = 11;
    protected String[] columnNames;
    protected List<NotifyEventContainerDescriptor> eventContainerDescriptorsList = new ArrayList<NotifyEventContainerDescriptor>();

    public NotifyContainersTableModel() {
        this.initColumnNames();
    }

    protected void initColumnNames() {
        this.columnNames = new String[12];
        this.columnNames[0] = CN_NAME;
        this.columnNames[1] = CN_BATCH_SIZE;
        this.columnNames[2] = CN_BATCH_TIME;
        this.columnNames[3] = CN_TRANSACTIONAL;
        this.columnNames[4] = CN_COMM_TYPE;
        this.columnNames[5] = CN_NOTIFY_OPERATIONS;
        this.columnNames[6] = CN_FIFO;
        this.columnNames[7] = CN_TAKE_ON_NOTIFY;
        this.columnNames[8] = CN_PASS_ARRAY_AS_IS;
        this.columnNames[9] = CN_PROCESSED;
        this.columnNames[10] = CN_FAILED;
        this.columnNames[11] = CN_STATUS;
    }

    @Override
    public Object getValueAt(int row, int column) {
        NotifyEventContainerDescriptor eventContainerDescriptor;
        if (row >= 0 && row < this.eventContainerDescriptorsList.size() && (eventContainerDescriptor = this.eventContainerDescriptorsList.get(row)) != null) {
            return this.getCellValue(eventContainerDescriptor, column);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.eventContainerDescriptorsList == null ? 0 : this.eventContainerDescriptorsList.size();
    }

    public Object getCellValue(NotifyEventContainerDescriptor eventContainerDescriptor, int column) {
        switch (column) {
            case 0: {
                return eventContainerDescriptor.getId();
            }
            case 1: {
                return eventContainerDescriptor.getBatchSize();
            }
            case 2: {
                return eventContainerDescriptor.getBatchTime();
            }
            case 3: {
                return eventContainerDescriptor.isTransactional();
            }
            case 4: {
                return eventContainerDescriptor.getCommType();
            }
            case 5: {
                return eventContainerDescriptor.getNotifyOperationsPresentation();
            }
            case 6: {
                return eventContainerDescriptor.isFifo();
            }
            case 7: {
                return eventContainerDescriptor.isTakeOnNotify();
            }
            case 8: {
                return eventContainerDescriptor.isPassArrayAsIs();
            }
            case 9: {
                return eventContainerDescriptor.getProcessed();
            }
            case 10: {
                return eventContainerDescriptor.getFailed();
            }
            case 11: {
                return eventContainerDescriptor.getStatus();
            }
        }
        return "";
    }

    public void setEventContainersHolder(EventContainersHolder eventContainersHolder) {
        int curRowCount = this.eventContainerDescriptorsList.size();
        if (curRowCount > 0) {
            this.eventContainerDescriptorsList.clear();
            this.fireTableRowsDeleted(0, curRowCount - 1);
        }
        this.eventContainerDescriptorsList = new ArrayList<NotifyEventContainerDescriptor>(eventContainersHolder.getNotifyEventContainerDecriptorsList());
        curRowCount = this.eventContainerDescriptorsList.size();
        if (curRowCount > 0) {
            this.fireTableRowsInserted(0, curRowCount - 1);
        }
    }

    public void initProcessedAndFailedEvents(List<EventContainerServiceDescriptor> eventContainerServiceDescrList) {
        for (EventContainerServiceDescriptor descriptor : eventContainerServiceDescrList) {
            for (NotifyEventContainerDescriptor notifyEventContainerDescriptor : this.eventContainerDescriptorsList) {
                if (!descriptor.getId().equals(notifyEventContainerDescriptor.getId())) continue;
                notifyEventContainerDescriptor.setProcessed(descriptor.getProcessedEvents());
                notifyEventContainerDescriptor.setFailed(descriptor.getFailedEvents());
                notifyEventContainerDescriptor.setStatus(descriptor.getStatus());
            }
        }
    }
}

