/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.grid.gsc.ui.BeanPropertiesComponent;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.gsm.PUsDetails;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.rmi.MarshalledObject;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;

public class PUConfigurationPanel
extends Box {
    private JTextField _nameTextField;
    private JTextField _numberOfInstancesTextField;
    private JTextField _numberOfBackupsTextField;
    private JTextField _instancesPerVMTextField;
    private JTextField _instancesPerMachineTextField;
    private BeanPropertiesComponent _beanBeanPropertiesComponent;
    private static final Dimension labelSize = new Dimension(170, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension textFieldSize = new Dimension(140, 23);
    private static final Dimension maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension minTextFieldSize = new Dimension(20, 23);
    private static final int LEFT_ALLIGN = 3;
    private TreeWorker.OpStringHolder _curOpStringHolder;
    private final MainUI _mainUI;
    private final long TIMEOUT = 1000L;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public PUConfigurationPanel(MainUI mainUI) {
        super(1);
        this._mainUI = mainUI;
        this.init();
    }

    private void init() {
        JLabel nameLabel = this.createLabel("Name:");
        this._nameTextField = this.createTextField();
        Box nameBox = new Box(0);
        nameBox.add(Box.createHorizontalStrut(3));
        nameBox.add(nameLabel);
        nameBox.add(this._nameTextField);
        nameBox.add(Box.createHorizontalGlue());
        JLabel numberOfInstancesLabel = this.createLabel("Number of Instances:");
        this._numberOfInstancesTextField = this.createTextField();
        Box numberOfInstancesBox = new Box(0);
        numberOfInstancesBox.add(Box.createHorizontalStrut(3));
        numberOfInstancesBox.add(numberOfInstancesLabel);
        numberOfInstancesBox.add(this._numberOfInstancesTextField);
        numberOfInstancesBox.add(Box.createHorizontalGlue());
        JLabel numberOfBackupsLabel = this.createLabel("Number of Backups:");
        this._numberOfBackupsTextField = this.createTextField();
        Box numberOfBackupsBox = new Box(0);
        numberOfBackupsBox.add(Box.createHorizontalStrut(3));
        numberOfBackupsBox.add(numberOfBackupsLabel);
        numberOfBackupsBox.add(this._numberOfBackupsTextField);
        numberOfBackupsBox.add(Box.createHorizontalGlue());
        JLabel instancesPerVMLabel = this.createLabel("Instances per VM:");
        this._instancesPerVMTextField = this.createTextField();
        Box instancesPerVMBox = new Box(0);
        instancesPerVMBox.add(Box.createHorizontalStrut(3));
        instancesPerVMBox.add(instancesPerVMLabel);
        instancesPerVMBox.add(this._instancesPerVMTextField);
        instancesPerVMBox.add(Box.createHorizontalGlue());
        JLabel instancesPerMachineLabel = this.createLabel("Instances per Machine:");
        this._instancesPerMachineTextField = this.createTextField();
        Box instancesPerMachineBox = new Box(0);
        instancesPerMachineBox.add(Box.createHorizontalStrut(3));
        instancesPerMachineBox.add(instancesPerMachineLabel);
        instancesPerMachineBox.add(this._instancesPerMachineTextField);
        instancesPerMachineBox.add(Box.createHorizontalGlue());
        this._beanBeanPropertiesComponent = new BeanPropertiesComponent(new Color(230, 230, 230));
        this._beanBeanPropertiesComponent.setBorder((Border)BorderFactory.createTitledBorder("Deployment Properties"));
        this.add(Box.createVerticalStrut(3));
        this.add(nameBox);
        this.add(Box.createVerticalStrut(3));
        this.add(numberOfInstancesBox);
        this.add(Box.createVerticalStrut(3));
        this.add(numberOfBackupsBox);
        this.add(Box.createVerticalStrut(3));
        this.add(instancesPerVMBox);
        this.add(Box.createVerticalStrut(3));
        this.add(instancesPerMachineBox);
        this.add(Box.createVerticalStrut(4));
        this.add((Component)this._beanBeanPropertiesComponent);
        this.add(Box.createVerticalStrut(30));
        this.setBorder(BorderFactory.createTitledBorder("Processing Unit Configuration"));
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        textField.setEditable(false);
        textField.setBackground(SystemColor.control);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    public void setPUConfiguration(TreeWorker.OpStringHolder opStringHolder) {
        this._curOpStringHolder = opStringHolder;
        this.updateView();
    }

    private void updateView() {
        block6: {
            if (this._curOpStringHolder == null) {
                this.clear();
                return;
            }
            GSM gsm = (GSM)this._curOpStringHolder.getPrimaryProvisioner();
            if (gsm == null) {
                return;
            }
            try {
                PUDetails[] puDetailsArray;
                PUsDetails pusDetails = gsm.getPUsDetails();
                for (PUDetails puDetails : puDetailsArray = pusDetails.getDetails()) {
                    String puName = puDetails.getName();
                    if (!this._curOpStringHolder.getOpString(false).getName().equals(puName)) continue;
                    int numOfInstances = puDetails.getNumberOfInstances();
                    int numOfBackups = puDetails.getNumberOfBackups();
                    this._nameTextField.setText(puName);
                    this._numberOfInstancesTextField.setText("" + numOfInstances);
                    this._numberOfBackupsTextField.setText("" + numOfBackups);
                    MarshalledObject slaMarshObject = puDetails.getSla();
                    MarshalledObject beanLevelPropertiesMarshObject = puDetails.getBeanLevelProperties();
                    Object sla = slaMarshObject.get();
                    Object beanLevelPropertiesObj = beanLevelPropertiesMarshObject.get();
                    Map beansMap = (Map)beanLevelPropertiesObj.getClass().getMethod("getBeans", new Class[0]).invoke(beanLevelPropertiesObj, new Object[0]);
                    Properties contextProperties = (Properties)beanLevelPropertiesObj.getClass().getMethod("getContextProperties", new Class[0]).invoke(beanLevelPropertiesObj, new Object[0]);
                    String securityUserPassword = contextProperties.getProperty("security.password");
                    if (securityUserPassword != null) {
                        contextProperties.setProperty("security.password", "*****");
                    }
                    beansMap.put("Context", contextProperties);
                    this._beanBeanPropertiesComponent.setData(beansMap);
                    Integer maxInstancePerVM = (Integer)sla.getClass().getMethod("getMaxInstancesPerVM", new Class[0]).invoke(sla, new Object[0]);
                    Integer maxInstancePerMachine = (Integer)sla.getClass().getMethod("getMaxInstancesPerMachine", new Class[0]).invoke(sla, new Object[0]);
                    this._instancesPerVMTextField.setText(maxInstancePerVM.toString());
                    this._instancesPerMachineTextField.setText(maxInstancePerMachine.toString());
                }
            }
            catch (Exception re) {
                if (!LOGGER.isLoggable(Level.FINE)) break block6;
                LOGGER.log(Level.FINE, re.toString(), re);
            }
        }
    }

    private void clear() {
        this._nameTextField.setText("");
        this._numberOfInstancesTextField.setText("");
        this._numberOfBackupsTextField.setText("");
        this._instancesPerVMTextField.setText("");
        this._instancesPerMachineTextField.setText("");
    }

    private String getTestPuXMLText() {
        return "<beans xmlns=\"http://www.springframework.org/schema/beans\"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"xmlns:context=\"http://www.springframework.org/schema/context\"xmlns:os-core=\"http://www.openspaces.org/schema/core\"xmlns:os-events=\"http://www.openspaces.org/schema/events\"xmlns:os-remoting=\"http://www.openspaces.org/schema/remoting\"xmlns:os-sla=\"http://www.openspaces.org/schema/sla\"xmlns:os-jms=\"http://www.openspaces.org/schema/jms\"xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsdhttp://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsdhttp://www.openspaces.org/schema/core http://www.openspaces.org/schema/core/openspaces-core.xsdhttp://www.openspaces.org/schema/events http://www.openspaces.org/schema/events/openspaces-events.xsdhttp://www.openspaces.org/schema/remoting http://www.openspaces.org/schema/remoting/openspaces-remoting.xsd http://www.openspaces.org/schema/jms http://www.openspaces.org/schema/jms/openspaces-jms.xsdhttp://www.openspaces.org/schema/sla http://www.openspaces.org/schema/sla/openspaces-sla.xsd\"><bean id=\"propertiesConfigurer\" class=\"org.springframework.beans.factory.config.PropertyPlaceholderConfigurer\"></bean><os-core:space id=\"space\" url=\"/./servlet\" /><os-core:giga-space id=\"gigaSpace\" space=\"space\"/></beans>";
    }
}

