/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.descriptor.AsyncPollingEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.EventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.JEEPUServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.NotifyEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.PollingEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.SpaceServiceDescriptor;
import com.gigaspaces.admin.ui.grid.treenode.userobject.EventContainersHolder;
import com.gigaspaces.admin.ui.grid.treenode.userobject.RemoteServicesHolder;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import net.jini.core.lookup.ServiceID;
import org.openspaces.remoting.RemotingServiceDetails;

public class PUInstancePropertiesPanel
extends Box {
    private PUInstancePropertyTable _embeddedSpacesTable;
    private PUInstancePropertyTable _remoteSpaceProxiesTable;
    private PUInstancePropertyTable _eventContainersTable;
    private PUInstancePropertyTable _jeeContainersTable;
    private PUInstancePropertyTable _remoteServicesTable;
    private DefaultTableModel _embeddedSpacesTableModel;
    private DefaultTableModel _remoteSpaceProxiesTableModel;
    private DefaultTableModel _eventContainersTableModel;
    private DefaultTableModel _jeeContainersTableModel;
    private DefaultTableModel _remoteServicesTableModel;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public PUInstancePropertiesPanel() {
        super(1);
        JPanel embeddedSpaceDetailsPanel = this.createEmbeddedSpaceDetailsPanel();
        JPanel remoteSpaceProxiesPanel = this.createRemoteSpaceProxiesPanel();
        JPanel eventContainersPanel = this.createEventContainersPanel();
        JPanel jEEContainersPanel = this.createJEEContainersPanel();
        JPanel remoteEndpointsPanel = this.createRemoteEndpointsPanel();
        this.add(Box.createVerticalStrut(2));
        this.add(embeddedSpaceDetailsPanel);
        this.add(Box.createVerticalStrut(2));
        this.add(remoteSpaceProxiesPanel);
        this.add(Box.createVerticalStrut(2));
        this.add(eventContainersPanel);
        this.add(Box.createVerticalStrut(2));
        this.add(jEEContainersPanel);
        this.add(Box.createVerticalStrut(2));
        this.add(remoteEndpointsPanel);
        this.add(Box.createVerticalStrut(2));
        this.setBorder(BorderFactory.createTitledBorder("Processing Unit Instance Summary"));
    }

    public void setPUInstanceProperties(EventContainersHolder eventContainersHolder, RemoteServicesHolder remoteServicesHolder, List<JEEPUServiceDescriptor> jeeServiceDescriptorsList, List<SpaceServiceDescriptor> embeddedSpacesList, List<SpaceServiceDescriptor> remoteSpacesList) {
        this.clear();
        if (eventContainersHolder != null) {
            List<AsyncPollingEventContainerDescriptor> asyncPollingEventsList = eventContainersHolder.getAsyncPollingEventContainerDecriptorsList();
            List<PollingEventContainerDescriptor> pollingEventsList = eventContainersHolder.getPollingEventContainerDecriptorsList();
            List<NotifyEventContainerDescriptor> notifyEventsList = eventContainersHolder.getNotifyEventContainerDecriptorsList();
            this.addEventContainers("Async Polling", asyncPollingEventsList, this._eventContainersTableModel);
            this.addEventContainers("Polling", pollingEventsList, this._eventContainersTableModel);
            this.addEventContainers("Notify", notifyEventsList, this._eventContainersTableModel);
        }
        this.initRemoteServicesTable(remoteServicesHolder);
        this.iniJeeContainersTable(jeeServiceDescriptorsList);
        this.initEmbeddedSpacesTable(embeddedSpacesList);
        this.initRemoteSpacesTable(remoteSpacesList);
    }

    private void initRemoteSpacesTable(List<SpaceServiceDescriptor> remoteSpacesList) {
        int maxURLLength = 20;
        FontMetrics fontMetrics = this._remoteSpaceProxiesTable.getFontMetrics(this._remoteSpaceProxiesTable.getFont());
        for (SpaceServiceDescriptor spaceServiceDescriptor : remoteSpacesList) {
            String jiniGroup;
            String locators;
            String url;
            String spaceName;
            block4: {
                IJSpace space;
                spaceName = spaceServiceDescriptor.getId();
                url = spaceServiceDescriptor.getUrl();
                int strWidth = fontMetrics.stringWidth(url);
                if (strWidth > maxURLLength) {
                    maxURLLength = strWidth;
                }
                if ((space = this.getSpaceProxy(spaceServiceDescriptor)) == null) continue;
                SpaceURL spaceURL = space.getURL();
                locators = spaceURL.getProperty("locators");
                IJSpaceContainerAdmin spaceContainerAdmin = (IJSpaceContainerAdmin)space.getDirectProxy().getContainer();
                jiniGroup = "";
                try {
                    ContainerConfig containerConfig = Repository.addContainerToMap(spaceContainerAdmin);
                    jiniGroup = containerConfig.lookupGroups;
                }
                catch (RemoteException re) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block4;
                    _logger.log(Level.SEVERE, re.toString(), re);
                }
            }
            this._remoteSpaceProxiesTableModel.addRow(new String[]{spaceName, url, jiniGroup, locators});
        }
        this._remoteSpaceProxiesTable.getColumnModel().getColumn(1).setPreferredWidth(maxURLLength);
    }

    private void initEmbeddedSpacesTable(List<SpaceServiceDescriptor> embeddedSpacesList) {
        for (SpaceServiceDescriptor spaceServiceDescriptor : embeddedSpacesList) {
            String spaceName = spaceServiceDescriptor.getSpaceName();
            IJSpace space = this.getSpaceProxy(spaceServiceDescriptor);
            String spaceInstanceId = JSpaceUIUtils.getSpaceInstanceID(space);
            SpaceMode spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(spaceServiceDescriptor.getServiceID());
            String spaceModeStr = "";
            if (spaceMode != null) {
                if (spaceMode.equals((Object)SpaceMode.PRIMARY)) {
                    spaceModeStr = "Primary";
                } else if (spaceMode.equals((Object)SpaceMode.BACKUP)) {
                    spaceModeStr = "Backup";
                }
            }
            this._embeddedSpacesTableModel.addRow(new String[]{spaceName, spaceInstanceId, spaceModeStr});
        }
    }

    private IJSpace getSpaceProxy(SpaceServiceDescriptor spaceServiceDescriptor) {
        if (spaceServiceDescriptor.getType().equals("remote")) {
            String spaceName = spaceServiceDescriptor.getSpaceName();
            return Repository.getInstance().getPrimarySpace(spaceName);
        }
        ServiceID spaceID = spaceServiceDescriptor.getServiceID();
        IJSpace space = MainUI.getSpace(spaceID);
        return space;
    }

    private void iniJeeContainersTable(List<JEEPUServiceDescriptor> jeeServiceDescriptorsList) {
        for (JEEPUServiceDescriptor jeePUServiceDescriptor : jeeServiceDescriptorsList) {
            String type = jeePUServiceDescriptor.getType();
            String mode = jeePUServiceDescriptor.getMode();
            String httpPort = "" + jeePUServiceDescriptor.getPort();
            String httpsPort = "" + jeePUServiceDescriptor.getSslPort();
            this._jeeContainersTableModel.addRow(new String[]{type, mode, httpPort, httpsPort});
        }
    }

    private void initRemoteServicesTable(RemoteServicesHolder remoteServicesHolder) {
        RemotingServiceDetails.RemoteService[] remoteServices;
        if (remoteServicesHolder != null && (remoteServices = remoteServicesHolder.getRemoteServices()) != null) {
            for (RemotingServiceDetails.RemoteService remoteService : remoteServices) {
                String className = remoteService.getClassName();
                this._remoteServicesTableModel.addRow(new String[]{className, "", ""});
            }
        }
    }

    public void addEventContainers(String type, List eventContainersList, DefaultTableModel tableModel) {
        int listSize = eventContainersList.size();
        for (int index = 0; index < listSize; ++index) {
            EventContainerDescriptor eventContainerDescriptor = (EventContainerDescriptor)eventContainersList.get(index);
            tableModel.addRow(new String[]{type, eventContainerDescriptor.getId()});
        }
    }

    private void clear() {
        this.clearTable(this._embeddedSpacesTableModel);
        this.clearTable(this._eventContainersTableModel);
        this.clearTable(this._jeeContainersTableModel);
        this.clearTable(this._remoteServicesTableModel);
        this.clearTable(this._remoteSpaceProxiesTableModel);
    }

    public void clearTable(DefaultTableModel tableModel) {
        int rowsCount = tableModel.getRowCount();
        for (int index = rowsCount - 1; index >= 0; --index) {
            tableModel.removeRow(index);
        }
    }

    private JPanel createEmbeddedSpaceDetailsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Embedded Spaces Details"));
        this._embeddedSpacesTableModel = new BasicTableModel(new String[]{"Name", "Id", "Space Mode"}, 0);
        this._embeddedSpacesTable = new PUInstancePropertyTable(this._embeddedSpacesTableModel);
        this.setTableProperties(this._embeddedSpacesTable);
        panel.add((Component)new JScrollPane(this._embeddedSpacesTable), "Center");
        return panel;
    }

    private JPanel createRemoteSpaceProxiesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Remote Space Proxies"));
        this._remoteSpaceProxiesTableModel = new BasicTableModel(new String[]{"Name", "URL", "Lookup Groups", "Lookup Locators"}, 0);
        this._remoteSpaceProxiesTable = new PUInstancePropertyTable(this._remoteSpaceProxiesTableModel);
        this.setTableProperties(this._remoteSpaceProxiesTable);
        panel.add((Component)new JScrollPane(this._remoteSpaceProxiesTable), "Center");
        return panel;
    }

    private JPanel createEventContainersPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Event Containers"));
        this._eventContainersTableModel = new BasicTableModel(new String[]{"Type", "Name"}, 0);
        this._eventContainersTable = new PUInstancePropertyTable(this._eventContainersTableModel);
        this.setTableProperties(this._eventContainersTable);
        panel.add((Component)new JScrollPane(this._eventContainersTable), "Center");
        return panel;
    }

    private JPanel createJEEContainersPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("JEE Containers"));
        this._jeeContainersTableModel = new BasicTableModel(new String[]{"Type", "Mode", "HTTP Port", "HTTPS Port"}, 0);
        this._jeeContainersTable = new PUInstancePropertyTable(this._jeeContainersTableModel);
        this.setTableProperties(this._jeeContainersTable);
        panel.add((Component)new JScrollPane(this._jeeContainersTable), "Center");
        return panel;
    }

    private JPanel createRemoteEndpointsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Remoting Services"));
        this._remoteServicesTableModel = new BasicTableModel(new String[]{"Class", "Remoting Type", "Space Proxy URL"}, 0);
        this._remoteServicesTable = new PUInstancePropertyTable(this._remoteServicesTableModel);
        this.setTableProperties(this._remoteServicesTable);
        panel.add((Component)new JScrollPane(this._remoteServicesTable), "Center");
        return panel;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(3);
        table.setAutoscrolls(true);
    }

    public class PUInstancePropertyTable
    extends JTable {
        public PUInstancePropertyTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point p = event.getPoint();
            int hitColumnIndex = this.columnAtPoint(p);
            int hitRowIndex = this.rowAtPoint(p);
            Object obj = this.getModel().getValueAt(hitRowIndex, hitColumnIndex);
            if (obj != null && !(obj instanceof Boolean)) {
                return obj.toString();
            }
            return null;
        }
    }

    private class BasicTableModel
    extends DefaultTableModel {
        public BasicTableModel(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

