/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.views.PUInstancesTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.gsm.PUsDetails;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;

public class PUInstancesPanel
extends Box
implements ListSelectionListener,
ActionListener {
    private JTextField _plannedInstancesTextField;
    private JTextField _runningInstancesTextField;
    private JTextField _deploymentStatusTextField;
    private JTextField _managingGSMTextField;
    private JTextField _provisionFailuresTextField;
    private JTextField _slaThresholdBreachesTextField;
    private BasicTable _puInstancesTable;
    private PUInstancesTableModel _puInstancesTableModel;
    private JButton _addInstanceButton;
    private JButton _decreaseInstanceButton;
    private static final Dimension labelSize = new Dimension(170, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension labelSize2 = new Dimension(166, 21);
    private static final Dimension textFieldSize = new Dimension(310, 23);
    private static final Dimension maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension minTextFieldSize = new Dimension(20, 23);
    private static final int LEFT_ALLIGN = 3;
    private InstancesInfoBox _puInstancesInfoBox;
    private boolean _isRefresh;
    private TreeWorker.OpStringHolder _curOpStringHolder;
    private DefaultMutableTreeNode _curOpStringTreeNode;
    private MainUI _mainUI;
    private final long TIMEOUT = 1000L;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public PUInstancesPanel(MainUI mainUI) {
        super(1);
        this._mainUI = mainUI;
        this.init();
        new RefreshThread("PU-Instances-View-Refresh").start();
    }

    private void init() {
        JLabel plannedInstancesLabel = this.createLabel("Planned Instances:");
        this._plannedInstancesTextField = this.createTextField();
        Box plannedInstancesBox = new Box(0);
        plannedInstancesBox.add(Box.createHorizontalStrut(3));
        plannedInstancesBox.add(plannedInstancesLabel);
        plannedInstancesBox.add(this._plannedInstancesTextField);
        plannedInstancesBox.add(Box.createHorizontalGlue());
        JLabel runningInstancesLabel = this.createLabel("Running Instances:");
        this._runningInstancesTextField = this.createTextField();
        Box runningInstancesBox = new Box(0);
        runningInstancesBox.add(Box.createHorizontalStrut(3));
        runningInstancesBox.add(runningInstancesLabel);
        runningInstancesBox.add(this._runningInstancesTextField);
        runningInstancesBox.add(Box.createHorizontalGlue());
        JLabel deploymentStatusLabel = this.createLabel("Deployment Status:");
        this._deploymentStatusTextField = this.createTextField();
        Box deploymentStatusBox = new Box(0);
        deploymentStatusBox.add(Box.createHorizontalStrut(3));
        deploymentStatusBox.add(deploymentStatusLabel);
        deploymentStatusBox.add(this._deploymentStatusTextField);
        deploymentStatusBox.add(Box.createHorizontalGlue());
        JLabel managingGSMLabel = this.createLabel("Managing GSM:");
        this._managingGSMTextField = this.createTextField();
        Box managingGSMBox = new Box(0);
        managingGSMBox.add(Box.createHorizontalStrut(3));
        managingGSMBox.add(managingGSMLabel);
        managingGSMBox.add(this._managingGSMTextField);
        managingGSMBox.add(Box.createHorizontalGlue());
        Box slaEventsBox = this.initSLAEventsSection();
        JPanel asyncPollingContainersPanel = this.initInstancesTable();
        this.add(Box.createVerticalStrut(3));
        this.add(plannedInstancesBox);
        this.add(Box.createVerticalStrut(3));
        this.add(runningInstancesBox);
        this.add(Box.createVerticalStrut(3));
        this.add(deploymentStatusBox);
        this.add(Box.createVerticalStrut(3));
        this.add(managingGSMBox);
        this.add(Box.createVerticalStrut(3));
        this.add(slaEventsBox);
        this.add(Box.createVerticalStrut(4));
        this.add(asyncPollingContainersPanel);
        this.add(Box.createVerticalGlue());
        this.setBorder(BorderFactory.createTitledBorder("Processing Unit Instances"));
    }

    private Box initSLAEventsSection() {
        Box slaEventsBox = new Box(1);
        JLabel provisionFailuresLabel = this.createLabel2("Provision Failures:");
        this._provisionFailuresTextField = this.createTextField();
        Box provisionFailuresBox = new Box(0);
        provisionFailuresBox.add(Box.createHorizontalStrut(3));
        provisionFailuresBox.add(provisionFailuresLabel);
        provisionFailuresBox.add(this._provisionFailuresTextField);
        provisionFailuresBox.add(Box.createHorizontalGlue());
        JLabel slaThresholdLabel = this.createLabel2("SLA Threshold:");
        this._slaThresholdBreachesTextField = this.createTextField();
        Box slaThresholdBox = new Box(0);
        slaThresholdBox.add(Box.createHorizontalStrut(3));
        slaThresholdBox.add(slaThresholdLabel);
        slaThresholdBox.add(this._slaThresholdBreachesTextField);
        slaThresholdBox.add(Box.createHorizontalGlue());
        slaEventsBox.add(provisionFailuresBox);
        slaEventsBox.add(Box.createVerticalStrut(5));
        slaEventsBox.add(slaThresholdBox);
        slaEventsBox.add(Box.createVerticalStrut(4));
        slaEventsBox.setBorder(BorderFactory.createTitledBorder("SLA Events"));
        provisionFailuresLabel.setEnabled(false);
        this._provisionFailuresTextField.setEnabled(false);
        slaThresholdLabel.setEnabled(false);
        this._slaThresholdBreachesTextField.setEnabled(false);
        return slaEventsBox;
    }

    private JPanel initInstancesTable() {
        this._puInstancesTableModel = new PUInstancesTableModel(this._mainUI);
        this._puInstancesTable = new BasicTable(this._puInstancesTableModel);
        this.setTableProperties(this._puInstancesTable);
        this._puInstancesTable.getSelectionModel().addListSelectionListener(this);
        this._puInstancesTable.getColumnModel().getColumn(0).setCellRenderer(new PUInstancesCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this._puInstancesTable);
        this._puInstancesInfoBox = new InstancesInfoBox("", "primary", "backup");
        Box buttonsBox = this.createButtonBox();
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        tablePanel.add((Component)this._puInstancesInfoBox, "South");
        tablePanel.add((Component)buttonsBox, "East");
        tablePanel.setBorder(BorderFactory.createTitledBorder("Instance list"));
        return tablePanel;
    }

    private Box createButtonBox() {
        this._addInstanceButton = new JButton("Add Instance");
        this._decreaseInstanceButton = new JButton("Terminate Instance");
        this._addInstanceButton.setToolTipText("Add an additional processing unit instance");
        this._decreaseInstanceButton.setToolTipText("Remove one of the existing processing unit instances");
        this._addInstanceButton.addActionListener(this);
        this._decreaseInstanceButton.addActionListener(this);
        this._addInstanceButton.setEnabled(false);
        this._decreaseInstanceButton.setEnabled(false);
        Dimension buttonSize = new Dimension(125, 23);
        this._addInstanceButton.setPreferredSize(buttonSize);
        this._decreaseInstanceButton.setPreferredSize(buttonSize);
        this._addInstanceButton.setMinimumSize(buttonSize);
        this._decreaseInstanceButton.setMinimumSize(buttonSize);
        this._addInstanceButton.setMaximumSize(buttonSize);
        this._decreaseInstanceButton.setMaximumSize(buttonSize);
        Box buttonsBox = new Box(1);
        buttonsBox.add(Box.createVerticalGlue());
        buttonsBox.add(this._addInstanceButton);
        buttonsBox.add(Box.createVerticalStrut(5));
        buttonsBox.add(this._decreaseInstanceButton);
        buttonsBox.add(Box.createVerticalGlue());
        buttonsBox.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
        return buttonsBox;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        textField.setEditable(false);
        textField.setBackground(SystemColor.control);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    private JLabel createLabel2(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize2);
        label.setMinimumSize(labelSize2);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
    }

    public void setPUInstancesDefinition(DefaultMutableTreeNode opStringNode, TreeWorker.OpStringHolder opStringHolder) {
        this._curOpStringHolder = opStringHolder;
        this._curOpStringTreeNode = opStringNode;
        this.updateView();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selIndex = e.getFirstIndex();
        this.handleButtonsState(selIndex);
    }

    private void handleButtonsState(int selIndex) {
        boolean isSecured;
        ServiceID securedServiceID;
        SecuredService securedService = this._curOpStringHolder.getSecuredService();
        if (JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceID = this._curOpStringHolder.getSecuredServiceID(), (Privilege)GridAuthority.GridPrivilege.MANAGE_PU, isSecured = this._curOpStringHolder.isSecured())) {
            PUInstancesTableModel.PUInstanceWrapper firstPuInstanceWrapper = null;
            if (this._puInstancesTableModel.getRowCount() > 0) {
                firstPuInstanceWrapper = (PUInstancesTableModel.PUInstanceWrapper)this._puInstancesTableModel.getWrapperAt(0);
            }
            this._addInstanceButton.setEnabled(firstPuInstanceWrapper != null && !firstPuInstanceWrapper.hasEmbeddedSpace() && !firstPuInstanceWrapper.hasGateway());
            PUInstancesTableModel.PUInstanceWrapper puInstanceWrapper = (PUInstancesTableModel.PUInstanceWrapper)this._puInstancesTableModel.getWrapperAt(selIndex);
            if (puInstanceWrapper != null && !puInstanceWrapper.hasEmbeddedSpace() && !puInstanceWrapper.hasGateway()) {
                this._decreaseInstanceButton.setEnabled(this._puInstancesTableModel.getRowCount() > 1);
            } else {
                this._decreaseInstanceButton.setEnabled(false);
            }
        } else {
            this._addInstanceButton.setEnabled(false);
            this._decreaseInstanceButton.setEnabled(false);
        }
    }

    private void updateView() {
        block10: {
            if (this._curOpStringHolder == null) {
                this.clear();
                return;
            }
            GSM gsm = (GSM)this._curOpStringHolder.getPrimaryProvisioner();
            Repository.ProvisionMonitorHolder[] provisionMonitorHoldersArray = Repository.getInstance().getProvisionMonitorHolders();
            try {
                PUDetails[] puDetailsArray;
                List<TreeWorker.ServiceHolder> puInstancesList = TreeWorker.getPUServiceHolders(this._curOpStringTreeNode);
                this._puInstancesTableModel.setPUInstancesServicesHolders(puInstancesList, this._curOpStringTreeNode);
                this.updateInfoBox();
                this.handleButtonsState(this._puInstancesTable.getSelectedRow());
                int rowCount = this._puInstancesTable.getRowCount();
                if (!this._runningInstancesTextField.getText().equals("" + rowCount)) {
                    this._runningInstancesTextField.setText("" + rowCount);
                }
                PUsDetails pusDetails = gsm.getPUsDetails();
                for (PUDetails puDetails : puDetailsArray = pusDetails.getDetails()) {
                    String puName = puDetails.getName();
                    if (!this._curOpStringHolder.getOpString(false).getName().equals(puName)) continue;
                    int numOfInstances = puDetails.getNumberOfInstances();
                    int numOfBackups = puDetails.getNumberOfBackups();
                    int status = puDetails.getStatus();
                    String statusDescr = PUInstancesPanel.getStatusDescription(status);
                    int plannedNum = numOfInstances * numOfBackups + numOfInstances;
                    if (!this._plannedInstancesTextField.getText().equals("" + plannedNum)) {
                        this._plannedInstancesTextField.setText("" + plannedNum);
                    }
                    if (!this._deploymentStatusTextField.getText().equals(statusDescr)) {
                        this._deploymentStatusTextField.setText(statusDescr);
                    }
                    String gsmServiceID = "";
                    for (Repository.ProvisionMonitorHolder monitorHolder : provisionMonitorHoldersArray) {
                        if (!monitorHolder.getProvisionMonitor().equals(gsm)) continue;
                        gsmServiceID = monitorHolder.getServiceItem().serviceID.toString();
                        break;
                    }
                    String gsmDescription = JSpaceUtilities.retriveHostName((NIOInfoProvider)gsm) + " [" + gsmServiceID + "]";
                    if (this._managingGSMTextField.getText().equals(gsmDescription)) continue;
                    this._managingGSMTextField.setText(gsmDescription);
                }
            }
            catch (ConnectException ce) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, ce.toString(), ce);
                }
            }
            catch (RemoteException re) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                LOGGER.log(Level.SEVERE, re.toString(), re);
            }
        }
    }

    private void updateInfoBox() {
        int rowCount = this._puInstancesTableModel.getRowCount();
        int primarySpacesCount = 0;
        int backupSpacesCount = 0;
        for (int index = 0; index < rowCount; ++index) {
            PUInstancesTableModel.PUInstanceWrapper puInstanceWrapper = (PUInstancesTableModel.PUInstanceWrapper)this._puInstancesTableModel.getWrapperAt(index);
            if (puInstanceWrapper == null) continue;
            short spaceMode = this.getSpaceMode(puInstanceWrapper);
            if (spaceMode == 3) {
                ++backupSpacesCount;
                continue;
            }
            if (spaceMode != 2) continue;
            ++primarySpacesCount;
        }
        this._puInstancesInfoBox.setCount(rowCount);
        this._puInstancesInfoBox.setCount2(primarySpacesCount);
        this._puInstancesInfoBox.setCount3(backupSpacesCount);
    }

    private short getSpaceMode(PUInstancesTableModel.PUInstanceWrapper puInstanceWrapper) {
        ServiceID puInstanceID = puInstanceWrapper.getServiceID();
        return TreeWorker.getSpacePrimaryBackupIndication(this._curOpStringTreeNode, puInstanceID);
    }

    private void clear() {
        this._plannedInstancesTextField.setText("");
        this._runningInstancesTextField.setText("");
        this._deploymentStatusTextField.setText("");
        this._managingGSMTextField.setText("");
        this._provisionFailuresTextField.setText("");
        this._slaThresholdBreachesTextField.setText("");
        this._puInstancesTableModel.clear();
    }

    public static String getStatusDescription(int status) {
        String statusDescription;
        switch (status) {
            case 0: {
                statusDescription = "Undeployed";
                break;
            }
            case 1: {
                statusDescription = "Scheduled";
                break;
            }
            case 2: {
                statusDescription = "Deployed";
                break;
            }
            case 3: {
                statusDescription = "Broken";
                break;
            }
            case 4: {
                statusDescription = "Compromised";
                break;
            }
            case 5: {
                statusDescription = "Intact";
                break;
            }
            default: {
                statusDescription = "No status match";
            }
        }
        return statusDescription;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._addInstanceButton)) {
            AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    PUInstancesPanel.this.addInstance();
                }
            });
        } else if (source.equals(this._decreaseInstanceButton)) {
            AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    PUInstancesPanel.this.decreaseInstance();
                }
            });
        }
    }

    private void decreaseInstance() {
        ServiceBeanInstance serviceBeanInstance = this._puInstancesTableModel.getServiceBeanInstanceAt(this._puInstancesTable.getSelectedRow());
        if (serviceBeanInstance != null) {
            try {
                this._mainUI.setCursor(Cursor.getPredefinedCursor(3));
                this._curOpStringHolder.getPrimary().decrement(serviceBeanInstance, true, true, false);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            finally {
                this._mainUI.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private void addInstance() {
        ServiceElement serviceElement;
        if (this._puInstancesTable.getRowCount() > 0 && (serviceElement = this._puInstancesTableModel.getServiceElementAt(0)) != null) {
            try {
                this._mainUI.setCursor(Cursor.getPredefinedCursor(3));
                this._curOpStringHolder.getPrimary().increment(serviceElement, true, null, false);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            finally {
                this._mainUI.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class PUInstancesCellRenderer
    extends DefaultTableCellRenderer {
        private PUInstancesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            short spaceMode;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ImageIcon icon = null;
            PUInstancesTableModel.PUInstanceWrapper puInstanceWrapper = (PUInstancesTableModel.PUInstanceWrapper)PUInstancesPanel.this._puInstancesTableModel.getWrapperAt(row);
            if (puInstanceWrapper != null && (spaceMode = PUInstancesPanel.this.getSpaceMode(puInstanceWrapper)) >= 0) {
                icon = JSpaceUIUtils.getPUInstanceIcon(spaceMode, 1);
            }
            this.setIcon(icon);
            return this;
        }
    }

    private class RefreshThread
    extends GSThread {
        public RefreshThread(String name) {
            super(name);
        }

        public void run() {
            while (true) {
                if (PUInstancesPanel.this._isRefresh) {
                    PUInstancesPanel.this.updateView();
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, ie.toString(), ie);
                    continue;
                }
                break;
            }
        }
    }
}

