/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;

public class PUInstancesTableModel
extends BasicSortableTableModel {
    private final String CN_INSTANCE_IDENTIFIER = "Instance Identifier";
    private final String CN_RUNNING_ON_HOST = "Running on Host";
    private final String CN_ZONES = "Zones";
    private final String CN_CONTAINING_GSC = "Containing GSC";
    public static final int CI_INSTANCE_IDENTIFIER_ID = 0;
    public static final int CI_RUNNING_ON_HOST = 1;
    public static final int CI_ZONES = 2;
    public static final int CI_CONTAINING_GSC = 3;
    protected String[] columnNames;
    private MainUI _mainUI;

    public PUInstancesTableModel(MainUI mainUI) {
        this._mainUI = mainUI;
        this.initColumnNames();
    }

    @Override
    protected void initColumnNames() {
        this.columnNames = new String[4];
        this.columnNames[0] = "Instance Identifier";
        this.columnNames[1] = "Running on Host";
        this.columnNames[3] = "Containing GSC";
        this.columnNames[2] = "Zones";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    public ServiceElement getServiceElementAt(int row) {
        PUInstanceWrapper puInstanceWrapper = (PUInstanceWrapper)this.getWrapperAt(row);
        if (puInstanceWrapper != null) {
            return puInstanceWrapper.getServiceElement();
        }
        return null;
    }

    public ServiceBeanInstance getServiceBeanInstanceAt(int row) {
        PUInstanceWrapper puInstanceWrapper = (PUInstanceWrapper)this.getWrapperAt(row);
        if (puInstanceWrapper != null) {
            return puInstanceWrapper.getServiceBeanInstance();
        }
        return null;
    }

    @Override
    protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
        PUInstanceWrapper puInstanceWrapper1 = (PUInstanceWrapper)wrapper1;
        PUInstanceWrapper puInstanceWrapper2 = (PUInstanceWrapper)wrapper2;
        switch (colIndex) {
            case 0: {
                String name1 = puInstanceWrapper1.getName();
                String name2 = puInstanceWrapper2.getName();
                if (ascending) {
                    return name1.compareToIgnoreCase(name2);
                }
                return name2.compareToIgnoreCase(name1);
            }
            case 1: {
                String hostName1 = puInstanceWrapper1.getHostName();
                String hostName2 = puInstanceWrapper2.getHostName();
                if (ascending) {
                    return hostName1.compareToIgnoreCase(hostName2);
                }
                return hostName2.compareToIgnoreCase(hostName1);
            }
            case 2: {
                String[] zones1 = puInstanceWrapper1.getZones();
                String[] zones2 = puInstanceWrapper2.getZones();
                String zonesRepres1 = JSpaceUtilities.getZonesStringRepresentation((String[])zones1);
                String zonesRepres2 = JSpaceUtilities.getZonesStringRepresentation((String[])zones2);
                if (ascending) {
                    return zonesRepres1.compareToIgnoreCase(zonesRepres2);
                }
                return zonesRepres2.compareToIgnoreCase(zonesRepres1);
            }
            case 3: {
                String gscOwnerName1 = puInstanceWrapper1.getGSCOwnerName();
                String gscOwnerName2 = puInstanceWrapper2.getGSCOwnerName();
                if (ascending) {
                    return gscOwnerName1.compareToIgnoreCase(gscOwnerName2);
                }
                return gscOwnerName2.compareToIgnoreCase(gscOwnerName1);
            }
        }
        return 0;
    }

    @Override
    public Object getCellValue(BasicWrapper basicWrapper, int column) {
        PUInstanceWrapper puInstanceWrapper = (PUInstanceWrapper)basicWrapper;
        switch (column) {
            case 0: {
                return puInstanceWrapper.getName();
            }
            case 1: {
                return puInstanceWrapper.getHostName();
            }
            case 2: {
                return JSpaceUtilities.getZonesStringRepresentation((String[])puInstanceWrapper.getZones());
            }
            case 3: {
                return puInstanceWrapper.getGSCOwnerName();
            }
        }
        return "";
    }

    public void setPUInstancesServicesHolders(List<TreeWorker.ServiceHolder> puInstancesList, TreeNode opStringNode) {
        int newRowCount = puInstancesList.size();
        ArrayList<BasicWrapper> wrappersList = new ArrayList<BasicWrapper>(newRowCount);
        for (int rowIndex = 0; rowIndex < newRowCount; ++rowIndex) {
            TreeWorker.ServiceHolder serviceHolder = puInstancesList.get(rowIndex);
            boolean hasEmbeddedSpace = TreeWorker.hasEmbeddedSpace(opStringNode, serviceHolder.getServiceID());
            boolean hasGateway = TreeWorker.hasGateway(opStringNode, serviceHolder.getServiceID());
            String gscOwnerName = this._mainUI.getGscOwnerName(serviceHolder.getServiceID());
            PUInstanceWrapper puInstanceWrapper = new PUInstanceWrapper(serviceHolder.getDescription(), serviceHolder.getServiceElement(), serviceHolder.getServiceBeanInstance(), serviceHolder.getServiceID(), serviceHolder.getHostAddress(), gscOwnerName, hasEmbeddedSpace, hasGateway, serviceHolder.getZones());
            wrappersList.add(puInstanceWrapper);
        }
        this.setWrappersList(wrappersList, true);
    }

    class PUInstanceWrapper
    extends BasicWrapper {
        private final String _name;
        private final ServiceElement _serviceElement;
        private final ServiceBeanInstance _serviceBeanInstance;
        private final ServiceID _serviceID;
        private final String _hostName;
        private final String _gscOwnerName;
        private final boolean _hasEmbeddedSpace;
        private final boolean _hasGateway;
        private final String[] _zones;

        public PUInstanceWrapper(String name, ServiceElement serviceElement, ServiceBeanInstance serviceBeanInstance, ServiceID serviceID, String hostName, String gscOwnerName, boolean hasEmbeddedSpace, boolean hasGateway, String[] zones) {
            this._name = name;
            this._serviceID = serviceID;
            this._hostName = hostName;
            this._gscOwnerName = gscOwnerName;
            this._hasEmbeddedSpace = hasEmbeddedSpace;
            this._hasGateway = hasGateway;
            this._zones = zones;
            this._serviceElement = serviceElement == null ? Repository.getServiceElement(serviceID) : serviceElement;
            this._serviceBeanInstance = serviceBeanInstance == null ? Repository.getServiceBeanInstance(serviceID) : serviceBeanInstance;
        }

        public boolean hasEmbeddedSpace() {
            return this._hasEmbeddedSpace;
        }

        public boolean hasGateway() {
            return this._hasGateway;
        }

        public ServiceElement getServiceElement() {
            return this._serviceElement;
        }

        public ServiceBeanInstance getServiceBeanInstance() {
            return this._serviceBeanInstance;
        }

        public ServiceID getServiceID() {
            return this._serviceID;
        }

        public String[] getZones() {
            return this._zones;
        }

        public String getHostName() {
            return this._hostName;
        }

        public String getGSCOwnerName() {
            return this._gscOwnerName;
        }

        public String getName() {
            return this._name;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            return false;
        }

        public boolean equals(Object object) {
            PUInstanceWrapper puInstanceWrapper = (PUInstanceWrapper)object;
            return this._serviceID.equals((Object)puInstanceWrapper.getServiceID());
        }

        public int hashCode() {
            return this._serviceID.hashCode();
        }
    }
}

