/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.grid.descriptor.RemotingServiceMonitorsDescriptor;
import com.gigaspaces.admin.ui.grid.treenode.userobject.RemoteServicesHolder;
import com.gigaspaces.admin.ui.grid.views.RemoteServicesTableModel;
import com.gigaspaces.admin.ui.grid.views.ServicesTableWithTooltip;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.openspaces.pu.container.servicegrid.PUMonitors;
import org.openspaces.pu.container.servicegrid.PUServiceBean;
import org.openspaces.remoting.RemotingServiceMonitors;

public class RemoteServicesPanel
extends Box {
    private PUServiceBean _curPUServiceBean;
    private ServicesTableWithTooltip remoteServicesTable;
    private RemoteServicesTableModel _remoteServicesTableModel;
    private InstancesInfoBox _remoteServicesInfoBox;
    private boolean _isRefresh;
    private static final long TIMEOUT = 1500L;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public RemoteServicesPanel() {
        super(1);
        this.init();
        new RefreshPUMonitors().start();
    }

    private void init() {
        JPanel asyncPollingContainersPanel = this.initAsyncPollingContainersTable();
        this.add(Box.createVerticalStrut(4));
        this.add(asyncPollingContainersPanel);
        this.add(Box.createVerticalGlue());
        this.setBorder(BorderFactory.createTitledBorder("Executor Remoting Services"));
    }

    private JPanel initAsyncPollingContainersTable() {
        this._remoteServicesTableModel = new RemoteServicesTableModel();
        this.remoteServicesTable = new ServicesTableWithTooltip(this._remoteServicesTableModel);
        this.setTableProperties(this.remoteServicesTable);
        JScrollPane scrollPane = new JScrollPane(this.remoteServicesTable);
        this._remoteServicesInfoBox = new InstancesInfoBox("remote services");
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        tablePanel.add((Component)this._remoteServicesInfoBox, "South");
        return tablePanel;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    public void setRemoteServicesHolder(RemoteServicesHolder remoteServicesHolder, PUServiceBean puServiceBean) {
        this._curPUServiceBean = puServiceBean;
        this._remoteServicesTableModel.setRemoteServicesHolder(remoteServicesHolder);
        this._remoteServicesInfoBox.setCount(this.remoteServicesTable.getRowCount());
        this.updateProcessedAndFailedServices();
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
    }

    public void updateProcessedAndFailedServices() {
        block5: {
            try {
                PUMonitors puMonitors = this._curPUServiceBean.getPUMonitors();
                if (puMonitors != null) {
                    Object[] monitorsArray = puMonitors.getMonitors();
                    ArrayList<RemotingServiceMonitorsDescriptor> eventContainerServiceDescrList = new ArrayList<RemotingServiceMonitorsDescriptor>(monitorsArray.length);
                    for (Object monitor : monitorsArray) {
                        RemotingServiceMonitors remotingServiceMonitors;
                        RemotingServiceMonitors.RemoteServiceStats[] remoteDetails;
                        if (!(monitor instanceof RemotingServiceMonitors) || (remoteDetails = (remotingServiceMonitors = (RemotingServiceMonitors)monitor).getRemoteServiceStats()) == null) continue;
                        for (RemotingServiceMonitors.RemoteServiceStats remoteDetail : remoteDetails) {
                            RemotingServiceMonitorsDescriptor eventContainerServiceDescriptor = new RemotingServiceMonitorsDescriptor(remoteDetail);
                            eventContainerServiceDescrList.add(eventContainerServiceDescriptor);
                        }
                    }
                    this._remoteServicesTableModel.initProcessedAndFailedEvents(eventContainerServiceDescrList);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private class RefreshPUMonitors
    extends GSThread {
        public RefreshPUMonitors() {
            super("RefreshPUMonitors");
        }

        public void run() {
            while (true) {
                if (RemoteServicesPanel.this._isRefresh) {
                    RemoteServicesPanel.this.updateProcessedAndFailedServices();
                }
                try {
                    Thread.sleep(1500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, ie.toString(), ie);
                    continue;
                }
                break;
            }
        }
    }
}

