/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.views;

import com.gigaspaces.admin.ui.grid.descriptor.RemoteServiceWrapper;
import com.gigaspaces.admin.ui.grid.descriptor.RemotingServiceMonitorsDescriptor;
import com.gigaspaces.admin.ui.grid.treenode.userobject.RemoteServicesHolder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.openspaces.remoting.RemotingServiceDetails;

public class RemoteServicesTableModel
extends DefaultTableModel {
    private static final String CN_SERVICE_BEAN_ID = "Service Bean Id";
    private static final String CN_SERVICE_IMPL_CLASS = "Service Impl. Class";
    private static final String CN_INVOKED = "Invoked";
    private static final String CN_FAILED = "Failed";
    private static final int CI_SERVICE_BEAN_ID = 0;
    private static final int CI_SERVICE_IMPL_CLASS = 1;
    private static final int CI_INVOKED = 2;
    private static final int CI_FAILED = 3;
    protected String[] columnNames;
    protected List<RemoteServiceWrapper> _remoteServiceWrapperList = new ArrayList<RemoteServiceWrapper>();

    public RemoteServicesTableModel() {
        this.initColumnNames();
    }

    protected void initColumnNames() {
        this.columnNames = new String[4];
        this.columnNames[0] = CN_SERVICE_BEAN_ID;
        this.columnNames[1] = CN_SERVICE_IMPL_CLASS;
        this.columnNames[2] = CN_INVOKED;
        this.columnNames[3] = CN_FAILED;
    }

    @Override
    public Object getValueAt(int row, int column) {
        RemoteServiceWrapper remoteServiceWrapper;
        if (row >= 0 && row < this._remoteServiceWrapperList.size() && (remoteServiceWrapper = this._remoteServiceWrapperList.get(row)) != null) {
            return this.getCellValue(remoteServiceWrapper, column);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._remoteServiceWrapperList == null ? 0 : this._remoteServiceWrapperList.size();
    }

    public void setRemoteServicesHolder(RemoteServicesHolder remoteServicesHolder) {
        int curRowCount = this._remoteServiceWrapperList.size();
        if (curRowCount > 0) {
            this._remoteServiceWrapperList.clear();
            this.fireTableRowsDeleted(0, curRowCount - 1);
        }
        RemotingServiceDetails.RemoteService[] remoteServices = remoteServicesHolder.getRemoteServices();
        this._remoteServiceWrapperList = new ArrayList<RemoteServiceWrapper>(remoteServices.length);
        for (RemotingServiceDetails.RemoteService remoteService : remoteServices) {
            RemoteServiceWrapper remoteServiceWrapper = new RemoteServiceWrapper(remoteService.getBeanId(), remoteService.getClassName());
            this._remoteServiceWrapperList.add(remoteServiceWrapper);
        }
        curRowCount = this._remoteServiceWrapperList.size();
        if (curRowCount > 0) {
            this.fireTableRowsInserted(0, curRowCount - 1);
        }
    }

    public Object getCellValue(RemoteServiceWrapper remoteServiceWrapper, int column) {
        switch (column) {
            case 0: {
                return remoteServiceWrapper.getBeanId();
            }
            case 1: {
                return remoteServiceWrapper.getClassName();
            }
            case 2: {
                return remoteServiceWrapper.getInvoked();
            }
            case 3: {
                return remoteServiceWrapper.getFailed();
            }
        }
        return "";
    }

    public void initProcessedAndFailedEvents(List<RemotingServiceMonitorsDescriptor> eventContainerServiceDescrList) {
        for (RemotingServiceMonitorsDescriptor descriptor : eventContainerServiceDescrList) {
            for (RemoteServiceWrapper remoteServiceWrapper : this._remoteServiceWrapperList) {
                if (!descriptor.getId().equals(remoteServiceWrapper.getBeanId())) continue;
                remoteServiceWrapper.setInvoked(descriptor.getProcessed());
                remoteServiceWrapper.setFailed(descriptor.getFailed());
            }
        }
    }
}

