/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.jtreetable;

import com.gigaspaces.admin.ui.jtreetable.AbstractTreeTableModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.tree.TreeNode;

public class DynamicTreeTableModel
extends AbstractTreeTableModel {
    private String[] columnNames;
    private String[] methodNames;
    private String[] setterMethodNames;
    private Class[] cTypes;

    public DynamicTreeTableModel(TreeNode root, String[] columnNames, String[] getterMethodNames, String[] setterMethodNames, Class[] cTypes) {
        super(root);
        this.columnNames = columnNames;
        this.methodNames = getterMethodNames;
        this.setterMethodNames = setterMethodNames;
        this.cTypes = cTypes;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.columnNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.cTypes[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        try {
            if (node != null) {
                String columnName;
                Method method;
                Class<?> nodeClass = node.getClass();
                if (this.methodNames != null && (method = nodeClass.getMethod(columnName = this.methodNames[column], null)) != null) {
                    return method.invoke(node, (Object[])null);
                }
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.setterMethodNames != null && this.setterMethodNames[column] != null;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        boolean found = false;
        try {
            Method[] methods = node.getClass().getMethods();
            for (int counter = methods.length - 1; counter >= 0; --counter) {
                if (!methods[counter].getName().equals(this.setterMethodNames[column]) || methods[counter].getParameterTypes() == null || methods[counter].getParameterTypes().length != 1) continue;
                Class<?> param = methods[counter].getParameterTypes()[0];
                if (!param.isInstance(aValue)) {
                    Constructor<?> cs;
                    aValue = aValue instanceof String && ((String)aValue).length() == 0 ? null : ((cs = param.getConstructor(String.class)) != null ? cs.newInstance(aValue) : null);
                }
                methods[counter].invoke(node, aValue);
                found = true;
                break;
            }
        }
        catch (Throwable th) {
            System.out.println("exception: " + th);
        }
        if (found) {
            TreeNode parent = ((TreeNode)node).getParent();
            this.fireTreeNodesChanged(this, this.getPathToRoot(parent), new int[]{this.getIndexOfChild(parent, node)}, new Object[]{node});
        }
    }

    @Override
    public Object getChild(Object node, int i) {
        return ((TreeNode)node).getChildAt(i);
    }

    @Override
    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    @Override
    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }
}

