/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.jtreetable;

import com.gigaspaces.admin.ui.jtreetable.DummyTreeTableModel;
import com.gigaspaces.admin.ui.jtreetable.TreeTableModel;
import com.gigaspaces.admin.ui.jtreetable.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    private BasicTreeUI basicTreeUI;

    public JTreeTable() {
        this((TreeTableModel)null);
    }

    public JTreeTable(TreeTableModel treeTableModel) {
        if (treeTableModel == null) {
            treeTableModel = new DummyTreeTableModel();
        }
        this.setModel(treeTableModel);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(20);
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean retValue = super.editCellAt(row, column, e);
        if (retValue && this.getColumnClass(column) == TreeTableModel.class) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return retValue;
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setModel(TreeTableModel treeTableModel) {
        if (treeTableModel == null) {
            return;
        }
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.basicTreeUI = (BasicTreeUI)this.tree.getUI();
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    @Override
    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    if (JTreeTable.this.getSelectedRowCount() > 0) {
                        super.resetRowSelection();
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.setBounds(newX, y, w - (newX - x), h);
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            JTree t;
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            boolean rv = (t = JTreeTable.this.getTree()).isRootVisible();
            int offsetRow = rv ? r : r - 1;
            Rectangle bounds = t.getRowBounds(offsetRow);
            if (bounds != null) {
                int offset = bounds.x;
                TreeCellRenderer tcr = t.getCellRenderer();
                if (tcr instanceof DefaultTreeCellRenderer) {
                    Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                    Icon icon = t.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (JTreeTable.this.tree.isExpanded(offsetRow) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
                    if (icon != null) {
                        offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                    }
                }
                ((TreeTableTextField)this.getComponent()).offset = offset;
            }
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                int row = JTreeTable.this.rowAtPoint(me.getPoint());
                TreePath clickedTreePath = JTreeTable.this.tree.getPathForRow(row);
                boolean isExpanded1 = JTreeTable.this.tree.isExpanded(clickedTreePath);
                boolean isCollapsed1 = JTreeTable.this.tree.isCollapsed(clickedTreePath);
                if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                    for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                        if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                        MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(newME);
                        break;
                    }
                }
                if (me.getClickCount() == 1 && JTreeTable.this.columnAtPoint(me.getPoint()) == 0 && this.isClickedOnIcon(row, me.getX())) {
                    boolean isExpanded2 = JTreeTable.this.tree.isExpanded(clickedTreePath);
                    boolean isCollapsed2 = JTreeTable.this.tree.isCollapsed(clickedTreePath);
                    if (isCollapsed1 && isCollapsed2) {
                        JTreeTable.this.tree.expandPath(clickedTreePath);
                    } else if (isExpanded1 && isExpanded2) {
                        JTreeTable.this.tree.collapsePath(clickedTreePath);
                    }
                }
            }
            return false;
        }

        private boolean isClickedOnIcon(int row, int clickedX) {
            Rectangle rowBounds = JTreeTable.this.tree.getRowBounds(row);
            return clickedX < rowBounds.x && (double)clickedX > (double)rowBounds.x - 2.5 * (double)JTreeTable.this.basicTreeUI.getExpandedIcon().getIconWidth();
        }

        private Icon getIcon(int row) {
            JTree t = JTreeTable.this.getTree();
            TreeCellRenderer tcr = t.getCellRenderer();
            Icon icon = null;
            if (tcr instanceof DefaultTreeCellRenderer) {
                Object node = t.getPathForRow(row).getLastPathComponent();
                if (t.getModel().isLeaf(node)) {
                    icon = ((DefaultTreeCellRenderer)tcr).getLeafIcon();
                    if (icon == null) {
                        icon = ((DefaultTreeCellRenderer)tcr).getDefaultLeafIcon();
                    }
                } else if (JTreeTable.this.tree.isExpanded(row)) {
                    icon = ((DefaultTreeCellRenderer)tcr).getOpenIcon();
                    if (icon == null) {
                        icon = ((DefaultTreeCellRenderer)tcr).getDefaultOpenIcon();
                    }
                } else {
                    icon = ((DefaultTreeCellRenderer)tcr).getClosedIcon();
                    if (icon == null) {
                        icon = ((DefaultTreeCellRenderer)tcr).getDefaultClosedIcon();
                    }
                }
            }
            return icon;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        @Override
        public void clearToggledPaths() {
            super.clearToggledPaths();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foreground;
            Color background;
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.highlightBorder = null;
            if (JTreeTable.this.realEditingRow() == row && JTreeTable.this.getEditingColumn() == column) {
                background = UIManager.getColor("Table.focusCellBackground");
                foreground = UIManager.getColor("Table.focusCellForeground");
            } else if (hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                if (JTreeTable.this.isCellEditable(row, column)) {
                    background = UIManager.getColor("Table.focusCellBackground");
                    foreground = UIManager.getColor("Table.focusCellForeground");
                }
            }
            this.visibleRow = row;
            this.setBackground(background);
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (isSelected) {
                    dtcr.setTextSelectionColor(foreground);
                    dtcr.setBackgroundSelectionColor(background);
                } else {
                    dtcr.setTextNonSelectionColor(foreground);
                    dtcr.setBackgroundNonSelectionColor(background);
                }
            }
            return this;
        }
    }
}

