/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.lookupbrowser;

import com.gigaspaces.admin.ui.lookupbrowser.Browser;
import com.gigaspaces.admin.ui.lookupbrowser.Introspector;
import com.gigaspaces.admin.ui.lookupbrowser.ObjectNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.ServiceControlled;

abstract class EntryTreePanel
extends JPanel {
    private boolean isControllable;
    private JScrollPane scrollPane;
    protected JTree tree;
    protected ObjectNode root;
    protected DefaultTreeModel model;
    private boolean showModifier = false;
    private boolean showPackage = false;

    public EntryTreePanel(boolean isControllable) {
        this.isControllable = isControllable;
        this.setLayout(new BorderLayout());
        this.root = new ObjectNode(isControllable);
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(false);
        ObjectNodeRenderer renderer = new ObjectNodeRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.setRowHeight(0);
        this.scrollPane = new JScrollPane(this.tree);
        this.add((Component)this.scrollPane, "Center");
        this.tree.validate();
        this.scrollPane.validate();
    }

    protected abstract Entry[] getEntryArray();

    protected void initTree() {
        Entry[] entries = this.getEntryArray();
        if (entries == null) {
            entries = new Entry[]{};
        }
        for (int i = 0; i < entries.length; ++i) {
            boolean nodeControllable = false;
            if (this.isControllable && !(entries[i] instanceof ServiceControlled)) {
                nodeControllable = true;
            }
            ObjectNode node = new ObjectNode(entries[i], nodeControllable);
            this.root.add(node);
            try {
                this.recursiveObjectTree(node);
                continue;
            }
            catch (IllegalAccessException e) {
                Browser.logger.log(Level.INFO, "entry access failed", e);
            }
        }
    }

    public void refreshPanel() {
        this.root.removeAllChildren();
        this.initTree();
        this.model.nodeStructureChanged(this.root);
        this.tree.validate();
        this.scrollPane.validate();
    }

    protected void recursiveObjectTree(ObjectNode node) throws IllegalArgumentException, IllegalAccessException {
        Object obj = node.getObject();
        if (obj == null) {
            return;
        }
        Field[] fields = obj.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (Introspector.isHidden(f)) continue;
            Class<?> clazz = f.getType();
            ObjectNode child = null;
            String fname = f.getName();
            if (clazz.isPrimitive()) {
                String clazzName = clazz.toString();
                Constable fobj = null;
                if ("int".equals(clazzName)) {
                    fobj = new Integer(f.getInt(obj));
                } else if ("boolean".equals(clazzName)) {
                    fobj = new Boolean(f.getBoolean(obj));
                } else if ("byte".equals(clazzName)) {
                    fobj = new Byte(f.getByte(obj));
                } else if ("char".equals(clazzName)) {
                    fobj = new Character(f.getChar(obj));
                } else if ("double".equals(clazzName)) {
                    fobj = new Double(f.getDouble(obj));
                } else if ("float".equals(clazzName)) {
                    fobj = new Float(f.getFloat(obj));
                } else if ("long".equals(clazzName)) {
                    fobj = new Long(f.getLong(obj));
                }
                child = new ObjectNode(fobj, clazz, fname, true);
            } else if (Introspector.isWrapper(clazz) || Introspector.isString(clazz)) {
                child = new ObjectNode(f.get(obj), clazz, fname, true);
            } else if (clazz.isArray()) {
                child = new ObjectNode(f.get(obj), clazz, fname, false);
                child.setAdministrable(node.isAdministrable());
                child.setControllable(node.isControllable());
                this.recursiveArrayTree(child, f);
            } else {
                Object subobj = f.get(obj);
                if (this.countViewableFields(clazz) > 0) {
                    child = new ObjectNode(subobj, clazz, fname, false);
                    child.setAdministrable(node.isAdministrable());
                    child.setControllable(node.isControllable());
                    this.recursiveObjectTree(child);
                } else {
                    child = new ObjectNode(subobj, clazz, fname, true);
                }
            }
            node.add(child);
        }
    }

    private int countViewableFields(Class clazz) {
        int count = 0;
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (Introspector.isHidden(f)) continue;
            ++count;
        }
        return count;
    }

    private void recursiveArrayTree(ObjectNode node, Field f) throws IllegalArgumentException, IllegalAccessException {
        String name = node.getFieldName();
        Object aobj = node.getObject();
        int length = Array.getLength(aobj);
        Class<?> clazz = f.getType().getComponentType();
        if (clazz.isPrimitive() || Introspector.isWrapper(clazz) || Introspector.isString(clazz)) {
            for (int i = 0; i < length; ++i) {
                Object elem = Array.get(aobj, i);
                ObjectNode child = new ObjectNode(elem, clazz, name, i, true);
                node.add(child);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object elem = Array.get(aobj, i);
                ObjectNode child = new ObjectNode(elem, clazz, name, i, false);
                this.recursiveObjectTree(child);
                child.setAdministrable(node.isAdministrable());
                child.setControllable(node.isControllable());
                node.add(child);
            }
        }
    }

    class ObjectNodeRenderer
    implements TreeCellRenderer {
        private JLabel label = new JLabel();

        public ObjectNodeRenderer() {
            this.label.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean cellHasFocus) {
            this.label.setForeground(tree.getForeground());
            if (isSelected) {
                this.label.setBackground(MetalLookAndFeel.getPrimaryControl());
            } else {
                this.label.setBackground(tree.getBackground());
            }
            ObjectNode node = (ObjectNode)value;
            this.label.setText(node.getTitle());
            this.label.setIcon(node.getIcon());
            return this.label;
        }
    }
}

