/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.lookupbrowser;

import com.gigaspaces.admin.ui.lookupbrowser.Browser;
import com.gigaspaces.admin.ui.lookupbrowser.EntryTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;

class ServiceBrowser
extends JFrame {
    private Browser browser;
    private AttributePanel attrPanel;
    private static final int MINIMUM_WINDOW_WIDTH = 320;

    public ServiceBrowser(ServiceItem item, ServiceRegistrar registrar, Browser browser) {
        super("ServiceItem Browser");
        this.browser = browser;
        this.attrPanel = new AttributePanel(item, registrar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BrowserMenuBar(), "North");
        this.getContentPane().add((Component)this.attrPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(this.getSize().width < 320 ? 320 : this.getSize().width, this.getSize().height);
        Rectangle bounds = browser.getBounds();
        Dimension dialogSize = this.getPreferredSize();
        int xpos = bounds.x + (bounds.width - dialogSize.width) / 2;
        int ypos = bounds.y + (bounds.height - dialogSize.height) / 2;
        this.setLocation(xpos < 0 ? 0 : xpos, ypos < 0 ? 0 : ypos);
    }

    class AttributePanel
    extends EntryTreePanel {
        private ServiceItem item;
        private ServiceRegistrar registrar;

        public AttributePanel(ServiceItem item, ServiceRegistrar registrar) {
            super(false);
            this.item = item;
            this.registrar = registrar;
            this.refreshPanel();
        }

        @Override
        protected Entry[] getEntryArray() {
            try {
                ServiceMatches matches = this.registrar.lookup(new ServiceTemplate(this.item.serviceID, new Class[]{this.item.service.getClass()}, new Entry[0]), 10);
                if (matches.totalMatches == 1) {
                    return matches.items[0].attributeSets;
                }
                Browser.logger.log(Level.INFO, "unexpected lookup matches: {0}", new Integer(matches.totalMatches));
            }
            catch (Throwable t) {
                Browser.logger.log(Level.INFO, "lookup failed", t);
            }
            return null;
        }
    }

    class BrowserMenuBar
    extends JMenuBar {
        public BrowserMenuBar() {
            JMenu fileMenu = this.add(new JMenu("File"));
            JMenuItem mitem = fileMenu.add(new JMenuItem("Refresh"));
            mitem.addActionListener(ServiceBrowser.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceBrowser.this.attrPanel.refreshPanel();
                }
            }));
            mitem = fileMenu.add(new JMenuItem("Close"));
            mitem.addActionListener(ServiceBrowser.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ServiceBrowser.this.setVisible(false);
                }
            }));
        }
    }
}

