/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.security.ManageSecurityFrame;
import com.gigaspaces.admin.ui.security.SecurityManagementLoginDialog;
import com.gigaspaces.admin.ui.security.utils.PropertiesFileFilter;
import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.SecurityFactory;
import com.gigaspaces.security.SecurityManager;
import com.gigaspaces.security.directory.DirectoryAccessDeniedException;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class AdminLoginPanel
extends Box
implements ActionListener {
    private JTextField _securityPropertiesFileTextField;
    private JTextField _adminUsernameTextField;
    private JPasswordField _adminPasswordTextField;
    private JButton _browseButton;
    private JButton _submitButton;
    private JFileChooser _fileChooser;
    private final SecurityManagementLoginDialog _parentDialog;
    private JLabel _infoLabel;
    private JRadioButton _defaultSecurityRB;
    private JRadioButton _customDecurityRB;
    private static final Dimension _labelSize = new Dimension(180, 21);
    private static final Dimension _maxLabelSize = new Dimension(470, 21);
    private static final Dimension _textFieldSize = new Dimension(280, 23);
    private static final Dimension _maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension _minTextFieldSize = new Dimension(20, 23);
    private static final String DISPLAY_INFO = "ViewInfo";
    private static final String HIDE_INFO = "HideInfo";
    private PropertiesFileFilter _propertiesFileFilter;
    private UserManager _userManager;
    private RoleManager _roleManager;
    private DirectoryManager _directoryManager;
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private static final int LEFT_ALLIGN = 3;
    private JLabel _securityFileLabel;
    private ManageSecurityFrame _manageSecurityFrame;
    private CardLayout _infoCardLayout;
    private JPanel _infoPanel;

    public AdminLoginPanel(SecurityManagementLoginDialog parentDialog) {
        super(1);
        this._parentDialog = parentDialog;
        this.init();
        this.setBorder(BorderFactory.createTitledBorder(""));
    }

    private void init() {
        this._browseButton = new JButton("Browse...");
        this._browseButton.addActionListener(this);
        this._submitButton = new JButton("Submit");
        this._submitButton.addActionListener(this);
        Dimension buttonSize = new Dimension(80, 23);
        this._browseButton.setPreferredSize(buttonSize);
        this._submitButton.setPreferredSize(buttonSize);
        this._securityFileLabel = this.createLabel("Security Properties File:", new Dimension(153, 21), _maxLabelSize);
        this._securityPropertiesFileTextField = this.createTextField();
        Box securityFileBox = new Box(0);
        securityFileBox.add(Box.createHorizontalStrut(25));
        securityFileBox.add(this._securityFileLabel);
        securityFileBox.add(this._securityPropertiesFileTextField);
        securityFileBox.add(Box.createHorizontalStrut(3));
        securityFileBox.add(this._browseButton);
        securityFileBox.add(Box.createHorizontalGlue());
        JLabel adminUsernameLabel = this.createLabel("Administrator Username:");
        this._adminUsernameTextField = this.createTextField();
        Box adminUsernameBox = new Box(0);
        adminUsernameBox.add(Box.createHorizontalStrut(3));
        adminUsernameBox.add(adminUsernameLabel);
        adminUsernameBox.add(this._adminUsernameTextField);
        adminUsernameBox.add(Box.createHorizontalGlue());
        JLabel adminPasswordLabel = this.createLabel("Administrator Password:");
        this._adminPasswordTextField = this.createPasswordField();
        CustomKeyListener cutsomKeyListener = new CustomKeyListener();
        this._adminUsernameTextField.addKeyListener(cutsomKeyListener);
        this._adminPasswordTextField.addKeyListener(cutsomKeyListener);
        Box adminPasswordBox = new Box(0);
        adminPasswordBox.add(Box.createHorizontalStrut(3));
        adminPasswordBox.add(adminPasswordLabel);
        adminPasswordBox.add(this._adminPasswordTextField);
        adminPasswordBox.add(Box.createHorizontalGlue());
        JLabel defaultLoginPropsLabel = this.createLabel("[Default: admin/admin]");
        Box defaultLoginDetailsBox = new Box(0);
        defaultLoginDetailsBox.add(Box.createHorizontalStrut(3));
        defaultLoginDetailsBox.add(defaultLoginPropsLabel);
        defaultLoginDetailsBox.add(Box.createHorizontalGlue());
        Box applyButtonBox = new Box(0);
        applyButtonBox.add(Box.createHorizontalGlue());
        applyButtonBox.add(this._submitButton);
        applyButtonBox.add(Box.createHorizontalGlue());
        this._infoLabel = new JLabel(IconsRepository.getInstance().getIcon(100));
        this._infoLabel.setForeground(Color.RED);
        this._infoLabel.setFont(this._infoLabel.getFont().deriveFont(20).deriveFont(1));
        this._defaultSecurityRB = new JRadioButton("Use default configuration", true);
        this._customDecurityRB = new JRadioButton("Use the following security file:");
        this.setConfigurationFileComponentEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._defaultSecurityRB);
        buttonGroup.add(this._customDecurityRB);
        this._defaultSecurityRB.addActionListener(this);
        this._customDecurityRB.addActionListener(this);
        Box defaultSecurityRbBox = new Box(0);
        defaultSecurityRbBox.add(Box.createHorizontalStrut(3));
        defaultSecurityRbBox.add(this._defaultSecurityRB);
        defaultSecurityRbBox.add(Box.createHorizontalGlue());
        Box customSecurityRbBox = new Box(0);
        customSecurityRbBox.add(Box.createHorizontalStrut(3));
        customSecurityRbBox.add(this._customDecurityRB);
        customSecurityRbBox.add(Box.createHorizontalGlue());
        Box infoBox = new Box(0);
        infoBox.add(this._infoLabel);
        infoBox.add(Box.createHorizontalGlue());
        this._infoCardLayout = new CardLayout();
        this._infoPanel = new JPanel(this._infoCardLayout);
        this._infoPanel.add((Component)infoBox, DISPLAY_INFO);
        this._infoPanel.add((Component)new Box(0), HIDE_INFO);
        this._infoPanel.setPreferredSize(new Dimension(700, 20));
        this._infoPanel.setMaximumSize(new Dimension(700, 20));
        Box securityConfigFileBox = new Box(1);
        securityConfigFileBox.setBorder(BorderFactory.createTitledBorder("Security Configuration File"));
        securityConfigFileBox.add(defaultSecurityRbBox);
        securityConfigFileBox.add(Box.createVerticalStrut(6));
        securityConfigFileBox.add(customSecurityRbBox);
        securityConfigFileBox.add(Box.createVerticalStrut(6));
        securityConfigFileBox.add(securityFileBox);
        securityConfigFileBox.add(Box.createVerticalStrut(6));
        this.add(Box.createVerticalStrut(7));
        this.add(securityConfigFileBox);
        this.add(Box.createVerticalStrut(7));
        this.add(adminUsernameBox);
        this.add(Box.createVerticalStrut(7));
        this.add(adminPasswordBox);
        this.add(Box.createVerticalStrut(5));
        this.add(defaultLoginDetailsBox);
        this.add(Box.createVerticalStrut(4));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(1));
        this.add(applyButtonBox);
        this.add(this._infoPanel);
        this._infoCardLayout.show(this._infoPanel, HIDE_INFO);
    }

    public void clear() {
        this._defaultSecurityRB.setSelected(true);
        this._adminUsernameTextField.setText("");
        this._adminPasswordTextField.setText("");
        this._securityPropertiesFileTextField.setText("");
        this.setConfigurationFileComponentEnabled(false);
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(_textFieldSize);
        textField.setMaximumSize(_maxTextFieldSize);
        textField.setMinimumSize(_minTextFieldSize);
        return textField;
    }

    private JPasswordField createPasswordField() {
        JPasswordField passwordField = new JPasswordField();
        passwordField.setPreferredSize(_textFieldSize);
        passwordField.setMaximumSize(_maxTextFieldSize);
        passwordField.setMinimumSize(_minTextFieldSize);
        return passwordField;
    }

    private JLabel createLabel(String text) {
        return this.createLabel(text, _labelSize, _maxLabelSize);
    }

    private JLabel createLabel(String text, Dimension labelSize, Dimension maxLabelSize) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    private void openBrowseDialog() {
        int returnState;
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser(SystemInfo.singleton().locations().config());
            this._fileChooser.setDialogType(0);
            this._propertiesFileFilter = new PropertiesFileFilter("Properties File( *.properties )");
            this._fileChooser.setFileFilter(this._propertiesFileFilter);
        }
        if ((returnState = this._fileChooser.showOpenDialog(this._parentDialog)) == 0) {
            File selectedFile = this._fileChooser.getSelectedFile();
            this._securityPropertiesFileTextField.setText(selectedFile.getPath());
        }
    }

    public boolean isAllDataValid() {
        boolean isValid = false;
        String securityFilePath = this.getSecurityPropertiesFilePath();
        String adminUserName = this.getAdminUserName();
        if (this._customDecurityRB.isSelected() && JSpaceUtilities.isEmpty((String)securityFilePath, (boolean)true) && JSpaceUtilities.isEmpty((String)adminUserName, (boolean)true)) {
            this._infoLabel.setText("Both security file and administrator username must be provided");
            this.setInfoVisible(true);
        } else if (this._customDecurityRB.isSelected() && JSpaceUtilities.isEmpty((String)securityFilePath, (boolean)true)) {
            this._infoLabel.setText("Security file must be provided");
            this.setInfoVisible(true);
        } else if (this._customDecurityRB.isSelected() && !new File(securityFilePath).exists()) {
            this._infoLabel.setText("The security file you provided does not exist");
            this.setInfoVisible(true);
        } else if (this._customDecurityRB.isSelected() && !securityFilePath.toLowerCase().endsWith(".properties")) {
            this._infoLabel.setText("The security file you provided is not a .properties file");
            this.setInfoVisible(true);
        } else if (JSpaceUtilities.isEmpty((String)adminUserName, (boolean)true)) {
            this._infoLabel.setText("Administrator username must be provided");
            this.setInfoVisible(true);
        } else {
            isValid = true;
        }
        return isValid;
    }

    public String getSecurityPropertiesFilePath() {
        if (this._customDecurityRB.isSelected()) {
            return this._securityPropertiesFileTextField.getText();
        }
        return null;
    }

    public String getAdminUserName() {
        return this._adminUsernameTextField.getText();
    }

    public String getAdminPassword() {
        return String.valueOf(this._adminPasswordTextField.getPassword());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._defaultSecurityRB)) {
            this.setConfigurationFileComponentEnabled(false);
        } else if (source.equals(this._customDecurityRB)) {
            this.setConfigurationFileComponentEnabled(true);
        } else if (source.equals(this._browseButton)) {
            this.openBrowseDialog();
        } else if (source.equals(this._submitButton)) {
            this.applySecurityConfiguration();
        }
    }

    private void applySecurityConfiguration() {
        try {
            this._parentDialog.setCursor(Cursor.getPredefinedCursor(3));
            if (this.isAllDataValid()) {
                this.performLogin();
            }
        }
        finally {
            this._parentDialog.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void performLogin() {
        String path = this.getSecurityPropertiesFilePath();
        try {
            boolean isDirectoryManagerInitialized;
            block10: {
                Properties securityProperties = path == null ? new Properties() : SecurityFactory.loadSecurityProperties((String)path);
                SecurityManager create = SecurityFactory.createSecurityManager((Properties)securityProperties);
                String username = this.getAdminUserName();
                String password = this.getAdminPassword();
                isDirectoryManagerInitialized = true;
                User loginUser = new User(username, password);
                try {
                    this._directoryManager = create.createDirectoryManager((UserDetails)loginUser);
                    this._userManager = this._directoryManager.getUserManager();
                    this._roleManager = this._directoryManager.getRoleManager();
                }
                catch (DirectoryAccessDeniedException e) {
                    isDirectoryManagerInitialized = false;
                    this._infoLabel.setText("Access denied - Restricted to external tool");
                    this.setInfoVisible(true);
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.toString(), e);
                    }
                }
                catch (AccessDeniedException ade) {
                    isDirectoryManagerInitialized = false;
                    this._infoLabel.setText("Access denied - Insufficient privileges to manage security directory");
                    this.setInfoVisible(true);
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, ade.toString(), ade);
                    }
                }
                catch (AuthenticationException ae) {
                    isDirectoryManagerInitialized = false;
                    this._infoLabel.setText("Authentication failure");
                    this.setInfoVisible(true);
                    if (!LOGGER.isLoggable(Level.WARNING)) break block10;
                    LOGGER.log(Level.WARNING, ae.toString(), ae);
                }
            }
            if (isDirectoryManagerInitialized) {
                this._parentDialog.setVisible(false);
                JFrame parentFrame = this._parentDialog.getParentFrame();
                this._manageSecurityFrame = new ManageSecurityFrame(parentFrame, this._directoryManager, this._userManager, this._roleManager);
                this._manageSecurityFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        AdminLoginPanel.this._manageSecurityFrame = null;
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        AdminLoginPanel.this._manageSecurityFrame = null;
                    }
                });
                this._manageSecurityFrame.setLocationRelativeTo(parentFrame);
                this._manageSecurityFrame.setVisible(true);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.setInfoVisible(true);
            this._infoLabel.setText("Failed to login with the provided credentials. User and Role management are not available");
        }
    }

    public ManageSecurityFrame getManageSecurityFrame() {
        return this._manageSecurityFrame;
    }

    public void setInfoVisible(boolean visible) {
        if (visible) {
            this._infoCardLayout.show(this._infoPanel, DISPLAY_INFO);
        } else {
            this._infoCardLayout.show(this._infoPanel, HIDE_INFO);
        }
    }

    private void setConfigurationFileComponentEnabled(boolean enabled) {
        this._securityPropertiesFileTextField.setEnabled(enabled);
        this._browseButton.setEnabled(enabled);
        this._securityFileLabel.setEnabled(enabled);
    }

    public void closeServices() {
        if (this._directoryManager != null) {
            this._directoryManager.close();
        }
    }

    public class CustomKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                AdminLoginPanel.this.applySecurityConfiguration();
            }
        }
    }
}

