/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.security.RolePermissionsPanel;
import com.gigaspaces.admin.ui.security.RolesListPanel;
import com.gigaspaces.admin.ui.security.UserPermissionsPanel;
import com.gigaspaces.admin.ui.security.UsersListPanel;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.RoleDetails;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ManageSecurityFrame
extends JFrame {
    private RolesListPanel _rolesListPanel;
    private UsersListPanel _usersListPanel;
    private JTabbedPane _tabbedPane = new JTabbedPane();
    private UserPermissionsPanel _userPermissionsPanel;
    private RolePermissionsPanel _rolePermissionsPanel;
    private static final String USERS_ROLES_LIST_VIEW = "UserRoles_Lists_View";
    private static final String USERS_DETAILS_VIEW = "User_Details_View";
    private static final String ROLES_DETAILS_VIEW = "Roles_Details_View";
    private DirectoryManager _directoryManager;
    private UserManager _userManager;
    private RoleManager _roleManager;
    private CardLayout _cardLayout;
    private JPanel _cardPanel;
    private static final String MANAGE_USERS_ROLES_TITLE = "Manage Users/Roles";
    private static final String CREATE_NEW_USER_TITLE = "Create New User";
    private static final String CREATE_NEW_ROLE_TITLE = "Create New Role";
    private static final String EDIT_USER_TITLE = "Edit User";
    private static final String EDIT_ROLE_TITLE = "Edit Role";
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public ManageSecurityFrame(JFrame parentFrame, DirectoryManager directoryManager, UserManager userManager, RoleManager roleManager) {
        super(MANAGE_USERS_ROLES_TITLE);
        this._directoryManager = directoryManager;
        this._userManager = userManager;
        this._roleManager = roleManager;
        Image logoImage = UIHelper.getImageIcon("image/browser/jspacesIcon.png").getImage();
        this.setIconImage(logoImage);
        this.init();
        this.setSize(1000, 500);
        this.setLocationRelativeTo(parentFrame);
        this.setDefaultCloseOperation(2);
    }

    private void init() {
        this._cardLayout = new CardLayout();
        this._cardPanel = new JPanel(this._cardLayout);
        this.getContentPane().add((Component)this._cardPanel, "Center");
        this._tabbedPane = new JTabbedPane();
        this._cardPanel.add((Component)this._tabbedPane, USERS_ROLES_LIST_VIEW);
        this._usersListPanel = new UsersListPanel(this, this._directoryManager, this._userManager);
        this._tabbedPane.add((Component)this._usersListPanel, "Users");
        this._rolesListPanel = new RolesListPanel(this, this._directoryManager, this._roleManager, this._userManager);
        this._tabbedPane.add((Component)this._rolesListPanel, "Roles");
        this._userPermissionsPanel = new UserPermissionsPanel(this, this._directoryManager, this._userManager, this._roleManager);
        this._cardPanel.add((Component)this._userPermissionsPanel, USERS_DETAILS_VIEW);
        this._rolePermissionsPanel = new RolePermissionsPanel(this, this._directoryManager, this._roleManager);
        this._cardPanel.add((Component)this._rolePermissionsPanel, ROLES_DETAILS_VIEW);
    }

    public void duplicateRole(RoleDetails role) {
        this.showRolePermissionsView();
        this.setTitle(CREATE_NEW_ROLE_TITLE);
        this._rolePermissionsPanel.duplicateRole(role);
    }

    public void editRole(RoleDetails role) {
        this.showRolePermissionsView();
        this.setTitle(EDIT_ROLE_TITLE);
        this._rolePermissionsPanel.editRole(role);
    }

    public void newRole() {
        this.showRolePermissionsView();
        this.setTitle(CREATE_NEW_ROLE_TITLE);
        this._rolePermissionsPanel.newRole();
    }

    public void duplicateUser(UserDetails user) {
        this.showUserPermissionsView();
        this.setTitle(CREATE_NEW_USER_TITLE);
        this._userPermissionsPanel.duplicateUser(user);
    }

    public void editUser(UserDetails user) {
        this.showUserPermissionsView();
        this.setTitle(EDIT_USER_TITLE);
        this._userPermissionsPanel.editUser(user);
    }

    public void newUser() {
        this.showUserPermissionsView();
        this.setTitle(CREATE_NEW_USER_TITLE);
        this._userPermissionsPanel.newUser();
    }

    private void showUserPermissionsView() {
        this._cardLayout.show(this._cardPanel, USERS_DETAILS_VIEW);
    }

    private void showRolePermissionsView() {
        this._cardLayout.show(this._cardPanel, ROLES_DETAILS_VIEW);
    }

    public void showUsersAndRolesListsView() {
        this._cardLayout.show(this._cardPanel, USERS_ROLES_LIST_VIEW);
        this.setTitle(MANAGE_USERS_ROLES_TITLE);
    }

    public void closeWindow() {
        this.dispose();
    }

    private static void setLookAndFeel() throws UnsupportedLookAndFeelException {
        String lookAndFeelClassName = System.getProperty("com.gs.ui.laf.classname");
        if (lookAndFeelClassName != null) {
            try {
                UIManager.setLookAndFeel(lookAndFeelClassName);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
                LOGGER.log(Level.INFO, "Because an error with setting \"" + lookAndFeelClassName + "\" Look&Feel the \"" + Plastic3DLookAndFeel.class.getName() + "\" Look&Feel class will be used.");
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
        } else {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
    }

    public void addCreatedUser(UserDetails user) {
        this._usersListPanel.addCreatedUser(user);
    }

    public void addModifiedUser(UserDetails user) {
        this._usersListPanel.addModifiedUser(user);
    }

    public void addCreatedRole(RoleDetails role) {
        this._rolesListPanel.addCreatedRole(role);
    }

    public void addModifiedRole(RoleDetails role) {
        this._rolesListPanel.addModifiedRole(role);
    }

    public void refreshUsers() {
        this._usersListPanel.refreshUsers();
    }

    public static void main(String[] args) {
        try {
            MainUI.setLookAndFeel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ManageSecurityFrame frame = new ManageSecurityFrame(new JFrame(), null, null, null);
        frame.setVisible(true);
    }
}

