/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.security.ISecurityConstants;
import com.gigaspaces.admin.ui.security.utils.INameChangeListener;
import com.gigaspaces.security.directory.RoleDetails;
import com.j_spaces.kernel.JSpaceUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RoleDetailsBox
extends Box
implements ISecurityConstants {
    private JTextField _roleNameTextField;
    private JFrame _parentFrame;
    private static final Dimension labelSize = new Dimension(85, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension textFieldSize = new Dimension(270, 23);
    private static final Dimension maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension minTextFieldSize = new Dimension(20, 23);
    private List<INameChangeListener> _nameListenersList = new ArrayList<INameChangeListener>();
    private static final int LEFT_ALLIGN = 2;

    public RoleDetailsBox(JFrame parentFrame) {
        super(1);
        this._parentFrame = parentFrame;
        this.init();
    }

    private void init() {
        JLabel roleNameLabel = this.createLabel("Role Name:");
        this._roleNameTextField = this.createTextField();
        this._roleNameTextField.setText(" ");
        Box userNameBox = new Box(0);
        userNameBox.add(Box.createHorizontalStrut(2));
        userNameBox.add(roleNameLabel);
        userNameBox.add(this._roleNameTextField);
        userNameBox.add(Box.createHorizontalGlue());
        this._roleNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RoleDetailsBox.this.fireRoleNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RoleDetailsBox.this.fireRoleNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RoleDetailsBox.this.fireRoleNameChanged();
            }
        });
        this.add(Box.createVerticalStrut(5));
        this.add(userNameBox);
        this.add(Box.createVerticalStrut(5));
    }

    public void addNameChangeListener(INameChangeListener nameChangeListener) {
        this._nameListenersList.add(nameChangeListener);
    }

    private void fireRoleNameChanged() {
        for (INameChangeListener nameChangeListener : this._nameListenersList) {
            boolean isNameValid = this.isDataValid(false);
            nameChangeListener.nameChanged(isNameValid);
        }
    }

    public void setMode(short mode) {
        if (mode == 1 || mode == 2) {
            this._roleNameTextField.setBackground(Color.WHITE);
            this._roleNameTextField.setEditable(true);
        } else if (mode == 3) {
            this._roleNameTextField.setBackground(SystemColor.control);
            this._roleNameTextField.setEditable(false);
        }
    }

    public void editRole(RoleDetails role) {
        this._roleNameTextField.setText(role.getRole());
    }

    public void duplicateRole(RoleDetails role) {
        this._roleNameTextField.setText("Copy_" + role.getRole());
        this._roleNameTextField.grabFocus();
    }

    public void newRole() {
        this._roleNameTextField.grabFocus();
    }

    public void clear() {
        this._roleNameTextField.setText("");
    }

    private boolean isNameValid(String str) {
        return str.indexOf(32) == -1;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        return textField;
    }

    public String getRoleName() {
        return this._roleNameTextField.getText();
    }

    public boolean isDataValid(boolean isShowMessage) {
        String roleName = this._roleNameTextField.getText();
        if (JSpaceUtilities.isEmpty((String)roleName, (boolean)true)) {
            if (isShowMessage) {
                JOptionPane.showMessageDialog(this._parentFrame, "Please provide a role name.", "Create Role", 1);
            }
            return false;
        }
        if (!this.isNameValid(roleName)) {
            if (isShowMessage) {
                JOptionPane.showMessageDialog(this._parentFrame, "The role name you have entered contains illegal characters.\nPlease use alphanumeric characters, underscores and dashes.", "Create Role", 1);
            }
            return false;
        }
        return true;
    }
}

