/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.security.ISecurityConstants;
import com.gigaspaces.admin.ui.security.ManageSecurityFrame;
import com.gigaspaces.admin.ui.security.RoleDetailsBox;
import com.gigaspaces.admin.ui.security.utils.INameChangeListener;
import com.gigaspaces.admin.ui.security.utils.PermissionsBox;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.Role;
import com.gigaspaces.security.directory.RoleAlreadyExistsException;
import com.gigaspaces.security.directory.RoleDetails;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.UserDataAccessException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RolePermissionsPanel
extends JPanel
implements ActionListener,
ISecurityConstants,
INameChangeListener {
    private JButton _createButton;
    private JButton _cancelButton;
    private PermissionsBox _permissionsBox;
    private RoleDetailsBox _roleDetailsBox;
    private short _mode;
    private DirectoryManager _directoryManager;
    private RoleManager _roleManager;
    private RoleDetails _newRole;
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private ManageSecurityFrame _parentManageSecurityFrame;

    public RolePermissionsPanel(ManageSecurityFrame parentFrame, DirectoryManager directoryManager, RoleManager roleManager) {
        this._parentManageSecurityFrame = parentFrame;
        this._directoryManager = directoryManager;
        this._roleManager = roleManager;
        this.init();
        this.setSize(700, 570);
    }

    private void init() {
        this._roleDetailsBox = new RoleDetailsBox(this._parentManageSecurityFrame);
        this._roleDetailsBox.addNameChangeListener(this);
        Box buttonsBox = this.initButtonsBox();
        this._permissionsBox = new PermissionsBox(this._parentManageSecurityFrame, false);
        this.setLayout(new BorderLayout());
        this.add((Component)this._roleDetailsBox, "North");
        this.add((Component)this._permissionsBox, "Center");
        this.add((Component)buttonsBox, "South");
        this.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 2));
    }

    private Box initButtonsBox() {
        this._createButton = new JButton("Create");
        this._cancelButton = new JButton("Cancel");
        this._createButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        Dimension buttonSize = new Dimension(80, 23);
        this._createButton.setPreferredSize(buttonSize);
        this._cancelButton.setPreferredSize(buttonSize);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this._createButton);
        buttonsBox.add(Box.createHorizontalStrut(15));
        buttonsBox.add(this._cancelButton);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        return buttonsBox;
    }

    private void setMode(short mode) {
        this._mode = mode;
        this._roleDetailsBox.setMode(mode);
        if (mode == 1 || mode == 2) {
            this._createButton.setText("Create");
        } else if (mode == 3) {
            this._createButton.setText("Update");
        }
    }

    private RoleDetails createRole() {
        if (!this._roleDetailsBox.isDataValid(true) || !this._permissionsBox.isDataValid()) {
            return null;
        }
        List<Authority> authoritiesList = this._permissionsBox.getAuthorities();
        Authority[] authoritiesArray = new Authority[authoritiesList.size()];
        int listSize = authoritiesList.size();
        for (int index = 0; index < listSize; ++index) {
            authoritiesArray[index] = authoritiesList.get(index);
        }
        String roleName = this._roleDetailsBox.getRoleName();
        Role role = new Role(roleName, authoritiesArray);
        try {
            if (this._mode == 1 || this._mode == 2) {
                this._roleManager.createRole((RoleDetails)role);
                this._directoryManager.close();
                this._parentManageSecurityFrame.addCreatedRole((RoleDetails)role);
            } else if (this._mode == 3) {
                this._roleManager.updateRole((RoleDetails)role);
                this._directoryManager.close();
                this._parentManageSecurityFrame.addModifiedRole((RoleDetails)role);
            }
        }
        catch (RoleAlreadyExistsException exc) {
            JOptionPane.showMessageDialog(this, "Role [" + roleName + "] is already in use. Please use a different username.", "Create Role", 1);
            role = null;
        }
        catch (UserDataAccessException exc) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
            role = null;
        }
        catch (Exception exc) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
            role = null;
        }
        this._newRole = role;
        return this._newRole;
    }

    public RoleDetails getNewRole() {
        return this._newRole;
    }

    private void clear() {
        this._newRole = null;
        this._roleDetailsBox.clear();
        this._permissionsBox.clear();
    }

    public void editRole(RoleDetails role) {
        this.clear();
        this.setMode((short)3);
        this._roleDetailsBox.editRole(role);
        this._permissionsBox.editAuthorities(role.getAuthorities());
    }

    public void duplicateRole(RoleDetails role) {
        this.clear();
        this.setMode((short)2);
        this._roleDetailsBox.duplicateRole(role);
        this._permissionsBox.editAuthorities(role.getAuthorities());
    }

    public void newRole() {
        this.clear();
        this.setMode((short)1);
        this._roleDetailsBox.newRole();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._createButton)) {
            if (this.createRole() != null) {
                this._parentManageSecurityFrame.showUsersAndRolesListsView();
            }
        } else if (source.equals(this._cancelButton)) {
            this._parentManageSecurityFrame.showUsersAndRolesListsView();
        }
    }

    @Override
    public void nameChanged(boolean isValidName) {
        this._createButton.setEnabled(isValidName);
    }
}

