/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.grid.space.ISearchComponent;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.admin.ui.security.ManageSecurityFrame;
import com.gigaspaces.admin.ui.util.TableWithTooltip;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.DirectoryManagerUtils;
import com.gigaspaces.security.directory.RoleDetails;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RolesListPanel
extends JPanel
implements ActionListener {
    private JButton _createNewRoleButton;
    private JButton _editRoleButton;
    private JButton _duplicateRoleButton;
    private JButton _deleteRoleButton;
    private JButton _closeButton;
    private JMenuItem _editRoleMenuItem;
    private JMenuItem _duplicateRoleMenuItem;
    private JMenuItem _deleteRoleMenuItem;
    private JPopupMenu _popupMenu;
    private JTable _roleDetailsTable;
    private RoleDetailsTableModel _rolesDetailsTableModel;
    private final ManageSecurityFrame _parentManageSecurityDialog;
    private final DirectoryManager _directoryManager;
    private final RoleManager _roleManager;
    private final UserManager _userManager;
    private SearchEditor _searchEditor;
    private static final int LEFT_ALLIGN = 3;
    private boolean _isReadOnlyMode;

    public RolesListPanel(ManageSecurityFrame parentDialog, DirectoryManager directoryManager, RoleManager roleManager, UserManager userManager) {
        this._parentManageSecurityDialog = parentDialog;
        this._directoryManager = directoryManager;
        this._roleManager = roleManager;
        this._userManager = userManager;
        this.init();
        this.fillRoles();
        this.setBorder(BorderFactory.createTitledBorder(""));
        if (roleManager != null) {
            this._isReadOnlyMode = roleManager.isReadOnly();
        }
        if (this._isReadOnlyMode) {
            this._createNewRoleButton.setEnabled(false);
            this._editRoleButton.setEnabled(false);
            this._duplicateRoleButton.setEnabled(false);
            this._deleteRoleButton.setEnabled(false);
            this._editRoleMenuItem.setEnabled(false);
            this._duplicateRoleMenuItem.setEnabled(false);
            this._deleteRoleMenuItem.setEnabled(false);
        }
    }

    private void init() {
        this.createPopupMenu();
        this._createNewRoleButton = new JButton("Create New Role...");
        Box createNewUserBox = new Box(0);
        createNewUserBox.add(Box.createHorizontalStrut(3));
        createNewUserBox.add(this._createNewRoleButton);
        createNewUserBox.add(Box.createHorizontalGlue());
        createNewUserBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this._createNewRoleButton.addActionListener(this);
        this._rolesDetailsTableModel = new RoleDetailsTableModel();
        this._roleDetailsTable = new TableWithTooltip(this._rolesDetailsTableModel);
        this.setTableProperties(this._roleDetailsTable);
        JScrollPane scrollPane = new JScrollPane(this._roleDetailsTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this._searchEditor = new SearchEditor(this._rolesDetailsTableModel);
        Box searchBox = new Box(0);
        searchBox.add(Box.createHorizontalGlue());
        searchBox.add(this._searchEditor);
        searchBox.add(Box.createHorizontalStrut(3));
        searchBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)searchBox, "North");
        scrollPanel.add((Component)scrollPane, "Center");
        this._roleDetailsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int selRow = RolesListPanel.this._roleDetailsTable.rowAtPoint(mouseEvent.getPoint());
                    if (selRow >= 0) {
                        RolesListPanel.this._roleDetailsTable.setRowSelectionInterval(selRow, selRow);
                    }
                    RolesListPanel.this._popupMenu.show(RolesListPanel.this._roleDetailsTable, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() > 1 && !RolesListPanel.this._isReadOnlyMode) {
                    RolesListPanel.this.editRole();
                }
            }
        });
        this._roleDetailsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RolesListPanel.this.setUserManagementButtonsEnabled(RolesListPanel.this._roleDetailsTable.getSelectedRows().length > 0);
            }
        });
        this._editRoleButton = new JButton("Edit...");
        this._duplicateRoleButton = new JButton("Duplicate...");
        this._deleteRoleButton = new JButton("Delete");
        this._closeButton = new JButton("Close");
        Box bottomButtonsBox = new Box(0);
        bottomButtonsBox.add(Box.createHorizontalStrut(3));
        bottomButtonsBox.add(this._editRoleButton);
        bottomButtonsBox.add(Box.createHorizontalStrut(5));
        bottomButtonsBox.add(this._duplicateRoleButton);
        bottomButtonsBox.add(Box.createHorizontalStrut(5));
        bottomButtonsBox.add(this._deleteRoleButton);
        bottomButtonsBox.add(Box.createHorizontalGlue());
        bottomButtonsBox.add(this._closeButton);
        bottomButtonsBox.add(Box.createHorizontalStrut(3));
        bottomButtonsBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this._editRoleButton.addActionListener(this);
        this._duplicateRoleButton.addActionListener(this);
        this._deleteRoleButton.addActionListener(this);
        this._closeButton.addActionListener(this);
        Dimension buttonSize = new Dimension(85, 23);
        this._editRoleButton.setPreferredSize(buttonSize);
        this._duplicateRoleButton.setPreferredSize(buttonSize);
        this._deleteRoleButton.setPreferredSize(buttonSize);
        this._closeButton.setPreferredSize(buttonSize);
        this._createNewRoleButton.setPreferredSize(new Dimension(135, 23));
        this.setLayout(new BorderLayout());
        this.add((Component)createNewUserBox, "North");
        this.add((Component)scrollPanel, "Center");
        this.add((Component)bottomButtonsBox, "South");
        this.setUserManagementButtonsEnabled(false);
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn roleNameTableColumn = tableColumnModel.getColumn(0);
        TableColumn permissionsTableColumn = tableColumnModel.getColumn(1);
        TableColumn relatedUsersTableColumn = tableColumnModel.getColumn(2);
        roleNameTableColumn.setPreferredWidth(50);
        permissionsTableColumn.setPreferredWidth(180);
        relatedUsersTableColumn.setPreferredWidth(140);
    }

    private void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        this._editRoleMenuItem = new JMenuItem("Edit...");
        this._duplicateRoleMenuItem = new JMenuItem("Duplicate...");
        this._deleteRoleMenuItem = new JMenuItem("Delete");
        this._popupMenu.add(this._editRoleMenuItem);
        this._popupMenu.add(this._duplicateRoleMenuItem);
        this._popupMenu.add(this._deleteRoleMenuItem);
        this._editRoleMenuItem.addActionListener(this);
        this._duplicateRoleMenuItem.addActionListener(this);
        this._deleteRoleMenuItem.addActionListener(this);
    }

    private void fillRoles() {
        if (this._roleManager != null) {
            Map rolesDetailsMap = this._roleManager.mapRoles();
            ArrayList<RoleDetails> roleDetailsList = new ArrayList<RoleDetails>(rolesDetailsMap.values());
            this._rolesDetailsTableModel.setRoles(roleDetailsList);
        }
    }

    public void clear() {
        this._searchEditor.clear();
        this._rolesDetailsTableModel.clear();
        this.setUserManagementButtonsEnabled(false);
    }

    private void setUserManagementButtonsEnabled(boolean enabled) {
        if (!this._isReadOnlyMode) {
            this._editRoleButton.setEnabled(enabled);
            this._duplicateRoleButton.setEnabled(enabled);
            this._deleteRoleButton.setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._createNewRoleButton)) {
            this.createNewRole();
        } else if (source.equals(this._closeButton)) {
            this._parentManageSecurityDialog.closeWindow();
        } else if (source.equals(this._editRoleButton) || source.equals(this._editRoleMenuItem)) {
            this.editRole();
        } else if (source.equals(this._duplicateRoleButton) || source.equals(this._duplicateRoleMenuItem)) {
            this.duplicateRole();
        } else if (source.equals(this._deleteRoleButton) || source.equals(this._deleteRoleMenuItem)) {
            this.deleteRoles();
        }
    }

    private void duplicateRole() {
        int[] selectedRows = this._roleDetailsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to duplicate role - no role selected. Please select one role in table.", "Duplicate Role", 1);
            return;
        }
        if (selectedRows.length > 1) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to duplicate role - more than one role selected. Please select only one role in table.", "Duplicate Role", 1);
            return;
        }
        RoleDetails roleDetails = this._rolesDetailsTableModel.getRoleDetailsAt(selectedRows[0]);
        if (roleDetails != null) {
            this._parentManageSecurityDialog.duplicateRole(roleDetails);
        }
    }

    private void deleteRoles() {
        int returnValue;
        int[] selectedRows = this._roleDetailsTable.getSelectedRows();
        if (selectedRows.length > 0 && (returnValue = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete selected role(s)?", "Delete Users", 0, 1)) == 0) {
            this._rolesDetailsTableModel.removeRolesAt(selectedRows);
            if (selectedRows[0] < this._rolesDetailsTableModel.getRowCount()) {
                this._roleDetailsTable.setRowSelectionInterval(selectedRows[0], selectedRows[0]);
            } else if (this._rolesDetailsTableModel.getRowCount() > 0) {
                this._roleDetailsTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void editRole() {
        int[] selectedRows = this._roleDetailsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to edit user - no user selected. Please select one user in table.", "Edit User", 1);
            return;
        }
        if (selectedRows.length > 1) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to edit user - more than one user selected. Please select only one user in table.", "Edit User", 1);
            return;
        }
        RoleDetails roleDetails = this._rolesDetailsTableModel.getRoleDetailsAt(selectedRows[0]);
        if (roleDetails != null) {
            this._parentManageSecurityDialog.editRole(roleDetails);
        }
    }

    private void createNewRole() {
        this._parentManageSecurityDialog.newRole();
    }

    public void addCreatedRole(RoleDetails role) {
        this._rolesDetailsTableModel.addNewRole(role);
    }

    public void addModifiedRole(RoleDetails role) {
        this._rolesDetailsTableModel.addModifiedRole(role);
    }

    private class RoleDetailsTableModel
    extends DefaultTableModel
    implements ISearchComponent {
        private static final String CN_ROLENAME = "Role Name";
        private static final String CN_PERMISSIONS = "Permissions";
        private static final String CN_RELATED_USERS = "Assigned to Users";
        public static final int CI_ROLENAME = 0;
        public static final int CI_PERMISSIONS = 1;
        public static final int CI_RELATED_USERS = 2;
        protected String[] columnNames;
        private String _searchedText = "";
        private List<RoleDetails> _roleDetailsList = new ArrayList<RoleDetails>();
        private final List<RoleDetails> _filteredRoleDetailsList = new ArrayList<RoleDetails>();

        public RoleDetailsTableModel() {
            this.initColumnNames();
        }

        public void setRoleAt(RoleDetails roleDetails, int row) {
            RoleDetails prevRoleDetails = this._filteredRoleDetailsList.get(row);
            this._filteredRoleDetailsList.set(row, roleDetails);
            int index = this._roleDetailsList.indexOf(prevRoleDetails);
            this._roleDetailsList.set(index, roleDetails);
            this.fireTableRowsUpdated(row, row);
        }

        public void addModifiedRole(RoleDetails role) {
            String roleName = role.getRole();
            int rowCount = this.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                RoleDetails existingRole = this._roleDetailsList.get(rowIndex);
                if (!existingRole.getRole().equals(roleName)) continue;
                this._roleDetailsList.set(rowIndex, role);
                this.filterList(true);
                break;
            }
            int filteredListSize = this._filteredRoleDetailsList.size();
            for (int rowIndex = 0; rowIndex < filteredListSize; ++rowIndex) {
                RoleDetails filteredRole = this._filteredRoleDetailsList.get(rowIndex);
                if (!filteredRole.getRole().equals(roleName)) continue;
                this._filteredRoleDetailsList.set(rowIndex, role);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
                break;
            }
        }

        public void addNewRole(RoleDetails roleDetails) {
            this._roleDetailsList.add(roleDetails);
            this.filterList(true);
        }

        public void removeRolesAt(int[] selectedRows) {
            for (int index = selectedRows.length - 1; index >= 0; --index) {
                int deletedRow = selectedRows[index];
                RoleDetails deletedRole = this._filteredRoleDetailsList.remove(deletedRow);
                if (deletedRole == null) continue;
                this._roleDetailsList.remove(deletedRole);
                RolesListPanel.this._roleManager.deleteRole(deletedRole.getRole());
                RolesListPanel.this._parentManageSecurityDialog.refreshUsers();
                this.fireTableRowsDeleted(deletedRow, deletedRow);
            }
            if (selectedRows.length > 0) {
                RolesListPanel.this._directoryManager.close();
            }
        }

        protected void initColumnNames() {
            this.columnNames = new String[3];
            this.columnNames[0] = CN_ROLENAME;
            this.columnNames[1] = CN_PERMISSIONS;
            this.columnNames[2] = CN_RELATED_USERS;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            RoleDetails roleDetails;
            if (row >= 0 && row < this._filteredRoleDetailsList.size() && (roleDetails = this._filteredRoleDetailsList.get(row)) != null) {
                return this.getCellValue(roleDetails, column);
            }
            return null;
        }

        public RoleDetails getRoleDetailsAt(int row) {
            if (row >= 0 && row < this._filteredRoleDetailsList.size()) {
                RoleDetails roleDetails = this._filteredRoleDetailsList.get(row);
                return roleDetails;
            }
            return null;
        }

        protected boolean isDisplayRole(RoleDetails roleDetails) {
            return roleDetails.getRole().toUpperCase().startsWith(this._searchedText.toUpperCase());
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._filteredRoleDetailsList == null ? 0 : this._filteredRoleDetailsList.size();
        }

        private Object getCellValue(RoleDetails roleDetails, int column) {
            switch (column) {
                case 0: {
                    return roleDetails.getRole();
                }
                case 1: {
                    Authority[] authoritiesArray = roleDetails.getAuthorities();
                    return this.getAuthoritiesRepresentation(authoritiesArray);
                }
                case 2: {
                    List usersList = DirectoryManagerUtils.getUsersWithRole((UserManager)RolesListPanel.this._userManager, (String)roleDetails.getRole());
                    return this.getUsersRepresentation(usersList);
                }
            }
            return "";
        }

        private Object getUsersRepresentation(List<UserDetails> usersList) {
            StringBuilder sb = new StringBuilder();
            for (UserDetails userDetails : usersList) {
                sb.append(userDetails.getUsername()).append(", ");
            }
            int lastIndexOf = sb.lastIndexOf(", ");
            if (lastIndexOf != -1) {
                sb.delete(lastIndexOf, sb.length());
            }
            return sb.toString();
        }

        public void setRoles(List<RoleDetails> roleDetailsList) {
            this.clear();
            this._roleDetailsList = new ArrayList<RoleDetails>(roleDetailsList);
            this.filterList(true);
        }

        private Object getAuthoritiesRepresentation(Authority[] authoritiesArray) {
            String result = "";
            for (Authority authority : authoritiesArray) {
                if (result.length() != 0) {
                    result = result + ", ";
                }
                result = result + ((InternalAuthority)authority).getPrivilege();
            }
            return result;
        }

        public void clear() {
            this._searchedText = "";
            int curRowCount = this._filteredRoleDetailsList.size();
            this._roleDetailsList.clear();
            if (curRowCount > 0) {
                this._filteredRoleDetailsList.clear();
                this.fireTableRowsDeleted(0, curRowCount - 1);
            }
        }

        @Override
        public void search(String searchedText) {
            this._searchedText = searchedText;
            this.filterList(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void filterList(boolean isTableModelUpdated) {
            int selRow = RolesListPanel.this._roleDetailsTable.getSelectedRow();
            RoleDetails selRoleDetails = null;
            if (selRow >= 0) {
                selRoleDetails = this.getRoleDetailsAt(selRow);
            }
            if (this._searchedText.length() == 0) {
                for (RoleDetails roleDetails : this._roleDetailsList) {
                    int index;
                    if (!this._filteredRoleDetailsList.contains(roleDetails)) {
                        this._filteredRoleDetailsList.add(roleDetails);
                        index = this._filteredRoleDetailsList.indexOf(roleDetails);
                        this.fireTableRowsInserted(index, index);
                        continue;
                    }
                    if (!isTableModelUpdated) continue;
                    index = this._filteredRoleDetailsList.indexOf(roleDetails);
                    this._filteredRoleDetailsList.set(index, roleDetails);
                    this.fireTableRowsUpdated(index, index);
                }
                int filteredListSize = this._filteredRoleDetailsList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    if (this._roleDetailsList.contains(this._filteredRoleDetailsList.get(index))) continue;
                    this._filteredRoleDetailsList.remove(index);
                    this.fireTableRowsDeleted(index, index);
                }
            } else {
                int filteredListSize = this._filteredRoleDetailsList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    RoleDetails roleDetails = this._filteredRoleDetailsList.get(index);
                    if (this.isDisplayRole(roleDetails) && this._roleDetailsList.contains(roleDetails)) continue;
                    this._filteredRoleDetailsList.remove(roleDetails);
                    this.fireTableRowsDeleted(index, index);
                }
                List<RoleDetails> list = this._roleDetailsList;
                synchronized (list) {
                    for (RoleDetails roleDetails : this._roleDetailsList) {
                        int index;
                        if (!this.isDisplayRole(roleDetails)) continue;
                        if (!this._filteredRoleDetailsList.contains(roleDetails)) {
                            this._filteredRoleDetailsList.add(roleDetails);
                            index = this._filteredRoleDetailsList.indexOf(roleDetails);
                            this.fireTableRowsInserted(index, index);
                            continue;
                        }
                        if (!isTableModelUpdated) continue;
                        index = this._filteredRoleDetailsList.indexOf(roleDetails);
                        this._filteredRoleDetailsList.set(index, roleDetails);
                        this.fireTableRowsUpdated(index, index);
                    }
                }
            }
            if (selRoleDetails != null) {
                this.selectWrapper(selRoleDetails);
            }
        }

        private void selectWrapper(RoleDetails selRoleDetails) {
            int selIndex;
            if (selRoleDetails != null && (selIndex = this._filteredRoleDetailsList.indexOf(selRoleDetails)) >= 0) {
                RolesListPanel.this._roleDetailsTable.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RolesListPanel.this._roleDetailsTable.scrollRectToVisible(RolesListPanel.this._roleDetailsTable.getCellRect(selIndex, -1, true));
                    }
                });
            }
        }
    }
}

