/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.security.ISecurityConstants;
import com.gigaspaces.admin.ui.security.utils.INameChangeListener;
import com.gigaspaces.admin.ui.security.utils.IRoleSelectionListener;
import com.gigaspaces.admin.ui.security.utils.UserRolesPanel;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.UserDetails;
import com.j_spaces.kernel.JSpaceUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UserDetailsBox
extends Box
implements ISecurityConstants {
    private JTextField _userNameTextField;
    private JPasswordField _passwordTextField;
    private JPasswordField _confirmPasswordTextField;
    private UserRolesPanel _rolesPanel;
    private RoleManager _roleManager;
    private JFrame _parentFrame;
    private static final int LEFT_ALLIGN = 2;
    private static final Dimension labelSize = new Dimension(135, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension textFieldSize = new Dimension(300, 23);
    private static final Dimension maxTextFieldSize = new Dimension(550, 23);
    private static final Dimension minTextFieldSize = new Dimension(20, 23);
    private List<INameChangeListener> _nameListenersList = new ArrayList<INameChangeListener>();

    public UserDetailsBox(JFrame parentFrame, RoleManager roleManager) {
        super(0);
        this._roleManager = roleManager;
        this._parentFrame = parentFrame;
        this.init();
    }

    private void init() {
        this._rolesPanel = new UserRolesPanel(this._roleManager);
        Box userDetailsBox = this.initUserDetailsBox();
        this.add(userDetailsBox);
        this.add(Box.createHorizontalStrut(10));
        this.add(this._rolesPanel);
    }

    public void addNameChangeListener(INameChangeListener nameChangeListener) {
        this._nameListenersList.add(nameChangeListener);
    }

    private void fireUserDetailsChanged() {
        for (INameChangeListener nameChangeListener : this._nameListenersList) {
            boolean isNameValid = this.isDataValid(false, false);
            nameChangeListener.nameChanged(isNameValid);
        }
    }

    public void addRoleSelectionListener(IRoleSelectionListener roleSelectionListener) {
        this._rolesPanel.addRoleSelectionListener(roleSelectionListener);
    }

    public void setMode(short mode) {
        if (mode == 1 || mode == 2) {
            this._userNameTextField.setBackground(Color.WHITE);
            this._userNameTextField.setEditable(true);
        } else if (mode == 3) {
            this._userNameTextField.setBackground(SystemColor.control);
            this._userNameTextField.setEditable(false);
        }
    }

    public void editUser(UserDetails user) {
        this.setMode((short)3);
        this._userNameTextField.setText(user.getUsername());
        this._passwordTextField.setText(user.getPassword());
        this._confirmPasswordTextField.setText(user.getPassword());
        this._rolesPanel.initRoles(user);
    }

    public void duplicateUser(UserDetails user) {
        this.setMode((short)1);
        this._userNameTextField.setText("Copy_" + user.getUsername());
        this._passwordTextField.setText(user.getPassword());
        this._confirmPasswordTextField.setText(user.getPassword());
        this._userNameTextField.grabFocus();
        this._rolesPanel.initRoles(user);
    }

    public void newUser() {
        this._rolesPanel.updateRoles();
        this._userNameTextField.grabFocus();
    }

    public void clear() {
        this._userNameTextField.setText("");
        this._passwordTextField.setText("");
        this._confirmPasswordTextField.setText("");
        this._rolesPanel.clear();
    }

    private boolean isNameValid(String str) {
        return str.indexOf(32) == -1;
    }

    public boolean isDataValid(boolean isShowMessage, boolean checkPasswordConfirmation) {
        String username = this._userNameTextField.getText();
        String password = String.valueOf(this._passwordTextField.getPassword());
        String confirmPassword = String.valueOf(this._confirmPasswordTextField.getPassword());
        if (JSpaceUtilities.isEmpty((String)username, (boolean)true)) {
            if (isShowMessage) {
                JOptionPane.showMessageDialog(this._parentFrame, "Please provide a username.", "Create User", 1);
            }
            return false;
        }
        if (checkPasswordConfirmation && !password.equals(confirmPassword)) {
            if (isShowMessage) {
                JOptionPane.showMessageDialog(this._parentFrame, "The password confirmation does not match the password.", "Create User", 1);
            }
            return false;
        }
        if (JSpaceUtilities.isEmpty((String)password, (boolean)false)) {
            if (isShowMessage) {
                JOptionPane.showMessageDialog(this._parentFrame, "Please provide a password.", "Create User", 1);
            }
            return false;
        }
        return true;
    }

    public String getUserName() {
        return this._userNameTextField.getText();
    }

    public String getPassword() {
        return String.valueOf(this._passwordTextField.getPassword());
    }

    public List<RoleAuthority> getSelectedRoleAuthorities() {
        return this._rolesPanel.getSelectedRoleAuthorities();
    }

    private Box initUserDetailsBox() {
        Box userDetailsBox = new Box(1);
        JLabel userNameLabel = this.createLabel("User Name:");
        this._userNameTextField = this.createTextField();
        this._userNameTextField.setText(" ");
        Box userNameBox = new Box(0);
        userNameBox.add(Box.createHorizontalStrut(2));
        userNameBox.add(userNameLabel);
        userNameBox.add(this._userNameTextField);
        userNameBox.add(Box.createHorizontalGlue());
        this.addDocumentListener(this._userNameTextField);
        JLabel passwordLabel = this.createLabel("Password:");
        this._passwordTextField = this.createPasswordTextField();
        this.addDocumentListener(this._passwordTextField);
        Box passwordBox = new Box(0);
        passwordBox.add(Box.createHorizontalStrut(2));
        passwordBox.add(passwordLabel);
        passwordBox.add(this._passwordTextField);
        passwordBox.add(Box.createHorizontalGlue());
        JLabel confirmPasswordLabel = this.createLabel("Confirm Password:");
        this._confirmPasswordTextField = this.createPasswordTextField();
        this.addDocumentListener(this._confirmPasswordTextField);
        Box confirmPasswordBox = new Box(0);
        confirmPasswordBox.add(Box.createHorizontalStrut(2));
        confirmPasswordBox.add(confirmPasswordLabel);
        confirmPasswordBox.add(this._confirmPasswordTextField);
        confirmPasswordBox.add(Box.createHorizontalGlue());
        userDetailsBox.add(Box.createVerticalStrut(5));
        userDetailsBox.add(userNameBox);
        userDetailsBox.add(Box.createVerticalStrut(5));
        userDetailsBox.add(passwordBox);
        userDetailsBox.add(Box.createVerticalStrut(5));
        userDetailsBox.add(confirmPasswordBox);
        userDetailsBox.add(Box.createVerticalStrut(5));
        return userDetailsBox;
    }

    private void addDocumentListener(JTextField textField) {
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserDetailsBox.this.fireUserDetailsChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserDetailsBox.this.fireUserDetailsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserDetailsBox.this.fireUserDetailsChanged();
            }
        });
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        return textField;
    }

    private JPasswordField createPasswordTextField() {
        JPasswordField passwordField = new JPasswordField();
        passwordField.setPreferredSize(textFieldSize);
        passwordField.setMaximumSize(maxTextFieldSize);
        passwordField.setMinimumSize(minTextFieldSize);
        return passwordField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }
}

