/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.security.ISecurityConstants;
import com.gigaspaces.admin.ui.security.ManageSecurityFrame;
import com.gigaspaces.admin.ui.security.UserDetailsBox;
import com.gigaspaces.admin.ui.security.utils.INameChangeListener;
import com.gigaspaces.admin.ui.security.utils.IRoleSelectionListener;
import com.gigaspaces.admin.ui.security.utils.PermissionsBox;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.RoleDetails;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserAlreadyExistsException;
import com.gigaspaces.security.directory.UserDataAccessException;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class UserPermissionsPanel
extends JPanel
implements ActionListener,
ISecurityConstants,
IRoleSelectionListener,
INameChangeListener {
    private JButton _createButton;
    private JButton _cancelButton;
    private UserDetailsBox _userDetailBox;
    private PermissionsBox _permissionsBox;
    private PermissionsBox _aggregatedPermissionsBox;
    private DirectoryManager _directoryManager;
    private UserManager _userManager;
    private RoleManager _roleManager;
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private JTabbedPane _tabbedPane;
    private short _mode;
    private UserDetails _newUser;
    private ManageSecurityFrame _parentManageSecurityFrame;
    private final String AGGREGATED_TAB_TITLE = "Aggregated";

    public UserPermissionsPanel(ManageSecurityFrame parentFrame, DirectoryManager directoryManager, UserManager userManager, RoleManager roleManger) {
        this._parentManageSecurityFrame = parentFrame;
        this._directoryManager = directoryManager;
        this._userManager = userManager;
        this._roleManager = roleManger;
        this.init();
    }

    private void init() {
        Box buttonsBox = this.initButtonsBox();
        this._permissionsBox = new PermissionsBox(this._parentManageSecurityFrame, false);
        this._aggregatedPermissionsBox = new PermissionsBox(this._parentManageSecurityFrame, true);
        this.setLayout(new BorderLayout());
        this._userDetailBox = new UserDetailsBox(this._parentManageSecurityFrame, this._roleManager);
        this._userDetailBox.addRoleSelectionListener(this);
        this._userDetailBox.addNameChangeListener(this);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addTab("User Specific", this._permissionsBox);
        this.add((Component)this._userDetailBox, "North");
        this.add((Component)this._tabbedPane, "Center");
        this.add((Component)buttonsBox, "South");
        this.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 2));
    }

    private Box initButtonsBox() {
        this._createButton = new JButton("Create");
        this._cancelButton = new JButton("Cancel");
        this._createButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        Dimension buttonSize = new Dimension(80, 23);
        this._createButton.setPreferredSize(buttonSize);
        this._cancelButton.setPreferredSize(buttonSize);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this._createButton);
        buttonsBox.add(Box.createHorizontalStrut(15));
        buttonsBox.add(this._cancelButton);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        return buttonsBox;
    }

    private void setMode(short mode) {
        this._mode = mode;
        this._userDetailBox.setMode(mode);
        if (mode == 1 || mode == 2) {
            this._createButton.setText("Create");
        } else if (mode == 3) {
            this._createButton.setText("Update");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._createButton)) {
            if (this.createUser() != null) {
                this._parentManageSecurityFrame.showUsersAndRolesListsView();
            }
        } else if (source.equals(this._cancelButton)) {
            this._parentManageSecurityFrame.showUsersAndRolesListsView();
        }
    }

    @Override
    public void nameChanged(boolean isValidName) {
        this._createButton.setEnabled(isValidName);
    }

    private UserDetails createUser() {
        int index;
        if (!this._userDetailBox.isDataValid(true, true) || !this._permissionsBox.isDataValid()) {
            return null;
        }
        String userName = this._userDetailBox.getUserName();
        String password = this._userDetailBox.getPassword();
        List<RoleAuthority> selectedRoleAuthoritiesList = this._userDetailBox.getSelectedRoleAuthorities();
        List<Authority> authoritiesList = this._permissionsBox.getAuthorities();
        Authority[] authoritiesArray = new Authority[authoritiesList.size() + selectedRoleAuthoritiesList.size()];
        int listSize = authoritiesList.size();
        for (index = 0; index < listSize; ++index) {
            authoritiesArray[index] = authoritiesList.get(index);
        }
        for (RoleAuthority roleAuthority : selectedRoleAuthoritiesList) {
            authoritiesArray[index] = roleAuthority;
            ++index;
        }
        User user = new User(userName, password, authoritiesArray);
        try {
            if (this._mode == 1 || this._mode == 2) {
                this._userManager.createUser((UserDetails)user);
                this._directoryManager.close();
                this._parentManageSecurityFrame.addCreatedUser((UserDetails)user);
            } else if (this._mode == 3) {
                this._userManager.updateUser((UserDetails)user);
                this._directoryManager.close();
                this._parentManageSecurityFrame.addModifiedUser((UserDetails)user);
            }
        }
        catch (UserAlreadyExistsException exc) {
            JOptionPane.showMessageDialog(this, "Username [" + userName + "] is already in use. Please use a different username.", "Create User", 1);
            user = null;
        }
        catch (UserDataAccessException exc) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
            user = null;
        }
        catch (Exception exc) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
            user = null;
        }
        this._newUser = user;
        return this._newUser;
    }

    public UserDetails getNewUser() {
        return this._newUser;
    }

    public void newUser() {
        this.clear();
        this.setMode((short)1);
        this._userDetailBox.newUser();
    }

    public void editUser(UserDetails user) {
        this.clear();
        this.setMode((short)3);
        this._userDetailBox.editUser(user);
        this._permissionsBox.editAuthorities(user.getAuthorities());
        this._aggregatedPermissionsBox.addAggregatedAuthorities(user.getAuthorities());
    }

    public void duplicateUser(UserDetails user) {
        this.clear();
        this.setMode((short)1);
        this._userDetailBox.duplicateUser(user);
        this._permissionsBox.editAuthorities(user.getAuthorities());
        this._aggregatedPermissionsBox.addAggregatedAuthorities(user.getAuthorities());
    }

    private void clear() {
        this._newUser = null;
        this._userDetailBox.clear();
        this._permissionsBox.clear();
        this._aggregatedPermissionsBox.clear();
        int tabCount = this._tabbedPane.getTabCount();
        for (int i = tabCount - 1; i > 0; --i) {
            this._tabbedPane.removeTabAt(i);
        }
    }

    @Override
    public void roleSelectionChanged(RoleDetails role, boolean selected) {
        String roleName = role.getRole();
        if (selected) {
            PermissionsBox permissionBox = new PermissionsBox(this._parentManageSecurityFrame, true);
            permissionBox.editAuthorities(role.getAuthorities());
            this._aggregatedPermissionsBox.addAggregatedAuthorities(role.getAuthorities());
            if (this._tabbedPane.getTabCount() == 1) {
                this._tabbedPane.addTab("Aggregated", this._aggregatedPermissionsBox);
            }
            this._tabbedPane.addTab(roleName, permissionBox);
        } else {
            int tabsCount = this._tabbedPane.getTabCount();
            for (int index = 0; index < tabsCount; ++index) {
                if (!this._tabbedPane.getTitleAt(index).equals(roleName)) continue;
                this._tabbedPane.removeTabAt(index);
                this._aggregatedPermissionsBox.removeAggregatedAuthorities(role.getAuthorities());
                if (this._tabbedPane.getTabCount() != 2) break;
                this._tabbedPane.removeTabAt(1);
                break;
            }
        }
    }
}

