/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security;

import com.gigaspaces.admin.ui.grid.space.ISearchComponent;
import com.gigaspaces.admin.ui.grid.space.SearchEditor;
import com.gigaspaces.admin.ui.security.ManageSecurityFrame;
import com.gigaspaces.admin.ui.util.TableWithTooltip;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.DirectoryManagerUtils;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class UsersListPanel
extends JPanel
implements ActionListener {
    private JButton _createNewUserButton;
    private JButton _editUserButton;
    private JButton _duplicateUserButton;
    private JButton _deleteUserButton;
    private JButton _closeButton;
    private JMenuItem _editUserMenuItem;
    private JMenuItem _duplicateUserMenuItem;
    private JMenuItem _deleteUserMenuItem;
    private JPopupMenu _popupMenu;
    private JTable _userDetailsTable;
    private UserDetailsTableModel _usersDetailsTableModel;
    private final ManageSecurityFrame _parentManageSecurityDialog;
    private final DirectoryManager _directoryManager;
    private final UserManager _userManager;
    private SearchEditor _searchEditor;
    private static final int LEFT_ALLIGN = 3;
    private boolean _isReadOnlyMode;

    public UsersListPanel(ManageSecurityFrame parentDialog, DirectoryManager directoryManager, UserManager userManager) {
        this._parentManageSecurityDialog = parentDialog;
        this._directoryManager = directoryManager;
        this._userManager = userManager;
        if (userManager != null) {
            this._isReadOnlyMode = userManager.isReadOnly();
        }
        this.init();
        this.fillUsers();
        this.setBorder(BorderFactory.createTitledBorder(""));
        if (this._isReadOnlyMode) {
            this._createNewUserButton.setEnabled(false);
            this._editUserButton.setEnabled(false);
            this._duplicateUserButton.setEnabled(false);
            this._deleteUserButton.setEnabled(false);
            this._editUserMenuItem.setEnabled(false);
            this._duplicateUserMenuItem.setEnabled(false);
            this._deleteUserMenuItem.setEnabled(false);
        }
    }

    private void init() {
        this.createPopupMenu();
        this._createNewUserButton = new JButton("Create New User...");
        Box createNewUserBox = new Box(0);
        createNewUserBox.add(Box.createHorizontalStrut(3));
        createNewUserBox.add(this._createNewUserButton);
        createNewUserBox.add(Box.createHorizontalGlue());
        createNewUserBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this._createNewUserButton.addActionListener(this);
        this._usersDetailsTableModel = new UserDetailsTableModel();
        this._userDetailsTable = new TableWithTooltip(this._usersDetailsTableModel);
        this.setTableProperties(this._userDetailsTable);
        JScrollPane scrollPane = new JScrollPane(this._userDetailsTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this._searchEditor = new SearchEditor(this._usersDetailsTableModel);
        Box searchBox = new Box(0);
        searchBox.add(Box.createHorizontalGlue());
        searchBox.add(this._searchEditor);
        searchBox.add(Box.createHorizontalStrut(3));
        searchBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)searchBox, "North");
        scrollPanel.add((Component)scrollPane, "Center");
        this._userDetailsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int selRow = UsersListPanel.this._userDetailsTable.rowAtPoint(mouseEvent.getPoint());
                    if (selRow >= 0) {
                        UsersListPanel.this._userDetailsTable.setRowSelectionInterval(selRow, selRow);
                    }
                    UsersListPanel.this._popupMenu.show(UsersListPanel.this._userDetailsTable, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() > 1 && !UsersListPanel.this._isReadOnlyMode) {
                    UsersListPanel.this.editUser();
                }
            }
        });
        this._userDetailsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                UsersListPanel.this.setUserManagementButtonsEnabled(UsersListPanel.this._userDetailsTable.getSelectedRows().length > 0);
            }
        });
        this._editUserButton = new JButton("Edit...");
        this._duplicateUserButton = new JButton("Duplicate...");
        this._deleteUserButton = new JButton("Delete");
        this._closeButton = new JButton("Close");
        Box bottomButtonsBox = new Box(0);
        bottomButtonsBox.add(Box.createHorizontalStrut(3));
        bottomButtonsBox.add(this._editUserButton);
        bottomButtonsBox.add(Box.createHorizontalStrut(5));
        bottomButtonsBox.add(this._duplicateUserButton);
        bottomButtonsBox.add(Box.createHorizontalStrut(5));
        bottomButtonsBox.add(this._deleteUserButton);
        bottomButtonsBox.add(Box.createHorizontalGlue());
        bottomButtonsBox.add(this._closeButton);
        bottomButtonsBox.add(Box.createHorizontalStrut(3));
        bottomButtonsBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this._editUserButton.addActionListener(this);
        this._duplicateUserButton.addActionListener(this);
        this._deleteUserButton.addActionListener(this);
        this._closeButton.addActionListener(this);
        Dimension buttonSize = new Dimension(85, 23);
        this._editUserButton.setPreferredSize(buttonSize);
        this._duplicateUserButton.setPreferredSize(buttonSize);
        this._deleteUserButton.setPreferredSize(buttonSize);
        this._closeButton.setPreferredSize(buttonSize);
        this._createNewUserButton.setPreferredSize(new Dimension(135, 23));
        this.setLayout(new BorderLayout());
        this.add((Component)createNewUserBox, "North");
        this.add((Component)scrollPanel, "Center");
        this.add((Component)bottomButtonsBox, "South");
        this.setUserManagementButtonsEnabled(false);
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn userNameTableColumn = tableColumnModel.getColumn(0);
        TableColumn permissionsTableColumn = tableColumnModel.getColumn(2);
        TableColumn rolesTableColumn = tableColumnModel.getColumn(1);
        userNameTableColumn.setPreferredWidth(50);
        permissionsTableColumn.setPreferredWidth(180);
        rolesTableColumn.setPreferredWidth(140);
    }

    private void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        this._editUserMenuItem = new JMenuItem("Edit...");
        this._duplicateUserMenuItem = new JMenuItem("Duplicate...");
        this._deleteUserMenuItem = new JMenuItem("Delete");
        this._popupMenu.add(this._editUserMenuItem);
        this._popupMenu.add(this._duplicateUserMenuItem);
        this._popupMenu.add(this._deleteUserMenuItem);
        this._editUserMenuItem.addActionListener(this);
        this._duplicateUserMenuItem.addActionListener(this);
        this._deleteUserMenuItem.addActionListener(this);
    }

    private void fillUsers() {
        if (this._userManager != null) {
            Map userDetailsMap = this._userManager.mapUsers();
            ArrayList<UserDetails> userDetailsList = new ArrayList<UserDetails>(userDetailsMap.values());
            this._usersDetailsTableModel.setUsers(userDetailsList);
        }
    }

    public void clear() {
        this._searchEditor.clear();
        this._usersDetailsTableModel.clear();
        this.setUserManagementButtonsEnabled(false);
    }

    private void setUserManagementButtonsEnabled(boolean enabled) {
        if (!this._isReadOnlyMode) {
            this._editUserButton.setEnabled(enabled);
            this._duplicateUserButton.setEnabled(enabled);
            this._deleteUserButton.setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._createNewUserButton)) {
            this.createNewUser();
        } else if (source.equals(this._closeButton)) {
            this._parentManageSecurityDialog.closeWindow();
        } else if (source.equals(this._editUserButton) || source.equals(this._editUserMenuItem)) {
            this.editUser();
        } else if (source.equals(this._duplicateUserButton) || source.equals(this._duplicateUserMenuItem)) {
            this.duplicateUser();
        } else if (source.equals(this._deleteUserButton) || source.equals(this._deleteUserMenuItem)) {
            this.deleteUsers();
        }
    }

    private void duplicateUser() {
        int[] selectedRows = this._userDetailsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to duplicate user - no user selected. Please select one user in table.", "Duplicate User", 1);
            return;
        }
        if (selectedRows.length > 1) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to duplicate user - more than one user selected. Please select only one user in table.", "Duplicate User", 1);
            return;
        }
        UserDetails userDetails = this._usersDetailsTableModel.getUserDetailsAt(selectedRows[0]);
        if (userDetails != null) {
            this._parentManageSecurityDialog.duplicateUser(userDetails);
        }
    }

    private void deleteUsers() {
        int returnValue;
        int[] selectedRows = this._userDetailsTable.getSelectedRows();
        if (selectedRows.length > 0 && (returnValue = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete selected user(s)?", "Delete Users", 0, 1)) == 0) {
            this._usersDetailsTableModel.removeUsersAt(selectedRows);
            if (selectedRows[0] < this._usersDetailsTableModel.getRowCount()) {
                this._userDetailsTable.setRowSelectionInterval(selectedRows[0], selectedRows[0]);
            } else if (this._usersDetailsTableModel.getRowCount() > 0) {
                this._userDetailsTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void editUser() {
        int[] selectedRows = this._userDetailsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to edit user - no user selected. Please select one user in table.", "Edit User", 1);
            return;
        }
        if (selectedRows.length > 1) {
            JOptionPane.showMessageDialog(this._parentManageSecurityDialog, "Unable to edit user - more than one user selected. Please select only one user in table.", "Edit User", 1);
            return;
        }
        UserDetails userDetails = this._usersDetailsTableModel.getUserDetailsAt(selectedRows[0]);
        if (userDetails != null) {
            this._parentManageSecurityDialog.editUser(userDetails);
        }
    }

    private void createNewUser() {
        this._parentManageSecurityDialog.newUser();
    }

    public void addCreatedUser(UserDetails user) {
        this._usersDetailsTableModel.addNewUser(user);
    }

    public void addModifiedUser(UserDetails user) {
        this._usersDetailsTableModel.addModifiedUser(user);
    }

    public void refreshUsers() {
        this._usersDetailsTableModel.refreshUsers();
    }

    private class UserDetailsTableModel
    extends DefaultTableModel
    implements ISearchComponent {
        private final String CN_USERNAME = "User Name";
        private final String CN_ROLES = "Roles";
        private final String CN_PERMISSIONS = "Permissions";
        public static final int CI_USERNAME = 0;
        public static final int CI_ROLES = 1;
        public static final int CI_PERMISSIONS = 2;
        protected String[] columnNames;
        private String _searchedText = "";
        private List<UserDetails> _userDetailsList = new ArrayList<UserDetails>();
        private final List<UserDetails> _filteredUserDetailsList = new ArrayList<UserDetails>();

        public UserDetailsTableModel() {
            this.initColumnNames();
        }

        public void setUserAt(UserDetails userDetails, int row) {
            UserDetails prevUserDetails = this._filteredUserDetailsList.get(row);
            this._filteredUserDetailsList.set(row, userDetails);
            int index = this._userDetailsList.indexOf(prevUserDetails);
            this._userDetailsList.set(index, userDetails);
            this.fireTableRowsUpdated(row, row);
        }

        public void addNewUser(UserDetails userDetails) {
            this._userDetailsList.add(userDetails);
            this.filterList(true);
        }

        public void removeUsersAt(int[] selectedRows) {
            for (int index = selectedRows.length - 1; index >= 0; --index) {
                int deletedRow = selectedRows[index];
                UserDetails deletedUser = this._filteredUserDetailsList.remove(deletedRow);
                if (deletedUser == null) continue;
                this._userDetailsList.remove(deletedUser);
                UsersListPanel.this._userManager.deleteUser(deletedUser.getUsername());
                this.fireTableRowsDeleted(deletedRow, deletedRow);
            }
            if (selectedRows.length > 0) {
                UsersListPanel.this._directoryManager.close();
            }
        }

        protected void initColumnNames() {
            this.columnNames = new String[3];
            this.columnNames[0] = "User Name";
            this.columnNames[1] = "Roles";
            this.columnNames[2] = "Permissions";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            UserDetails userDetails;
            if (row >= 0 && row < this._filteredUserDetailsList.size() && (userDetails = this._filteredUserDetailsList.get(row)) != null) {
                return this.getCellValue(userDetails, column);
            }
            return null;
        }

        public UserDetails getUserDetailsAt(int row) {
            if (row >= 0 && row < this._filteredUserDetailsList.size()) {
                UserDetails userDetails = this._filteredUserDetailsList.get(row);
                return userDetails;
            }
            return null;
        }

        protected boolean isDisplayUser(UserDetails userDetails) {
            return userDetails.getUsername().toUpperCase().startsWith(this._searchedText.toUpperCase());
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._filteredUserDetailsList == null ? 0 : this._filteredUserDetailsList.size();
        }

        private Object getCellValue(UserDetails userDetails, int column) {
            switch (column) {
                case 0: {
                    return userDetails.getUsername();
                }
                case 1: {
                    return this.getRolesRepresentation(userDetails);
                }
                case 2: {
                    Authority[] authoritiesArray = userDetails.getAuthorities();
                    return this.getAuthoritiesRepresentation(authoritiesArray);
                }
            }
            return "";
        }

        private Object getRolesRepresentation(UserDetails userDetails) {
            List userRoles = DirectoryManagerUtils.getUserRoles((UserDetails)userDetails);
            StringBuilder sb = new StringBuilder();
            for (String role : userRoles) {
                sb.append(role).append(", ");
            }
            int lastIndexOf = sb.lastIndexOf(", ");
            if (lastIndexOf != -1) {
                sb.delete(lastIndexOf, sb.length());
            }
            return sb.toString();
        }

        public void setUsers(List<UserDetails> userDetailsList) {
            this.clear();
            this._userDetailsList = new ArrayList<UserDetails>(userDetailsList);
            this.filterList(true);
        }

        private Object getAuthoritiesRepresentation(Authority[] authoritiesArray) {
            String result = "";
            for (Authority authority : authoritiesArray) {
                if (authority instanceof RoleAuthority) continue;
                if (result.length() != 0) {
                    result = result + ", ";
                }
                result = result + ((InternalAuthority)authority).getPrivilege();
            }
            return result;
        }

        public void clear() {
            this._searchedText = "";
            int curRowCount = this._filteredUserDetailsList.size();
            this._userDetailsList.clear();
            if (curRowCount > 0) {
                this._filteredUserDetailsList.clear();
                this.fireTableRowsDeleted(0, curRowCount - 1);
            }
        }

        @Override
        public void search(String searchedText) {
            this._searchedText = searchedText;
            this.filterList(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void filterList(boolean isTableModelUpdated) {
            int selRow = UsersListPanel.this._userDetailsTable.getSelectedRow();
            UserDetails selUserDetails = null;
            if (selRow >= 0) {
                selUserDetails = this.getUserDetailsAt(selRow);
            }
            if (this._searchedText.length() == 0) {
                for (UserDetails userDetails : this._userDetailsList) {
                    int index;
                    if (!this._filteredUserDetailsList.contains(userDetails)) {
                        this._filteredUserDetailsList.add(userDetails);
                        index = this._filteredUserDetailsList.indexOf(userDetails);
                        this.fireTableRowsInserted(index, index);
                        continue;
                    }
                    if (!isTableModelUpdated) continue;
                    index = this._filteredUserDetailsList.indexOf(userDetails);
                    this._filteredUserDetailsList.set(index, userDetails);
                    this.fireTableRowsUpdated(index, index);
                }
                int filteredListSize = this._filteredUserDetailsList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    if (this._userDetailsList.contains(this._filteredUserDetailsList.get(index))) continue;
                    this._filteredUserDetailsList.remove(index);
                    this.fireTableRowsDeleted(index, index);
                }
            } else {
                int filteredListSize = this._filteredUserDetailsList.size();
                for (int index = filteredListSize - 1; index >= 0; --index) {
                    UserDetails userDetails = this._filteredUserDetailsList.get(index);
                    if (this.isDisplayUser(userDetails) && this._userDetailsList.contains(userDetails)) continue;
                    this._filteredUserDetailsList.remove(userDetails);
                    this.fireTableRowsDeleted(index, index);
                }
                List<UserDetails> list = this._userDetailsList;
                synchronized (list) {
                    for (UserDetails userDetails : this._userDetailsList) {
                        int index;
                        if (!this.isDisplayUser(userDetails)) continue;
                        if (!this._filteredUserDetailsList.contains(userDetails)) {
                            this._filteredUserDetailsList.add(userDetails);
                            index = this._filteredUserDetailsList.indexOf(userDetails);
                            this.fireTableRowsInserted(index, index);
                            continue;
                        }
                        if (!isTableModelUpdated) continue;
                        index = this._filteredUserDetailsList.indexOf(userDetails);
                        this._filteredUserDetailsList.set(index, userDetails);
                        this.fireTableRowsUpdated(index, index);
                    }
                }
            }
            if (selUserDetails != null) {
                this.selectWrapper(selUserDetails);
            }
        }

        private void selectWrapper(UserDetails selUserDetails) {
            int selIndex;
            if (selUserDetails != null && (selIndex = this._filteredUserDetailsList.indexOf(selUserDetails)) >= 0) {
                UsersListPanel.this._userDetailsTable.setRowSelectionInterval(selIndex, selIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UsersListPanel.this._userDetailsTable.scrollRectToVisible(UsersListPanel.this._userDetailsTable.getCellRect(selIndex, -1, true));
                    }
                });
            }
        }

        public void addModifiedUser(UserDetails user) {
            String userName = user.getUsername();
            int rowCount = this.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                UserDetails existingUser = this._userDetailsList.get(rowIndex);
                if (!existingUser.getUsername().equals(userName)) continue;
                this._userDetailsList.set(rowIndex, user);
                break;
            }
            int filteredListSize = this._filteredUserDetailsList.size();
            for (int rowIndex = 0; rowIndex < filteredListSize; ++rowIndex) {
                UserDetails filteredUser = this._filteredUserDetailsList.get(rowIndex);
                if (!filteredUser.getUsername().equals(userName)) continue;
                this._filteredUserDetailsList.set(rowIndex, user);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
                break;
            }
        }

        public void refreshUsers() {
            Map usersMap = UsersListPanel.this._userManager.mapUsers();
            int listSize = this._userDetailsList.size();
            for (int index = 0; index < listSize; ++index) {
                UserDetails user = this._userDetailsList.get(index);
                String userName = user.getUsername();
                UserDetails updatedUser = (UserDetails)usersMap.get(userName);
                if (updatedUser == null) continue;
                this._userDetailsList.set(index, updatedUser);
            }
            int filteredListSize = this._filteredUserDetailsList.size();
            for (int index = 0; index < filteredListSize; ++index) {
                UserDetails user = this._filteredUserDetailsList.get(index);
                String userName = user.getUsername();
                UserDetails updatedUser = (UserDetails)usersMap.get(userName);
                if (updatedUser == null) continue;
                this._filteredUserDetailsList.set(index, updatedUser);
            }
            this.fireTableDataChanged();
        }
    }
}

