/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.monitor;

import com.gigaspaces.admin.ui.security.monitor.LoginMonitorTableModel;
import com.gigaspaces.admin.ui.security.monitor.LoginMonitorWrapper;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LoginMonitorDialog
extends EscapeDialog {
    private static LoginMonitorDialog _securityMonitorDialogInstance;
    private LoginMonitorTableModel _authenticationTableModel;

    public static LoginMonitorDialog getInstance(JFrame parentFrame) {
        if (_securityMonitorDialogInstance == null) {
            _securityMonitorDialogInstance = new LoginMonitorDialog(parentFrame);
        }
        return _securityMonitorDialogInstance;
    }

    private LoginMonitorDialog(JFrame parenFrame) {
        super(parenFrame, "Authentication Monitor", false);
        this.init();
        this.setSize(920, 320);
        this.setLocationRelativeTo(parenFrame);
    }

    private void init() {
        JButton closeButton = new JButton("Close");
        this.getContentPane().setLayout(new BorderLayout());
        Dimension buttonSize = new Dimension(60, 23);
        closeButton.setPreferredSize(buttonSize);
        closeButton.setMaximumSize(buttonSize);
        closeButton.setMinimumSize(buttonSize);
        Box closeButtonBox = new Box(0);
        closeButtonBox.add(Box.createHorizontalGlue());
        closeButtonBox.add(closeButton);
        closeButtonBox.add(Box.createHorizontalGlue());
        Box vertButtonBox = new Box(1);
        vertButtonBox.add(Box.createVerticalStrut(3));
        vertButtonBox.add(closeButtonBox);
        vertButtonBox.add(Box.createVerticalStrut(3));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginMonitorDialog.this.setVisible(false);
            }
        });
        this._authenticationTableModel = new LoginMonitorTableModel();
        BasicTable table = new BasicTable(this._authenticationTableModel);
        this.setTableProperties(table);
        JScrollPane scrollPane = new JScrollPane(table);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)vertButtonBox, "South");
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn loginSuccedTableColumn = tableColumnModel.getColumn(5);
        TableColumn serviceTypeTableColumn = tableColumnModel.getColumn(2);
        TableColumn servicePidTableColumn = tableColumnModel.getColumn(1);
        TableColumn serviceIDTableColumn = tableColumnModel.getColumn(4);
        TableColumn serviceNameTableColumn = tableColumnModel.getColumn(0);
        TableColumn authenticationTableColumn = tableColumnModel.getColumn(6);
        TableColumn hostNameTableColumn = tableColumnModel.getColumn(3);
        loginSuccedTableColumn.setPreferredWidth(100);
        loginSuccedTableColumn.setMaxWidth(100);
        serviceTypeTableColumn.setPreferredWidth(55);
        serviceTypeTableColumn.setMaxWidth(55);
        servicePidTableColumn.setPreferredWidth(55);
        servicePidTableColumn.setMaxWidth(55);
        serviceIDTableColumn.setPreferredWidth(295);
        serviceIDTableColumn.setMaxWidth(295);
        authenticationTableColumn.setPreferredWidth(300);
        serviceNameTableColumn.setPreferredWidth(110);
        hostNameTableColumn.setPreferredWidth(85);
        LoginMonitorTableCellRenderer cellRenderer = new LoginMonitorTableCellRenderer();
        int columnCount = tableColumnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            tableColumnModel.getColumn(i).setCellRenderer(cellRenderer);
        }
    }

    public void clear() {
        this._authenticationTableModel.clear();
    }

    public class LoginMonitorTableCellRenderer
    extends DefaultTableCellRenderer {
        private Color redColor = new Color(255, 108, 108);
        private Color greenColor = new Color(49, 179, 11);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            LoginMonitorWrapper loginMonitorWrapper = (LoginMonitorWrapper)((LoginMonitorTableModel)table.getModel()).getWrapperAt(row);
            if (loginMonitorWrapper != null && !loginMonitorWrapper.isLoginSucceed()) {
                this.setForeground(this.redColor);
            } else {
                this.setForeground(this.greenColor);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                this.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            }
            this.setValue(value);
            return this;
        }
    }
}

