/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.monitor;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.ILoginListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.security.monitor.LoginMonitorWrapper;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.grid.esm.ESM;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.InternalAuthority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.DirectoryManagerUtils;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.List;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class LoginMonitorTableModel
extends BasicSortableTableModel
implements ILoginListener,
AuthenticationListener {
    private static final String CN_SERVICE_NAME = "Name";
    private static final String CN_PID = "PID";
    private static final String CN_SERVICE_TYPE = "Type";
    private static final String CN_HOST_NAME = "Host Name";
    private static final String CN_SERVICE_ID = "Service ID";
    private static final String CN_IS_LOGIN_SUCCEED = "Login succeed";
    private static final String CN_RECEIVED_AUTHENTICATION = "Authentication";
    public static final int CI_SERVICE_NAME = 0;
    public static final int CI_PID = 1;
    public static final int CI_SERVICE_TYPE = 2;
    public static final int CI_HOST_NAME = 3;
    public static final int CI_SERVICE_ID = 4;
    public static final int CI_IS_LOGIN_SUCCEED = 5;
    public static final int CI_RECEIVED_AUTHENTICATION = 6;

    public LoginMonitorTableModel() {
        SecurityServicesRepository.getInstance().addAuthenticationListener(this);
        SecurityServicesRepository.getInstance().addLoginListener(this);
    }

    public void addLoginAuthenticationMonitor(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        SecuredService securedService = (SecuredService)serviceItem.service;
        ServiceID serviceID = serviceItem.serviceID;
        String serviceType = this.getServiceType(securedService);
        String serviceName = this.getServiceName(serviceType, serviceItem);
        long pid = this.getPid(serviceItem);
        OSDetails osDetails = Repository.getInstance().getOSDetails(serviceItem, true);
        String hostName = "";
        if (osDetails != null) {
            hostName = osDetails.getHostName();
        }
        LoginMonitorWrapper loginMonitor = new LoginMonitorWrapper(serviceName, serviceType, pid, serviceID, hostName, isLoginSucceed, authentication, failureMessage);
        this.addWrapper(loginMonitor);
    }

    private String getServiceName(String serviceType, ServiceItem serviceItem) {
        int gsaAgentID = Repository.getInstance().getGSAgentID(serviceItem.serviceID);
        return JSpaceUtilities.createServiceName((String)serviceType.toLowerCase(), (int)gsaAgentID, (long)-1L);
    }

    private long getPid(ServiceItem serviceItem) {
        JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(serviceItem, true);
        long pid = -1L;
        if (jvmDetails != null) {
            pid = jvmDetails.getPid();
        }
        return pid;
    }

    private String getServiceType(SecuredService securedService) {
        if (securedService instanceof GSM) {
            return "GSM";
        }
        if (securedService instanceof GSC) {
            return "GSC";
        }
        if (securedService instanceof GSA) {
            return "GSA";
        }
        if (securedService instanceof ESM) {
            return "ESM";
        }
        if (securedService instanceof IJSpace) {
            return "Space";
        }
        return "Unknown Service";
    }

    @Override
    protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
        LoginMonitorWrapper loginMonitorWrapper1 = (LoginMonitorWrapper)wrapper1;
        LoginMonitorWrapper loginMonitorWrapper2 = (LoginMonitorWrapper)wrapper2;
        switch (colIndex) {
            case 0: {
                String serviceName1 = loginMonitorWrapper1.getServiceName();
                String serviceName2 = loginMonitorWrapper2.getServiceName();
                if (ascending) {
                    return serviceName1.compareToIgnoreCase(serviceName2);
                }
                return serviceName2.compareToIgnoreCase(serviceName1);
            }
            case 2: {
                String serviceType1 = loginMonitorWrapper1.getServiceType();
                String serviceType2 = loginMonitorWrapper2.getServiceType();
                if (ascending) {
                    return serviceType1.compareToIgnoreCase(serviceType2);
                }
                return serviceType2.compareToIgnoreCase(serviceType1);
            }
            case 3: {
                String hostName1 = loginMonitorWrapper1.getHostName();
                String hostName2 = loginMonitorWrapper2.getHostName();
                if (ascending) {
                    return hostName1.compareToIgnoreCase(hostName2);
                }
                return hostName2.compareToIgnoreCase(hostName1);
            }
            case 4: {
                String serviceId1 = loginMonitorWrapper1.getServiceID().toString();
                String serviceId2 = loginMonitorWrapper2.getServiceID().toString();
                if (ascending) {
                    return serviceId1.compareToIgnoreCase(serviceId2);
                }
                return serviceId2.compareToIgnoreCase(serviceId1);
            }
            case 1: {
                long pid1 = loginMonitorWrapper1.getPid();
                long pid2 = loginMonitorWrapper2.getPid();
                if (ascending) {
                    return pid1 < pid2 ? -1 : (pid1 == pid2 ? 0 : 1);
                }
                return pid2 < pid1 ? -1 : (pid2 == pid1 ? 0 : 1);
            }
            case 5: {
                Boolean isLoginSucceed1 = loginMonitorWrapper1.isLoginSucceed();
                Boolean isLoginSucceed2 = loginMonitorWrapper2.isLoginSucceed();
                if (ascending) {
                    return isLoginSucceed1.compareTo(isLoginSucceed2);
                }
                return isLoginSucceed2.compareTo(isLoginSucceed1);
            }
            case 6: {
                String authority2;
                Authentication authentication1 = loginMonitorWrapper1.getAuthentication();
                Authentication authentication2 = loginMonitorWrapper2.getAuthentication();
                Authority[] authoritiesArray1 = authentication1.getUserDetails().getAuthorities();
                Authority[] authoritiesArray2 = authentication2.getUserDetails().getAuthorities();
                String authority1 = authoritiesArray1.length == 0 ? "" : authoritiesArray1[0].getAuthority();
                String string = authority2 = authoritiesArray2.length == 0 ? "" : authoritiesArray2[0].getAuthority();
                if (ascending) {
                    return authority1.compareToIgnoreCase(authority2);
                }
                return authority2.compareTo(authority1);
            }
        }
        return 0;
    }

    @Override
    public Object getCellValue(BasicWrapper basicWrapper, int column) {
        LoginMonitorWrapper loginMonitorWrapper = (LoginMonitorWrapper)basicWrapper;
        switch (column) {
            case 0: {
                return loginMonitorWrapper.getServiceName();
            }
            case 1: {
                return loginMonitorWrapper.getPid() >= 0L ? String.valueOf(loginMonitorWrapper.getPid()) : "";
            }
            case 2: {
                return loginMonitorWrapper.getServiceType();
            }
            case 4: {
                return loginMonitorWrapper.getServiceID();
            }
            case 3: {
                return loginMonitorWrapper.getHostName();
            }
            case 5: {
                return loginMonitorWrapper.isLoginSucceed() ? "Yes" : "No";
            }
            case 6: {
                if (loginMonitorWrapper.isLoginSucceed()) {
                    if (loginMonitorWrapper.getAuthentication() == null) {
                        return "";
                    }
                    UserDetails userDetails = loginMonitorWrapper.getAuthentication().getUserDetails();
                    String rolesRepresentation = this.getRolesRepresentation(userDetails);
                    String authoritiesRepresentation = this.getAuthoritiesRepresentation(userDetails);
                    String resultString = "";
                    if (rolesRepresentation.length() > 0) {
                        resultString = resultString + "Roles: " + rolesRepresentation + "; ";
                    }
                    if (authoritiesRepresentation.length() > 0) {
                        resultString = resultString + "Permissions: " + authoritiesRepresentation;
                    } else if (resultString.trim().indexOf(";") > 0) {
                        resultString = resultString + resultString.substring(0, resultString.length() - 1);
                    }
                    return resultString;
                }
                return loginMonitorWrapper.getFailureMessage();
            }
        }
        return "";
    }

    private String getAuthoritiesRepresentation(UserDetails userDetails) {
        Authority[] authoritiesArray = userDetails.getAuthorities();
        String result = "";
        for (Authority authority : authoritiesArray) {
            if (authority instanceof RoleAuthority) continue;
            if (result.length() != 0) {
                result = result + ", ";
            }
            result = result + ((InternalAuthority)authority).getPrivilege();
        }
        return result;
    }

    private String getRolesRepresentation(UserDetails userDetails) {
        List userRoles = DirectoryManagerUtils.getUserRoles((UserDetails)userDetails);
        StringBuilder sb = new StringBuilder();
        for (String role : userRoles) {
            sb.append(role).append(", ");
        }
        int lastIndexOf = sb.lastIndexOf(", ");
        if (lastIndexOf != -1) {
            sb.delete(lastIndexOf, sb.length());
        }
        return sb.toString();
    }

    @Override
    protected void initColumnNames() {
        this.columnNames = new String[7];
        this.columnNames[0] = CN_SERVICE_NAME;
        this.columnNames[2] = CN_SERVICE_TYPE;
        this.columnNames[1] = CN_PID;
        this.columnNames[3] = CN_HOST_NAME;
        this.columnNames[4] = CN_SERVICE_ID;
        this.columnNames[5] = CN_IS_LOGIN_SUCCEED;
        this.columnNames[6] = CN_RECEIVED_AUTHENTICATION;
    }

    public void loginPerformed(String userName) {
    }

    public void logoutPerformed() {
        this.clear();
    }

    public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        this.addLoginAuthenticationMonitor(serviceItem, isLoginSucceed, authentication, failureMessage);
    }
}

