/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.utils;

import com.gigaspaces.security.authorities.GridAuthority;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;

public class GridPermissionsPanel
extends Box {
    private JCheckBox _manageGridComponentsCheckBox;
    private JCheckBox _provisionPUCheckBox;
    private JCheckBox _managePUSLACheckBox;
    private final List<GridAuthority> _curAuthoritiesList = new ArrayList<GridAuthority>();

    public GridPermissionsPanel(boolean isReadOnly) {
        super(1);
        this.init();
        this._manageGridComponentsCheckBox.setEnabled(!isReadOnly);
        this._provisionPUCheckBox.setEnabled(!isReadOnly);
        this._managePUSLACheckBox.setEnabled(!isReadOnly);
    }

    private void init() {
        this._manageGridComponentsCheckBox = new JCheckBox(GridAuthority.GridPrivilege.MANAGE_GRID.toString());
        this._provisionPUCheckBox = new JCheckBox(GridAuthority.GridPrivilege.PROVISION_PU.toString());
        this._managePUSLACheckBox = new JCheckBox(GridAuthority.GridPrivilege.MANAGE_PU.toString());
        this._manageGridComponentsCheckBox.setToolTipText("Start, terminate, restart of GSC/GSM/LUS");
        this._provisionPUCheckBox.setToolTipText("Deploy, un-deploy");
        this._managePUSLACheckBox.setToolTipText("Scale up/down, relocate, restart PU instance, destroy PU instance");
        Box horizBox = new Box(0);
        horizBox.add(Box.createHorizontalStrut(3));
        horizBox.add(this._manageGridComponentsCheckBox);
        horizBox.add(Box.createHorizontalStrut(14));
        horizBox.add(this._provisionPUCheckBox);
        horizBox.add(Box.createHorizontalStrut(14));
        horizBox.add(this._managePUSLACheckBox);
        horizBox.add(Box.createHorizontalGlue());
        this.add(horizBox);
        this.add(Box.createVerticalStrut(7));
    }

    public void setManageGridComponentsCBSelected(boolean select) {
        this._manageGridComponentsCheckBox.setSelected(select);
    }

    public void setProvisionPUCBSelected(boolean select) {
        this._provisionPUCheckBox.setSelected(select);
    }

    public void setManagePUSLACBSelected(boolean select) {
        this._managePUSLACheckBox.setSelected(select);
    }

    public boolean isManageGridCOmonentsCBSelected() {
        return this._manageGridComponentsCheckBox.isSelected();
    }

    public boolean isProvisionPUCBSelected() {
        return this._provisionPUCheckBox.isSelected();
    }

    public boolean isManagePUSLACBSelected() {
        return this._managePUSLACheckBox.isSelected();
    }

    public List<GridAuthority> getGridAuthorities() {
        ArrayList<GridAuthority> list = new ArrayList<GridAuthority>(3);
        if (this._manageGridComponentsCheckBox.isSelected()) {
            list.add(new GridAuthority(GridAuthority.GridPrivilege.MANAGE_GRID));
        }
        if (this._provisionPUCheckBox.isSelected()) {
            list.add(new GridAuthority(GridAuthority.GridPrivilege.PROVISION_PU));
        }
        if (this._managePUSLACheckBox.isSelected()) {
            list.add(new GridAuthority(GridAuthority.GridPrivilege.MANAGE_PU));
        }
        return list;
    }

    public void editAuthorities(List<GridAuthority> girdAuthoritiesList) {
        for (GridAuthority gridAuthority : girdAuthoritiesList) {
            if (gridAuthority.getPrivilege().equals(GridAuthority.GridPrivilege.MANAGE_GRID)) {
                this._manageGridComponentsCheckBox.setSelected(true);
            } else if (gridAuthority.getPrivilege().equals(GridAuthority.GridPrivilege.PROVISION_PU)) {
                this._provisionPUCheckBox.setSelected(true);
            } else if (gridAuthority.getPrivilege().equals(GridAuthority.GridPrivilege.MANAGE_PU)) {
                this._managePUSLACheckBox.setSelected(true);
            }
            this._curAuthoritiesList.add(gridAuthority);
        }
    }

    void clear() {
        this._manageGridComponentsCheckBox.setSelected(false);
        this._provisionPUCheckBox.setSelected(false);
        this._managePUSLACheckBox.setSelected(false);
        this._curAuthoritiesList.clear();
    }

    public void removeAuthorities(List<GridAuthority> girdAuthoritiesList) {
        for (GridAuthority gridAuthority : girdAuthoritiesList) {
            this._curAuthoritiesList.remove(gridAuthority);
            if (this._curAuthoritiesList.contains(gridAuthority)) continue;
            if (gridAuthority.getPrivilege().equals(GridAuthority.GridPrivilege.MANAGE_GRID)) {
                this._manageGridComponentsCheckBox.setSelected(false);
                continue;
            }
            if (gridAuthority.getPrivilege().equals(GridAuthority.GridPrivilege.PROVISION_PU)) {
                this._provisionPUCheckBox.setSelected(false);
                continue;
            }
            if (!gridAuthority.getPrivilege().equals(GridAuthority.GridPrivilege.MANAGE_PU)) continue;
            this._managePUSLACheckBox.setSelected(false);
        }
    }
}

