/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.utils;

import com.gigaspaces.security.authorities.MonitorAuthority;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;

public class MonitoringPermissionsPanel
extends Box {
    private JCheckBox _monitorJVMCheckBox;
    private JCheckBox _monitorPUCheckBox;
    private final List<MonitorAuthority> _curAuthoritiesList = new ArrayList<MonitorAuthority>();

    public MonitoringPermissionsPanel(boolean isReadOnly) {
        super(1);
        this.init();
        this._monitorJVMCheckBox.setEnabled(!isReadOnly);
        this._monitorPUCheckBox.setEnabled(!isReadOnly);
    }

    private void init() {
        this._monitorJVMCheckBox = new JCheckBox(MonitorAuthority.MonitorPrivilege.MONITOR_JVM.toString());
        this._monitorPUCheckBox = new JCheckBox(MonitorAuthority.MonitorPrivilege.MONITOR_PU.toString());
        this._monitorJVMCheckBox.setToolTipText("JVM statistics");
        this._monitorPUCheckBox.setToolTipText("Processing unit statistics (classes/templates/transactions/connections/statistics, etc.)");
        Box horizBox = new Box(0);
        horizBox.add(Box.createHorizontalStrut(3));
        horizBox.add(this._monitorJVMCheckBox);
        horizBox.add(Box.createHorizontalStrut(19));
        horizBox.add(this._monitorPUCheckBox);
        horizBox.add(Box.createHorizontalGlue());
        this.add(horizBox);
        this.add(Box.createVerticalStrut(7));
    }

    public void setMonitorJVMCBSelected(boolean select) {
        this._monitorJVMCheckBox.setSelected(select);
    }

    public void setMonitorPUCBSelected(boolean select) {
        this._monitorPUCheckBox.setSelected(select);
    }

    public boolean isMonitorJVMCBSelected() {
        return this._monitorJVMCheckBox.isSelected();
    }

    public boolean isMonitorPUCBSelected() {
        return this._monitorPUCheckBox.isSelected();
    }

    public List<MonitorAuthority> getMonitoringAuthorities() {
        ArrayList<MonitorAuthority> list = new ArrayList<MonitorAuthority>(2);
        if (this._monitorJVMCheckBox.isSelected()) {
            list.add(new MonitorAuthority(MonitorAuthority.MonitorPrivilege.MONITOR_JVM));
        }
        if (this._monitorPUCheckBox.isSelected()) {
            list.add(new MonitorAuthority(MonitorAuthority.MonitorPrivilege.MONITOR_PU));
        }
        return list;
    }

    public void editAuthorities(List<MonitorAuthority> monitorAuthoritiesList) {
        for (MonitorAuthority monitorAuthority : monitorAuthoritiesList) {
            if (monitorAuthority.getPrivilege().equals(MonitorAuthority.MonitorPrivilege.MONITOR_JVM)) {
                this._monitorJVMCheckBox.setSelected(true);
            } else if (monitorAuthority.getPrivilege().equals(MonitorAuthority.MonitorPrivilege.MONITOR_PU)) {
                this._monitorPUCheckBox.setSelected(true);
            }
            this._curAuthoritiesList.add(monitorAuthority);
        }
    }

    void clear() {
        this._monitorJVMCheckBox.setSelected(false);
        this._monitorPUCheckBox.setSelected(false);
        this._curAuthoritiesList.clear();
    }

    public void removeAuthorities(List<MonitorAuthority> monitorAuthoritiesList) {
        for (MonitorAuthority monitorAuthority : monitorAuthoritiesList) {
            this._curAuthoritiesList.remove(monitorAuthority);
            if (this._curAuthoritiesList.contains(monitorAuthority)) continue;
            if (monitorAuthority.getPrivilege().equals(MonitorAuthority.MonitorPrivilege.MONITOR_JVM)) {
                this._monitorJVMCheckBox.setSelected(false);
                continue;
            }
            if (!monitorAuthority.getPrivilege().equals(MonitorAuthority.MonitorPrivilege.MONITOR_PU)) continue;
            this._monitorPUCheckBox.setSelected(false);
        }
    }
}

