/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.utils;

import com.gigaspaces.admin.ui.security.utils.GridPermissionsPanel;
import com.gigaspaces.admin.ui.security.utils.MonitoringPermissionsPanel;
import com.gigaspaces.admin.ui.security.utils.SpaceOperationsPermissionsPanel;
import com.gigaspaces.admin.ui.security.utils.SystemPermissionsPanel;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.authorities.SystemAuthority;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;

public class PermissionsBox
extends Box {
    private final MonitoringPermissionsPanel _monitoringPermissionsBox;
    private final SystemPermissionsPanel _systemPermissionsBox;
    private final GridPermissionsPanel _gridPermissionsBox;
    private final SpaceOperationsPermissionsPanel _spaceOperationsBox;
    private final int EDIT_UPDATE_MODE = 1;
    private final int REMOVE_UPDATE_MODE = 2;
    private final int ADD_AGGREGATED_AUTHORITY_UPDATE_MODE = 3;

    public PermissionsBox(JFrame parentFrame, boolean isReadOnly) {
        super(1);
        this._monitoringPermissionsBox = new MonitoringPermissionsPanel(isReadOnly);
        this._systemPermissionsBox = new SystemPermissionsPanel(isReadOnly);
        this._gridPermissionsBox = new GridPermissionsPanel(isReadOnly);
        this._spaceOperationsBox = new SpaceOperationsPermissionsPanel(parentFrame, isReadOnly);
        this._monitoringPermissionsBox.setBorder(BorderFactory.createTitledBorder("Monitoring"));
        this._systemPermissionsBox.setBorder(BorderFactory.createTitledBorder("System"));
        this._spaceOperationsBox.setBorder(BorderFactory.createTitledBorder("Space Operations"));
        this._gridPermissionsBox.setBorder(BorderFactory.createTitledBorder("Grid"));
        Box monitoringAndAdministrationBox = new Box(0);
        monitoringAndAdministrationBox.add(this._monitoringPermissionsBox);
        monitoringAndAdministrationBox.add(Box.createHorizontalStrut(3));
        monitoringAndAdministrationBox.add(this._systemPermissionsBox);
        this.add(monitoringAndAdministrationBox);
        this.add(this._gridPermissionsBox);
        this.add(this._spaceOperationsBox);
        this.setBorder(BorderFactory.createTitledBorder("Permissions"));
    }

    public List<Authority> getAuthorities() {
        ArrayList<Authority> resultAuthoritiesList = new ArrayList<Authority>();
        resultAuthoritiesList.addAll(this._monitoringPermissionsBox.getMonitoringAuthorities());
        resultAuthoritiesList.addAll(this._systemPermissionsBox.getSystemAuthorities());
        resultAuthoritiesList.addAll(this._gridPermissionsBox.getGridAuthorities());
        resultAuthoritiesList.addAll(this._spaceOperationsBox.getSpaceAuthorities());
        return resultAuthoritiesList;
    }

    public void clear() {
        this._spaceOperationsBox.clear();
        this._gridPermissionsBox.clear();
        this._monitoringPermissionsBox.clear();
        this._systemPermissionsBox.clear();
    }

    public void addAggregatedAuthorities(Authority[] authorities) {
        this.updateAuthorities(authorities, 3);
    }

    public void editAuthorities(Authority[] authorities) {
        this.updateAuthorities(authorities, 1);
    }

    public void removeAggregatedAuthorities(Authority[] authorities) {
        this.updateAuthorities(authorities, 2);
    }

    private void updateAuthorities(Authority[] authorities, int updateMode) {
        ArrayList<MonitorAuthority> monitorAuthoritiesList = new ArrayList<MonitorAuthority>(2);
        ArrayList<SystemAuthority> systemAuthoritiesList = new ArrayList<SystemAuthority>(2);
        ArrayList<GridAuthority> girdAuthoritiesList = new ArrayList<GridAuthority>(3);
        ArrayList<SpaceAuthority> spaceAuthoritiesList = new ArrayList<SpaceAuthority>();
        for (Authority authority : authorities) {
            if (authority instanceof SpaceAuthority) {
                spaceAuthoritiesList.add((SpaceAuthority)authority);
                continue;
            }
            if (authority instanceof MonitorAuthority) {
                monitorAuthoritiesList.add((MonitorAuthority)authority);
                continue;
            }
            if (authority instanceof SystemAuthority) {
                systemAuthoritiesList.add((SystemAuthority)authority);
                continue;
            }
            if (!(authority instanceof GridAuthority)) continue;
            girdAuthoritiesList.add((GridAuthority)authority);
        }
        if (updateMode == 2) {
            this._monitoringPermissionsBox.removeAuthorities(monitorAuthoritiesList);
            this._systemPermissionsBox.removeAuthorities(systemAuthoritiesList);
            this._gridPermissionsBox.removeAuthorities(girdAuthoritiesList);
            this._spaceOperationsBox.removeAuthorities(spaceAuthoritiesList);
        } else {
            this._monitoringPermissionsBox.editAuthorities(monitorAuthoritiesList);
            this._systemPermissionsBox.editAuthorities(systemAuthoritiesList);
            this._gridPermissionsBox.editAuthorities(girdAuthoritiesList);
            this._spaceOperationsBox.editAuthorities(spaceAuthoritiesList);
        }
    }

    public boolean isDataValid() {
        return this._spaceOperationsBox.isDataValid();
    }
}

