/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.utils;

import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SpaceOperationsPermissionsPanel
extends Box
implements ActionListener {
    private static final String[] SPACE_OPERATIONS = new String[]{SpaceAuthority.SpacePrivilege.WRITE.toString(), SpaceAuthority.SpacePrivilege.READ.toString(), SpaceAuthority.SpacePrivilege.TAKE.toString(), SpaceAuthority.SpacePrivilege.ALTER.toString(), SpaceAuthority.SpacePrivilege.EXECUTE.toString(), SpaceAuthority.SpacePrivilege.CREATE.toString()};
    private static final String ALLOW = "Allow";
    private static final String DENY = "Deny";
    private final String _classNameRegex = "[a-zA-Z*\\_\\$][a-zA-Z0-9\\_\\$\\*\\.]*";
    private final Pattern _classNamePattern = Pattern.compile("[a-zA-Z*\\_\\$][a-zA-Z0-9\\_\\$\\*\\.]*");
    private JTable _classesTable;
    private ClassFiltersTableModel _classesTableModel;
    private JButton _addSpaceOperationButton;
    private JButton _deleteSpaceOperationButton;
    private final boolean _isReadOnlyMode;
    private final JFrame _parentFrame;
    private final Dimension buttonSize = new Dimension(24, 24);

    public SpaceOperationsPermissionsPanel(JFrame parentFrame, boolean isReadOnly) {
        super(1);
        this._parentFrame = parentFrame;
        this._isReadOnlyMode = isReadOnly;
        this.init();
    }

    private void init() {
        this.add(Box.createVerticalStrut(6));
        Box classesTableBox = this.createClassesTableBox();
        this.add(classesTableBox);
        this.add(Box.createVerticalStrut(3));
    }

    private Box createClassesTableBox() {
        Box classesTableBox = new Box(0);
        this._classesTableModel = new ClassFiltersTableModel();
        this._classesTable = new JTable(this._classesTableModel);
        this.setTableProperties(this._classesTable);
        this._classesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SpaceOperationsPermissionsPanel.this.handleDeleteButtonState();
            }
        });
        this._classesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    SpaceOperationsPermissionsPanel.this.deleteSelectedRows();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._classesTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        classesTableBox.add(scrollPane);
        this._addSpaceOperationButton = this.createAddRemoveButton(IconsRepository.getInstance().getIcon(200), "+", "Add space operation rule");
        this._deleteSpaceOperationButton = this.createAddRemoveButton(IconsRepository.getInstance().getIcon(201), "-", "Remove selected space operation rule(s)");
        this._addSpaceOperationButton.addActionListener(this);
        this._deleteSpaceOperationButton.addActionListener(this);
        this._addSpaceOperationButton.setEnabled(!this._isReadOnlyMode);
        this._deleteSpaceOperationButton.setEnabled(!this._isReadOnlyMode);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._addSpaceOperationButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._deleteSpaceOperationButton);
        buttonsBox.add(Box.createHorizontalGlue());
        Box vertBox = new Box(1);
        vertBox.add(classesTableBox);
        vertBox.add(Box.createVerticalStrut(4));
        vertBox.add(buttonsBox);
        return vertBox;
    }

    private JButton createAddRemoveButton(ImageIcon icon, String text, String tooltip) {
        JButton button = new JButton(text);
        button.setPreferredSize(this.buttonSize);
        button.setMinimumSize(this.buttonSize);
        button.setToolTipText(tooltip);
        return button;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 3);
        TableColumnModel tableColumnModel = table.getColumnModel();
        int columnWidth = 80;
        TableColumn operationsColumn = tableColumnModel.getColumn(0);
        TableColumn allowDenyColumn = tableColumnModel.getColumn(2);
        TableColumn classNameColumn = tableColumnModel.getColumn(1);
        JComboBox<String> operationsComboBox = new JComboBox<String>(SPACE_OPERATIONS);
        operationsColumn.setCellEditor(new DefaultCellEditor(operationsComboBox));
        operationsComboBox.setRenderer(new MyComboBoxRenderer());
        JComboBox<String> allowDenyComboBox = new JComboBox<String>(new String[]{ALLOW, DENY});
        allowDenyColumn.setCellEditor(new DefaultCellEditor(allowDenyComboBox));
        operationsColumn.setPreferredWidth(80);
        allowDenyColumn.setPreferredWidth(80);
        classNameColumn.setPreferredWidth(600);
        table.setAutoCreateColumnsFromModel(false);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private void handleDeleteButtonState() {
        if (!this._isReadOnlyMode) {
            this._deleteSpaceOperationButton.setEnabled(this._classesTable.getSelectedRows().length > 0);
        }
    }

    public void clear() {
        this._deleteSpaceOperationButton.setEnabled(false);
        this._classesTableModel.clear();
        this._classesTable.setEditingColumn(-1);
        this._classesTable.setEditingRow(-1);
        TableCellEditor cellEditor = this._classesTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
    }

    public List<SpaceAuthority> getSpaceAuthorities() {
        return this._classesTableModel.getSpaceAuthorities();
    }

    public void editAuthorities(List<SpaceAuthority> spaceAuthoritiesList) {
        this._classesTableModel.setSpaceAuthorities(spaceAuthoritiesList);
    }

    public void removeAuthorities(List<SpaceAuthority> removedSpaceAutoritiesList) {
        this._classesTableModel.removeAuthorities(removedSpaceAutoritiesList);
    }

    public boolean isDataValid() {
        return this.stopCellEditong();
    }

    private boolean stopCellEditong() {
        JTextField textEditor;
        String className;
        int editingColumn = this._classesTable.getEditingColumn();
        TableCellEditor cellEditor = this._classesTable.getCellEditor();
        if (editingColumn == 1 && cellEditor != null && !this.isClassNameValid(className = (textEditor = (JTextField)((DefaultCellEditor)cellEditor).getComponent()).getText())) {
            return false;
        }
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return true;
    }

    private boolean isClassNameValid(String className) {
        if (!JSpaceUtilities.isEmpty((String)className, (boolean)true) && !this._classNamePattern.matcher(className).matches()) {
            JOptionPane.showMessageDialog(this._parentFrame, "Class name filter is invalid.", "Class Name Validation", 1);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._addSpaceOperationButton)) {
            if (this.stopCellEditong()) {
                SpaceAuthority spaceAuthority = new SpaceAuthority(SpaceAuthority.SpacePrivilege.WRITE, null);
                this._classesTableModel.addSpaceAuthority(spaceAuthority);
            }
        } else if (source.equals(this._deleteSpaceOperationButton)) {
            this.deleteSelectedRows();
        }
    }

    private void deleteSelectedRows() {
        if (!this.stopCellEditong()) {
            return;
        }
        int[] selRows = this._classesTable.getSelectedRows();
        this._classesTableModel.removeAuthoritiesAt(selRows);
        if (this._classesTable.getRowCount() > 0) {
            int minRow = selRows[0];
            int selRow = minRow == 0 ? 0 : minRow - 1;
            this._classesTable.setRowSelectionInterval(selRow, selRow);
        }
    }

    private class ClassFiltersTableModel
    extends DefaultTableModel {
        private final String CN_OPERATIONS = "Space Operation";
        private final String CN_CLASSNAME = "Class name (* = any string)";
        private final String CN_ALLOW_DENY = "Allow or Deny";
        public static final int CI_OPERATIONS = 0;
        public static final int CI_CLASSNAME = 1;
        public static final int CI_ALLOW_DENY = 2;
        protected String[] columnNames;
        private final List<SpaceAuthority> _curSpaceAuthoritiesList = new ArrayList<SpaceAuthority>();

        public ClassFiltersTableModel() {
            this.initColumnNames();
        }

        public void addSpaceAuthority(SpaceAuthority spaceAuthority) {
            this._curSpaceAuthoritiesList.add(spaceAuthority);
            int newListSize = this._curSpaceAuthoritiesList.size();
            this.fireTableRowsInserted(newListSize - 1, newListSize - 1);
        }

        protected void initColumnNames() {
            this.columnNames = new String[3];
            this.columnNames[1] = "Class name (* = any string)";
            this.columnNames[0] = "Space Operation";
            this.columnNames[2] = "Allow or Deny";
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row >= this._curSpaceAuthoritiesList.size()) {
                return;
            }
            SpaceAuthority spaceAuthority = this._curSpaceAuthoritiesList.get(row);
            SpaceAuthority.SpacePrivilege spacePrivilige = null;
            SpaceAuthority.Filter filter = null;
            switch (column) {
                case 0: {
                    filter = spaceAuthority.getFilter();
                    spacePrivilige = this.getSpacePrivivilege(aValue.toString());
                    break;
                }
                case 1: {
                    String className = aValue.toString();
                    if (!SpaceOperationsPermissionsPanel.this.isClassNameValid(className)) {
                        return;
                    }
                    boolean isAllow = !this.getValueAt(row, 2).equals(SpaceOperationsPermissionsPanel.DENY);
                    filter = this.createFilter(className, isAllow);
                    spacePrivilige = (SpaceAuthority.SpacePrivilege)spaceAuthority.getPrivilege();
                    break;
                }
                case 2: {
                    boolean isAllow = !aValue.equals(SpaceOperationsPermissionsPanel.DENY);
                    filter = this.createFilter(this.getValueAt(row, 1).toString(), isAllow);
                    spacePrivilige = (SpaceAuthority.SpacePrivilege)spaceAuthority.getPrivilege();
                }
            }
            if (spacePrivilige != null) {
                spaceAuthority = new SpaceAuthority(spacePrivilige, filter);
                this._curSpaceAuthoritiesList.set(row, spaceAuthority);
            }
        }

        private SpaceAuthority.Filter createFilter(String className, boolean isAllow) {
            SpaceAuthority.Filter filter = null;
            if (!isAllow || isAllow && !JSpaceUtilities.isEmpty((String)className, (boolean)true) && !className.equals("*")) {
                filter = SpaceAuthority.WildcardExpressionToFilterConverter.convertToRegex((String)className, (boolean)isAllow);
            }
            return filter;
        }

        private SpaceAuthority.SpacePrivilege getSpacePrivivilege(String privilegeName) {
            if (privilegeName.equals(SpaceAuthority.SpacePrivilege.WRITE.toString())) {
                return SpaceAuthority.SpacePrivilege.WRITE;
            }
            if (privilegeName.equals(SpaceAuthority.SpacePrivilege.READ.toString())) {
                return SpaceAuthority.SpacePrivilege.READ;
            }
            if (privilegeName.equals(SpaceAuthority.SpacePrivilege.TAKE.toString())) {
                return SpaceAuthority.SpacePrivilege.TAKE;
            }
            if (privilegeName.equals(SpaceAuthority.SpacePrivilege.ALTER.toString())) {
                return SpaceAuthority.SpacePrivilege.ALTER;
            }
            if (privilegeName.equals(SpaceAuthority.SpacePrivilege.EXECUTE.toString())) {
                return SpaceAuthority.SpacePrivilege.EXECUTE;
            }
            if (privilegeName.equals(SpaceAuthority.SpacePrivilege.CREATE.toString())) {
                return SpaceAuthority.SpacePrivilege.CREATE;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return !SpaceOperationsPermissionsPanel.this._isReadOnlyMode;
        }

        public void removeClassFilterAt(int row) {
            if (row >= 0 && row < this._curSpaceAuthoritiesList.size()) {
                this._curSpaceAuthoritiesList.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            SpaceAuthority spaceAuthority;
            if (row >= 0 && row < this._curSpaceAuthoritiesList.size() && (spaceAuthority = this._curSpaceAuthoritiesList.get(row)) != null) {
                return this.getCellValue(spaceAuthority, column);
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._curSpaceAuthoritiesList == null ? 0 : this._curSpaceAuthoritiesList.size();
        }

        private Object getCellValue(SpaceAuthority spaceAuthority, int column) {
            SpaceAuthority.Filter filter = spaceAuthority.getFilter();
            switch (column) {
                case 1: {
                    return filter == null ? "*" : filter.getExpression();
                }
                case 0: {
                    return spaceAuthority.getPrivilege().toString();
                }
                case 2: {
                    if (filter == null) {
                        return SpaceOperationsPermissionsPanel.ALLOW;
                    }
                    return filter instanceof SpaceAuthority.NegateFilter ? SpaceOperationsPermissionsPanel.DENY : SpaceOperationsPermissionsPanel.ALLOW;
                }
            }
            return "";
        }

        public SpaceAuthority getSpaceAuthorityAt(int row) {
            if (row >= 0 && row < this._curSpaceAuthoritiesList.size()) {
                return this._curSpaceAuthoritiesList.get(row);
            }
            return null;
        }

        public List<SpaceAuthority> getSpaceAuthorities() {
            return this._curSpaceAuthoritiesList;
        }

        public void setSpaceAuthorities(List<SpaceAuthority> autoritiesList) {
            int curListSize = this._curSpaceAuthoritiesList.size();
            this._curSpaceAuthoritiesList.addAll(autoritiesList);
            int listSize = autoritiesList.size();
            if (listSize > 0) {
                this.fireTableRowsInserted(curListSize, curListSize + listSize - 1);
            }
        }

        public void removeAuthorities(List<SpaceAuthority> removedAutoritiesList) {
            this._curSpaceAuthoritiesList.removeAll(removedAutoritiesList);
            this.fireTableDataChanged();
        }

        public void removeAuthoritiesAt(int ... rows) {
            for (int index = rows.length - 1; index >= 0; --index) {
                this._curSpaceAuthoritiesList.remove(rows[index]);
            }
            this.fireTableDataChanged();
        }

        private Object getAuthoritiesRepresentation(Authority[] authoritiesArray) {
            String result = "";
            for (Authority authority : authoritiesArray) {
                if (result.length() != 0) {
                    result = result + ", ";
                }
                result = result + authority.getAuthority();
            }
            return result;
        }

        public void clear() {
            int curRowCount = this._curSpaceAuthoritiesList.size();
            if (curRowCount > 0) {
                this.fireTableRowsDeleted(0, curRowCount - 1);
            }
            this._curSpaceAuthoritiesList.clear();
        }
    }

    class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(this.getOperationToolTip(value));
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }

        private String getOperationToolTip(Object value) {
            if (value != null) {
                if (value.equals(SpaceAuthority.SpacePrivilege.WRITE.toString())) {
                    return "Write and Update operations";
                }
                if (value.equals(SpaceAuthority.SpacePrivilege.READ.toString())) {
                    return "Read, Count and Notify operations";
                }
                if (value.equals(SpaceAuthority.SpacePrivilege.TAKE.toString())) {
                    return "Take and Clear operations";
                }
                if (value.equals(SpaceAuthority.SpacePrivilege.ALTER.toString())) {
                    return "Clean and Drop-Class operations";
                }
                if (value.equals(SpaceAuthority.SpacePrivilege.EXECUTE.toString())) {
                    return "Execute tasks";
                }
                if (value.equals(SpaceAuthority.SpacePrivilege.CREATE.toString())) {
                    return "Create (write only) operations";
                }
            }
            return null;
        }
    }
}

