/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.utils;

import com.gigaspaces.security.authorities.SystemAuthority;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;

public class SystemPermissionsPanel
extends Box {
    private JCheckBox _manageUsersCheckBox;
    private JCheckBox _manageRolesCheckBox;
    private final List<SystemAuthority> _curAuthoritiesList = new ArrayList<SystemAuthority>();

    public SystemPermissionsPanel(boolean isReadOnly) {
        super(1);
        this.init();
        this._manageUsersCheckBox.setEnabled(!isReadOnly);
        this._manageRolesCheckBox.setEnabled(!isReadOnly);
    }

    private void init() {
        this._manageUsersCheckBox = new JCheckBox(SystemAuthority.SystemPrivilege.MANAGE_USERS.toString());
        this._manageRolesCheckBox = new JCheckBox(SystemAuthority.SystemPrivilege.MANAGE_ROLES.toString());
        this._manageUsersCheckBox.setToolTipText("Managing of users");
        this._manageRolesCheckBox.setToolTipText("Managing of roles");
        Box horizBox = new Box(0);
        horizBox.add(Box.createHorizontalStrut(3));
        horizBox.add(this._manageUsersCheckBox);
        horizBox.add(Box.createHorizontalStrut(19));
        horizBox.add(this._manageRolesCheckBox);
        horizBox.add(Box.createHorizontalGlue());
        this.add(horizBox);
        this.add(Box.createVerticalStrut(7));
    }

    public void setManageUsersCBSelected(boolean select) {
        this._manageUsersCheckBox.setSelected(select);
    }

    public void setManageRolesCBSelected(boolean select) {
        this._manageRolesCheckBox.setSelected(select);
    }

    public boolean isManageUsersCBSelected() {
        return this._manageUsersCheckBox.isSelected();
    }

    public boolean isManageRolesCBSelected() {
        return this._manageRolesCheckBox.isSelected();
    }

    public List<SystemAuthority> getSystemAuthorities() {
        ArrayList<SystemAuthority> list = new ArrayList<SystemAuthority>(2);
        if (this._manageUsersCheckBox.isSelected()) {
            list.add(new SystemAuthority(SystemAuthority.SystemPrivilege.MANAGE_USERS));
        }
        if (this._manageRolesCheckBox.isSelected()) {
            list.add(new SystemAuthority(SystemAuthority.SystemPrivilege.MANAGE_ROLES));
        }
        return list;
    }

    public void editAuthorities(List<SystemAuthority> systemAuthoritiesList) {
        for (SystemAuthority systemAuthority : systemAuthoritiesList) {
            if (systemAuthority.getPrivilege().equals(SystemAuthority.SystemPrivilege.MANAGE_ROLES)) {
                this._manageRolesCheckBox.setSelected(true);
            } else if (systemAuthority.getPrivilege().equals(SystemAuthority.SystemPrivilege.MANAGE_USERS)) {
                this._manageUsersCheckBox.setSelected(true);
            }
            this._curAuthoritiesList.add(systemAuthority);
        }
    }

    void clear() {
        this._manageRolesCheckBox.setSelected(false);
        this._manageUsersCheckBox.setSelected(false);
        this._curAuthoritiesList.clear();
    }

    public void removeAuthorities(List<SystemAuthority> systemAuthoritiesList) {
        for (SystemAuthority systemAuthority : systemAuthoritiesList) {
            this._curAuthoritiesList.remove(systemAuthority);
            if (this._curAuthoritiesList.contains(systemAuthority)) continue;
            if (systemAuthority.getPrivilege().equals(SystemAuthority.SystemPrivilege.MANAGE_ROLES)) {
                this._manageRolesCheckBox.setSelected(false);
                continue;
            }
            if (!systemAuthority.getPrivilege().equals(SystemAuthority.SystemPrivilege.MANAGE_USERS)) continue;
            this._manageUsersCheckBox.setSelected(false);
        }
    }
}

