/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.security.utils;

import com.gigaspaces.admin.ui.security.utils.IRoleSelectionListener;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.RoleDetails;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.UserDetails;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UserRolesPanel
extends JPanel
implements ItemListener {
    private Map<String, RoleCheckBox> _roleCheckBoxesMap = new HashMap<String, RoleCheckBox>(5);
    private List<IRoleSelectionListener> _roleSelectionListenersList = new ArrayList<IRoleSelectionListener>();
    private RoleManager _roleManager;
    private boolean _isClearInvoked;
    private Box _vertBox = new Box(1);

    public UserRolesPanel(RoleManager roleManager) {
        super(new BorderLayout());
        this._roleManager = roleManager;
        this.fillRoles(roleManager);
        JScrollPane scrollPane = new JScrollPane(this._vertBox);
        scrollPane.setBorder(null);
        scrollPane.setPreferredSize(new Dimension(100, 50));
        this.add((Component)scrollPane, "Center");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Roles"), BorderFactory.createEmptyBorder(0, 3, 0, 0)));
    }

    public void addRoleSelectionListener(IRoleSelectionListener roleSelectionListener) {
        this._roleSelectionListenersList.add(roleSelectionListener);
    }

    public void removeRoleSelectionListener(IRoleSelectionListener roleSelectionListener) {
        this._roleSelectionListenersList.remove(roleSelectionListener);
    }

    public void fillRoles(RoleManager roleManager) {
        if (roleManager != null) {
            Map roleDetailsMap = roleManager.mapRoles();
            Iterator iterator = roleDetailsMap.values().iterator();
            this._roleCheckBoxesMap.clear();
            this._vertBox.removeAll();
            while (iterator.hasNext()) {
                RoleDetails roleDetails = (RoleDetails)iterator.next();
                RoleCheckBox roleCheckBox = new RoleCheckBox(roleDetails, false);
                roleCheckBox.addItemListener(this);
                this._roleCheckBoxesMap.put(roleDetails.getRole(), roleCheckBox);
                this._vertBox.add(roleCheckBox);
                this._vertBox.add(Box.createVerticalStrut(2));
            }
        }
    }

    public void clear() {
        Collection<RoleCheckBox> roleCheckBoxesCollection = this._roleCheckBoxesMap.values();
        Iterator<RoleCheckBox> iterator = roleCheckBoxesCollection.iterator();
        this._isClearInvoked = true;
        while (iterator.hasNext()) {
            iterator.next().setSelected(false);
        }
        this._isClearInvoked = false;
    }

    public void initRoles(UserDetails userDetails) {
        Authority[] authorities;
        this.updateRoles();
        for (Authority authority : authorities = userDetails.getAuthorities()) {
            RoleAuthority roleAuthority;
            String roleName;
            RoleCheckBox roleCheckBox;
            if (!(authority instanceof RoleAuthority) || (roleCheckBox = this._roleCheckBoxesMap.get(roleName = (roleAuthority = (RoleAuthority)authority).getRole())) == null) continue;
            roleCheckBox.setSelected(true);
        }
    }

    public void updateRoles() {
        this.fillRoles(this._roleManager);
    }

    public List<RoleAuthority> getSelectedRoleAuthorities() {
        Set<Map.Entry<String, RoleCheckBox>> roleCheckBoxesCollection = this._roleCheckBoxesMap.entrySet();
        Iterator<Map.Entry<String, RoleCheckBox>> iterator = roleCheckBoxesCollection.iterator();
        ArrayList<RoleAuthority> roleAuthoritiesList = new ArrayList<RoleAuthority>();
        while (iterator.hasNext()) {
            Map.Entry<String, RoleCheckBox> mapEntry = iterator.next();
            if (!mapEntry.getValue().isSelected()) continue;
            String roleName = mapEntry.getKey();
            RoleAuthority roleAuthority = new RoleAuthority(roleName);
            roleAuthoritiesList.add(roleAuthority);
        }
        return roleAuthoritiesList;
    }

    private void fireRoleSelectinChanged(RoleDetails role, boolean selected) {
        for (IRoleSelectionListener roleSelectionListener : this._roleSelectionListenersList) {
            roleSelectionListener.roleSelectionChanged(role, selected);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this._isClearInvoked) {
            RoleCheckBox roleCheckBox = (RoleCheckBox)e.getSource();
            RoleDetails role = roleCheckBox.getRole();
            if (e.getStateChange() == 1) {
                this.fireRoleSelectinChanged(role, true);
            } else {
                this.fireRoleSelectinChanged(role, false);
            }
        }
    }

    public class RoleCheckBox
    extends JCheckBox {
        private RoleDetails _role;

        public RoleCheckBox(RoleDetails role, boolean isSelected) {
            super(role.getRole(), isSelected);
            this._role = role;
        }

        public RoleDetails getRole() {
            return this._role;
        }
    }
}

