/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.serviceui;

import com.gigaspaces.admin.ui.serviceui.ApplianceInfoPanel;
import com.gigaspaces.admin.ui.serviceui.UILoader;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;
import net.jini.lookup.ui.factory.JComponentFactory;
import net.jini.lookup.ui.factory.JDialogFactory;
import net.jini.lookup.ui.factory.JFrameFactory;
import net.jini.lookup.ui.factory.JWindowFactory;
import org.jini.rio.entry.ApplianceInfo;

public class AdminViewer
extends JFrame {
    private JButton closeB;
    ServiceItem item = null;
    Entry[] attrs;
    JTabbedPane tabpane;
    JPanel base;
    JPanel substrate;
    Object[] uiComponents;
    List<JComponent> jComponentList = new ArrayList<JComponent>();
    public static final long DEFAULT_DELAY = 30000L;

    public AdminViewer(String titlePrefix, Object object) throws Exception {
        this(titlePrefix, object, 30000L);
    }

    public AdminViewer(Object object) throws Exception {
        this(null, object, 30000L);
    }

    public AdminViewer(String titlePrefix, Object object, long startupDelay) throws Exception {
        ImageIcon frameIcon = UIHelper.getImageIcon("image/browser/jspacesIcon.png");
        this.setIconImage(frameIcon.getImage());
        this.item = (ServiceItem)object;
        this.attrs = this.item.attributeSets;
        this.substrate = new JPanel();
        this.substrate.setLayout(new BorderLayout(8, 8));
        this.base = new JPanel();
        this.base.setLayout(new BorderLayout(8, 8));
        this.tabpane = new JTabbedPane();
        String svcName = null;
        Name name = this.getName(this.attrs);
        if (name != null) {
            svcName = name.name;
            this.setTitle(svcName + " Administration UI");
        } else {
            svcName = this.item.service.getClass().getName();
            this.setTitle("Administration UI");
        }
        if (titlePrefix != null) {
            this.setTitle(titlePrefix + " Administration UI");
        }
        ApplianceInfo aInfo = this.getApplianceInfo(this.attrs);
        Timer taskTimer = new Timer(true);
        long now = System.currentTimeMillis();
        UIComponentFetcher uiFetcher = new UIComponentFetcher();
        WaitingToLoadTask waitingToLoadTask = null;
        waitingToLoadTask = aInfo != null ? new WaitingToLoadTask(svcName, aInfo.hostName, aInfo.hostAddress) : new WaitingToLoadTask(svcName, "unknown", "unknown");
        TimeoutTask timeoutTask = new TimeoutTask((Thread)((Object)uiFetcher));
        taskTimer.schedule((TimerTask)waitingToLoadTask, new Date(now + Math.min(5000L, startupDelay)));
        taskTimer.schedule((TimerTask)timeoutTask, new Date(now + startupDelay));
        uiFetcher.start();
        try {
            uiFetcher.join(startupDelay);
        }
        catch (InterruptedException e) {
            throw new Exception("Unable to obtain Service UI attributes for " + svcName + " in allotted time of " + startupDelay / 1000L + " seconds");
        }
        waitingToLoadTask.cancel();
        if (waitingToLoadTask.dialog != null) {
            waitingToLoadTask.dialog.dispose();
        }
        if (uiFetcher.isInterrupted()) {
            throw new Exception("Unable to obtain Service UI attributes for " + svcName + " in allotted time of " + startupDelay / 1000L + " seconds");
        }
        timeoutTask.cancel();
        if (uiFetcher.exception != null) {
            throw uiFetcher.exception;
        }
        if (aInfo != null) {
            ApplianceInfoPanel aInfoPanel = new ApplianceInfoPanel();
            aInfoPanel.setApplianceInfo(aInfo);
            this.tabpane.add("Host Attributes", aInfoPanel);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        buttonPanel.setLayout(new FlowLayout(1, 8, 8));
        this.closeB = new JButton("Close");
        this.closeB.setToolTipText("Close the window");
        this.closeB.addActionListener(new DismissHandler());
        buttonPanel.add(this.closeB);
        this.base.add((Component)this.tabpane, "Center");
        this.base.add((Component)buttonPanel, "South");
        this.substrate.add("Center", this.base);
        this.substrate.add("South", buttonPanel);
        this.display();
    }

    public Object[] getUIComponents() {
        if (this.uiComponents == null) {
            return new Object[0];
        }
        Object[] comps = new Object[this.uiComponents.length];
        System.arraycopy(this.uiComponents, 0, comps, 0, this.uiComponents.length);
        return comps;
    }

    private void display() {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AdminViewer.this.terminate();
            }
        };
        this.addWindowListener(l);
        Container container = this.getContentPane();
        if (container != null) {
            container.add(this.substrate);
        }
        this.setSize(490, 505);
        this.setLocation(50, 100);
        this.setVisible(true);
    }

    private JComponent getComponent(Object factory, Object item) throws Exception {
        JComponent uiComponent = null;
        Class<?> factoryClass = factory.getClass();
        if (JFrameFactory.class.isAssignableFrom(factoryClass)) {
            uiComponent = new LaunchPanel(factory, item);
        } else if (JWindowFactory.class.isAssignableFrom(factoryClass)) {
            uiComponent = new LaunchPanel(factory, item);
        } else if (JComponentFactory.class.isAssignableFrom(factoryClass)) {
            JComponentFactory fac = (JComponentFactory)factory;
            uiComponent = fac.getJComponent(item);
            String name = uiComponent.getAccessibleContext().getAccessibleName();
            if (name == null) {
                uiComponent.getAccessibleContext().setAccessibleName(uiComponent.getClass().getName());
            }
        } else if (JDialogFactory.class.isAssignableFrom(factoryClass)) {
            uiComponent = new LaunchPanel(factory, item);
        }
        return uiComponent;
    }

    public void terminate() {
        Iterator<JComponent> it = this.jComponentList.iterator();
        while (it.hasNext()) {
            try {
                JComponent jComp = it.next();
                Method terminate = jComp.getClass().getMethod("terminate", null);
                terminate.invoke((Object)jComp, (Object[])null);
            }
            catch (Exception exception) {}
        }
        this.dispose();
    }

    ApplianceInfo getApplianceInfo(Entry[] attrs) {
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof ApplianceInfo)) continue;
            return (ApplianceInfo)attrs[x];
        }
        return null;
    }

    Name getName(Entry[] attrs) {
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof Name)) continue;
            return (Name)attrs[x];
        }
        return null;
    }

    private static class LaunchPanel
    extends JPanel {
        Object uiObj;

        LaunchPanel(final Object factory, final Object item) {
            String info = factory.getClass().getName();
            this.getAccessibleContext().setAccessibleName(info);
            JButton button = new JButton("Launch " + info);
            button.addActionListener(new ActionListener(){
                final Class factoryClass;
                {
                    this.factoryClass = factory.getClass();
                }

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        if (JFrameFactory.class.isAssignableFrom(this.factoryClass)) {
                            this.launchFrameUI(factory, item);
                        } else if (JWindowFactory.class.isAssignableFrom(this.factoryClass)) {
                            this.launchWindowUI(factory, item);
                        } else if (JDialogFactory.class.isAssignableFrom(this.factoryClass)) {
                            this.launchDialogUI(factory, item);
                        }
                    }
                    catch (Exception e) {
                        UIHelper.showError((Throwable)e, "Creating Service UI Factory");
                    }
                }
            });
            this.add(button);
        }

        private void launchFrameUI(Object factory, Object item) {
            JFrameFactory fac = (JFrameFactory)factory;
            JFrame frame = fac.getJFrame(item);
            frame.validate();
            frame.setSize(frame.getSize());
            frame.setLocation(frame.getLocation());
            frame.pack();
            frame.setVisible(true);
            this.uiObj = frame;
        }

        private void launchWindowUI(Object factory, Object item) {
            JWindowFactory fac = (JWindowFactory)factory;
            JWindow win = fac.getJWindow(item);
            win.validate();
            win.pack();
            win.setVisible(true);
            this.uiObj = win;
        }

        private void launchDialogUI(Object factory, Object item) {
            JDialogFactory fac = (JDialogFactory)factory;
            JDialog d = fac.getJDialog(item);
            d.validate();
            d.pack();
            d.setVisible(true);
            this.uiObj = d;
        }
    }

    private static class WaitingToLoadTask
    extends TimerTask {
        String svcName;
        String hostName;
        String hostAddress;
        JDialog dialog;

        WaitingToLoadTask(String svcName, String hostName, String hostAddress) {
            this.svcName = svcName;
            this.hostName = hostName;
            this.hostAddress = hostAddress;
        }

        @Override
        public void run() {
            JOptionPane pane = new JOptionPane("<html><font color=black>Waiting to load UI Components for the </font><br><font color=blue>" + this.svcName + "</font><font color=black> service running on<br>machine: <font color=blue>" + this.hostName + "</font><font color=black> address: </font><font color=blue>" + this.hostAddress + "</font><br><font color=black>The timeframe is longer then expected,<br>verify network connections.</font></html>", 2);
            this.dialog = pane.createDialog(null, "Network Delay");
            this.dialog.setModal(false);
            this.dialog.setVisible(true);
        }
    }

    private static class TimeoutTask
    extends TimerTask {
        Thread thread;

        TimeoutTask(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void run() {
            this.thread.interrupt();
            System.out.println("Cancelled Admin Viewer startup");
        }
    }

    class UIComponentFetcher
    extends GSThread {
        Exception exception;

        public UIComponentFetcher() {
            super("UIComponentFetcher");
        }

        public void run() {
            try {
                AdminViewer.this.uiComponents = UILoader.loadUI(AdminViewer.this.item);
                if (AdminViewer.this.uiComponents != null) {
                    for (int i = AdminViewer.this.uiComponents.length - 1; i >= 0 && !this.isInterrupted(); --i) {
                        JComponent jComp = AdminViewer.this.getComponent(AdminViewer.this.uiComponents[i], AdminViewer.this.item);
                        if (jComp instanceof JPanel) {
                            String name = ((JPanel)jComp).getAccessibleContext().getAccessibleName();
                            AdminViewer.this.tabpane.add(name, jComp);
                            AdminViewer.this.jComponentList.add(jComp);
                            continue;
                        }
                        System.err.println("Unsupported UI class");
                    }
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }

    public class DismissHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            AdminViewer.this.terminate();
        }
    }
}

