/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.serviceui;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jini.rio.entry.ApplianceInfo;

public class ApplianceInfoPanel
extends JPanel {
    JTextField jvmVendor;
    JTextField jvmVersion;
    JTextField hostaddr;
    JTextField hostname;
    JTextField osinfo;
    JTextField osversion;
    JTextField arch;

    public ApplianceInfoPanel() {
        this.setLayout(new BoxLayout(this, 1));
        Box appl = new Box(1);
        Box jvm = new Box(1);
        jvm.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JVM Information"));
        this.jvmVendor = this.createAttrTextField();
        this.jvmVersion = this.createAttrTextField();
        this.addTextFieldToBox(jvm, new JLabel("JVM Version:"), this.jvmVersion);
        this.addTextFieldToBox(jvm, new JLabel("JVM Vendor:"), this.jvmVendor);
        appl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Host Attributes"));
        this.hostname = this.createAttrTextField();
        this.hostaddr = this.createAttrTextField();
        this.osinfo = this.createAttrTextField();
        this.arch = this.createAttrTextField();
        this.addTextFieldToBox(appl, new JLabel("Host Name:"), this.hostname);
        this.addTextFieldToBox(appl, new JLabel("Host Address:"), this.hostaddr);
        this.addTextFieldToBox(appl, new JLabel("Operating System:"), this.osinfo);
        this.addTextFieldToBox(appl, new JLabel("Architecture:"), this.arch);
        this.add(appl);
        this.add(Box.createVerticalStrut(8));
        this.add(jvm);
        this.add(Box.createVerticalGlue());
    }

    private void addTextFieldToBox(Box box, JLabel label, JTextField textField) {
        Dimension labelSize = new Dimension(110, 22);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(labelSize);
        Box horizontalBox = new Box(0);
        horizontalBox.add(label);
        horizontalBox.add(Box.createHorizontalStrut(5));
        horizontalBox.add(textField);
        horizontalBox.add(Box.createHorizontalGlue());
        box.add(horizontalBox);
    }

    public void setApplianceInfo(ApplianceInfo info) {
        if (info == null) {
            this.jvmVersion.setText("Unknown");
            this.jvmVendor.setText("Unknown");
            this.hostname.setText("Unknown");
            this.hostaddr.setText("Unknown");
            this.osinfo.setText("Uknown");
            this.arch.setText("Unknown");
            return;
        }
        this.jvmVersion.setText(info.jvmVersion);
        this.jvmVersion.setCaretPosition(0);
        this.jvmVendor.setText(info.jvmVendor);
        this.jvmVendor.setCaretPosition(0);
        this.hostname.setText(info.hostName);
        this.hostname.setCaretPosition(0);
        this.hostaddr.setText(info.hostAddress);
        this.hostaddr.setCaretPosition(0);
        String s = info.osName;
        s = s + " " + info.osVersion;
        this.osinfo.setText(s);
        this.osinfo.setCaretPosition(0);
        this.arch.setText(info.arch);
        this.arch.setCaretPosition(0);
    }

    private JTextField createAttrTextField() {
        JTextField tf = new JTextField();
        Dimension fieldSize = new Dimension(200, 22);
        tf.setPreferredSize(fieldSize);
        tf.setMaximumSize(fieldSize);
        tf.setEditable(false);
        return tf;
    }
}

