/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.serviceui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.UIDescriptor;
import net.jini.lookup.ui.attribute.UIFactoryTypes;
import net.jini.lookup.ui.factory.JComponentFactory;

public class UILoader {
    public static JComponent[] loadUI(String role, ServiceItem serviceItem) {
        try {
            int attrCount = serviceItem.attributeSets.length;
            Entry[] attr = serviceItem.attributeSets;
            ArrayList<UIDescriptor> list = new ArrayList<UIDescriptor>();
            for (int i = 0; i < attrCount; ++i) {
                if (!(attr[i] instanceof UIDescriptor)) continue;
                UIDescriptor desc = (UIDescriptor)attr[i];
                if (desc.attributes == null || !desc.role.equals(role)) continue;
                for (Object uiAttr : desc.attributes) {
                    if (!(uiAttr instanceof UIFactoryTypes)) continue;
                    UIFactoryTypes factoryTypes = (UIFactoryTypes)uiAttr;
                    boolean found = false;
                    found = factoryTypes.isAssignableTo(JComponentFactory.class);
                    if (!found) continue;
                    list.add(desc);
                }
            }
            ArrayList<JComponentFactory> factoryList = new ArrayList<JComponentFactory>();
            for (int i = 0; i < list.size(); ++i) {
                Object uiFactory = null;
                try {
                    UIDescriptor desc = (UIDescriptor)list.get(i);
                    uiFactory = desc.getUIFactory(serviceItem.service.getClass().getClassLoader());
                    if (!(uiFactory instanceof JComponentFactory)) continue;
                    factoryList.add((JComponentFactory)uiFactory);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    System.out.println("Class not found. Could not unmarshall the UI factory.");
                    cnfe.printStackTrace();
                }
            }
            JComponent[] jComponents = new JComponent[factoryList.size()];
            for (int i = 0; i < factoryList.size(); ++i) {
                JComponentFactory factory = (JComponentFactory)factoryList.get(i);
                jComponents[i] = factory.getJComponent((Object)serviceItem);
            }
            return jComponents;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new JComponent[0];
    }

    public static Object[] loadUI(ServiceItem serviceItem) {
        try {
            int attrCount = serviceItem.attributeSets.length;
            Entry[] attr = serviceItem.attributeSets;
            ArrayList<UIDescriptor> list = new ArrayList<UIDescriptor>();
            for (int i = 0; i < attrCount; ++i) {
                if (!(attr[i] instanceof UIDescriptor)) continue;
                UIDescriptor desc = (UIDescriptor)attr[i];
                if (desc.attributes == null) continue;
                for (Object uiAttr : desc.attributes) {
                    if (!(uiAttr instanceof UIFactoryTypes)) continue;
                    list.add(desc);
                }
            }
            ArrayList<Object> factoryList = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                Object uiFactory = null;
                try {
                    UIDescriptor desc = (UIDescriptor)list.get(i);
                    uiFactory = desc.getUIFactory(serviceItem.service.getClass().getClassLoader());
                    factoryList.add(uiFactory);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    System.out.println("Class not found. Could not unmarshall the UI factory.");
                    cnfe.printStackTrace();
                }
            }
            return factoryList.toArray();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Object[0];
    }
}

