/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.tab;

import com.gigaspaces.admin.ui.tab.ClosableTabbedPaneUI;
import com.gigaspaces.admin.ui.tab.CloseTabAction;
import java.awt.Color;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public abstract class ClosableTabbedPane
extends JTabbedPane {
    private CloseTabAction closeTabAction = null;
    private int _firstIndexOfClosableTab;

    public ClosableTabbedPane(int firstIndexOfClosableTab) {
        this._firstIndexOfClosableTab = firstIndexOfClosableTab;
        this.init();
    }

    private void init() {
        this.setUI(new ClosableTabbedPaneUI(this._firstIndexOfClosableTab));
        this.closeTabAction = new CloseTabAction(){

            @Override
            public void act(ClosableTabbedPane closableTabbedPane, int tabIndex) {
                if (ClosableTabbedPane.this.isTabCanBeClosed(tabIndex)) {
                    closableTabbedPane.removeTabAt(tabIndex);
                }
            }
        };
        Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
        if (bgColor == null) {
            bgColor = this.getBackground();
        }
        this.setBackground(bgColor);
    }

    protected abstract boolean isTabCanBeClosed(int var1);

    public CloseTabAction getCloseTabAction() {
        return this.closeTabAction;
    }

    public void setCloseTabAction(CloseTabAction action) {
        this.closeTabAction = action;
    }
}

