/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.tab;

import com.gigaspaces.admin.ui.tab.ClosableTabbedPane;
import com.gigaspaces.admin.ui.tab.CloseTabAction;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class ClosableTabbedPaneUI
extends BasicTabbedPaneUI {
    public static final int BUTTON_SIZE = 12;
    public static final int BORDER_SIZE = 3;
    private int _firstIndexOfClosableTab;

    public ClosableTabbedPaneUI(int firstIndexOfClosableTab) {
        this._firstIndexOfClosableTab = firstIndexOfClosableTab;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected) - (tabIndex >= this._firstIndexOfClosableTab ? 12 : 0);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + (tabIndex >= this._firstIndexOfClosableTab ? 12 : 0);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        if (tabIndex >= this._firstIndexOfClosableTab) {
            int selectedIndex = this.tabPane.getSelectedIndex();
            boolean isSelected = selectedIndex == tabIndex;
            Rectangle rect = rects[tabIndex];
            int yPosition = (rect.height - 12) / 2;
            int xPosition = rect.x + rect.width - Math.round(18.0f);
            yPosition = isSelected ? yPosition : yPosition + 5;
            g.setColor(Color.black);
            g.drawLine(xPosition + 3, yPosition + 3, xPosition + 12 - 3, yPosition - 3 + 12);
            g.drawLine(xPosition + 3, yPosition - 3 + 12, xPosition + 12 - 3, yPosition + 3);
        }
    }

    class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public MyMouseHandler() {
            super(ClosableTabbedPaneUI.this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int tabIndex = -1;
            int tabCount = ClosableTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!ClosableTabbedPaneUI.this.rects[i].contains(x, y)) continue;
                tabIndex = i;
                break;
            }
            if (tabIndex >= ClosableTabbedPaneUI.this._firstIndexOfClosableTab) {
                Rectangle rect = ClosableTabbedPaneUI.this.rects[tabIndex];
                int yPosition = (rect.height - 12) / 2;
                int xPosition = rect.x + rect.width - Math.round(18.0f);
                if (new Rectangle(xPosition, yPosition, 12, 12).contains(x, y)) {
                    if (ClosableTabbedPaneUI.this.tabPane instanceof ClosableTabbedPane) {
                        ClosableTabbedPane closableTabbedPane = (ClosableTabbedPane)ClosableTabbedPaneUI.this.tabPane;
                        CloseTabAction closeTabAction = closableTabbedPane.getCloseTabAction();
                        if (closeTabAction != null) {
                            closeTabAction.act(closableTabbedPane, tabIndex);
                        }
                    } else {
                        ClosableTabbedPaneUI.this.tabPane.removeTabAt(tabIndex);
                    }
                }
            }
        }
    }
}

