/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.util;

import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.version.PlatformVersion;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AboutBox
extends EscapeDialog {
    private JPanel imagePanel;
    private JPanel infoPanel;
    private JButton okButton;
    private JLabel productNameLabel;
    private JTextField versionTextField;
    private JTextField editionTextField;
    private JLabel image;
    private JPanel okPanel;
    private JPanel innerInfoPanel;
    private BorderLayout borderLayout2;
    private BorderLayout boxLayout21;
    private BorderLayout borderLayout1;
    private String VERSION;
    private final String LICENCSE_TYPE;
    private final String EDITION;
    private static Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public AboutBox(JFrame parentFrame) {
        ImageIcon aboutIcon;
        block4: {
            super(parentFrame, true);
            this.imagePanel = new JPanel();
            this.infoPanel = new JPanel();
            this.okButton = new JButton();
            this.productNameLabel = new JLabel();
            this.versionTextField = new JTextField();
            this.editionTextField = new JTextField();
            this.image = new JLabel();
            this.okPanel = new JPanel();
            this.innerInfoPanel = new JPanel();
            this.borderLayout2 = new BorderLayout();
            this.boxLayout21 = new BorderLayout();
            this.borderLayout1 = new BorderLayout();
            this.VERSION = PlatformVersion.getOfficialVersion();
            this.LICENCSE_TYPE = LicenseManager.getInstance().getLicenseType().toString().toLowerCase();
            this.EDITION = "Edition: " + this.LICENCSE_TYPE.substring(0, 1).toUpperCase() + this.LICENCSE_TYPE.substring(1);
            String[] descLabes = ResourceBundleHandler.getInstance().getResources("dialog.help.labels");
            String[] imageNames = ResourceBundleHandler.getInstance().getResources("dialog.help.image");
            this.getContentPane().setLayout(this.borderLayout2);
            this.okButton.setPreferredSize(new Dimension(81, 27));
            this.okButton.setRequestFocusEnabled(false);
            this.setTitle(descLabes[0]);
            this.productNameLabel.setText(descLabes[1]);
            this.versionTextField.setText(this.VERSION);
            this.versionTextField.setBorder(null);
            this.versionTextField.setEditable(false);
            this.versionTextField.setBackground(Color.WHITE);
            this.editionTextField.setText(this.EDITION);
            this.editionTextField.setBorder(null);
            this.editionTextField.setEditable(false);
            this.editionTextField.setBackground(Color.WHITE);
            this.okButton.setText("OK");
            this.infoPanel.setLayout(this.borderLayout1);
            int labelHeight = 25;
            this.productNameLabel.setPreferredSize(new Dimension(230, 25));
            this.versionTextField.setPreferredSize(new Dimension(64, 25));
            this.editionTextField.setPreferredSize(new Dimension(88, 25));
            this.imagePanel.setLayout(this.boxLayout21);
            this.infoPanel.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)));
            this.innerInfoPanel.setLayout(new BoxLayout(this.innerInfoPanel, 1));
            this.setResizable(false);
            this.getContentPane().add((Component)this.imagePanel, "Center");
            this.imagePanel.add((Component)this.image, "Center");
            this.getContentPane().add((Component)this.infoPanel, "East");
            this.infoPanel.add((Component)this.innerInfoPanel, "Center");
            this.innerInfoPanel.add(Box.createVerticalStrut(3));
            this.innerInfoPanel.add(this.productNameLabel);
            this.innerInfoPanel.add(this.versionTextField);
            this.innerInfoPanel.add(this.editionTextField);
            this.innerInfoPanel.add(Box.createVerticalStrut(30));
            this.innerInfoPanel.add(Box.createVerticalGlue());
            this.innerInfoPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.infoPanel.add((Component)this.okPanel, "South");
            this.productNameLabel.setBackground(Color.WHITE);
            this.productNameLabel.setFont(this.productNameLabel.getFont().deriveFont(1));
            this.versionTextField.setBackground(Color.WHITE);
            this.okPanel.setBackground(Color.WHITE);
            this.okPanel.add((Component)this.okButton, null);
            aboutIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/" + imageNames[0]);
            String customAboutImagePath = System.getProperty("com.gs.about-image.path");
            if (customAboutImagePath != null) {
                try {
                    ImageIcon aboutIconLocal = new ImageIcon(customAboutImagePath);
                    if (aboutIconLocal != null) {
                        aboutIcon = aboutIconLocal;
                    }
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, t.toString(), t);
                }
            }
        }
        this.innerInfoPanel.setBackground(Color.WHITE);
        this.image.setIcon(aboutIcon);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.dispose();
            }
        });
        this.pack();
        JSpaceUIUtils.setLocationRelativeTo(this, parentFrame);
        this.okButton.grabFocus();
    }
}

