/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.util;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FilteredFileChooser {
    private final JFileChooser chooser;
    private final Component parent;

    public FilteredFileChooser(Component parent, File path, String title, String approveButtonText, String extension) {
        this.parent = parent;
        if (extension == null) {
            extension = ".xml";
        }
        final String fileExt = extension;
        this.chooser = path == null ? new JFileChooser() : new JFileChooser(path);
        this.chooser.setDialogType(0);
        this.chooser.setDialogTitle(title);
        if (approveButtonText == null) {
            approveButtonText = "Deploy";
        }
        this.chooser.setApproveButtonText(approveButtonText);
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(fileExt);
            }

            @Override
            public String getDescription() {
                return fileExt;
            }
        });
    }

    public File getFile() {
        if (this.chooser.showOpenDialog(this.parent) == 0) {
            return this.chooser.getSelectedFile();
        }
        return null;
    }
}

