/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.util;

import com.gigaspaces.admin.ui.util.UIHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class InfiniteProgressPanel
extends JComponent
implements MouseListener {
    protected Area[] ticker = null;
    protected Thread animation = null;
    protected boolean started = false;
    protected int alphaLevel = 0;
    protected int rampDelay = 300;
    protected float shield = 0.7f;
    protected String text = "";
    protected int barsCount = 14;
    protected float fps = 15.0f;
    private Font _font;
    private Image _closeImage;
    private final int _closeImageHeight = 14;
    private final int _closeImageWidth = 14;
    protected RenderingHints hints = null;

    public InfiniteProgressPanel() {
        this("");
    }

    public InfiniteProgressPanel(String text) {
        this(text, 14);
    }

    public InfiniteProgressPanel(String text, int barsCount) {
        this(text, barsCount, 0.7f);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield) {
        this(text, barsCount, shield, 15.0f);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, float fps) {
        this(text, barsCount, shield, fps, 300);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, float fps, int rampDelay) {
        this.text = text;
        this.rampDelay = rampDelay >= 0 ? rampDelay : 0;
        this.shield = shield >= 0.0f ? shield : 0.0f;
        this.fps = fps > 0.0f ? fps : 15.0f;
        this.barsCount = barsCount > 0 ? barsCount : 14;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        ImageIcon closeIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/remove_enter.gif");
        this._closeImage = closeIcon.getImage();
        this.setToolTipText("");
    }

    public void setText(String text) {
        this.repaint();
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void start() {
        this.addMouseListener(this);
        this.setVisible(true);
        this.ticker = this.buildTicker();
        this.animation = new Thread(new Animator(true));
        this.animation.start();
    }

    public void stop() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.animation = new Thread(new Animator(false));
            this.animation.start();
        }
    }

    public boolean isAlive() {
        return this.animation == null ? false : this.animation.isAlive();
    }

    public void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.started) {
            Rectangle2D bounds;
            int width = this.getWidth() / 4;
            int height = this.getHeight() / 4;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int screenWidth = screenSize.width;
            int screenHeigth = screenSize.height;
            double maxY = 0.0;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this.hints);
            g2.setColor(new Color(255, 255, 255, (int)((float)this.alphaLevel * this.shield)));
            g2.fillRect(3 * screenWidth / 8, 3 * screenHeigth / 8, width, height);
            g2.drawImage(this._closeImage, 3 * screenWidth / 8 + width - 14, 3 * screenHeigth / 8, null);
            for (int i = 0; i < this.ticker.length; ++i) {
                int channel = 224 - 128 / (i + 1);
                g2.setColor(new Color(channel, channel, channel, this.alphaLevel));
                g2.fill(this.ticker[i]);
                bounds = this.ticker[i].getBounds2D();
                if (!(bounds.getMaxY() > maxY)) continue;
                maxY = bounds.getMaxY();
            }
            if (this.text != null && this.text.length() > 0) {
                FontRenderContext context = g2.getFontRenderContext();
                if (this._font == null) {
                    Font curFont = this.getFont();
                    this._font = new Font(curFont.getName(), curFont.getStyle(), curFont.getSize() + 5);
                }
                TextLayout layout = new TextLayout(this.text, this._font, context);
                bounds = layout.getBounds();
                g2.setColor(this.getForeground());
                layout.draw(g2, (float)((double)screenWidth - bounds.getWidth()) / 2.0f, (float)(maxY + (double)layout.getLeading() + (double)(2.0f * layout.getAscent())));
            }
        }
    }

    private Area[] buildTicker() {
        Area[] ticker = new Area[this.barsCount];
        Point2D.Double center = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double fixedAngle = Math.PI * 2 / (double)this.barsCount;
        for (double i = 0.0; i < (double)this.barsCount; i += 1.0) {
            Area primitive = this.buildPrimitive();
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance(30.0, -6.0);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            ticker[(int)i] = primitive;
        }
        return ticker;
    }

    private Area buildPrimitive() {
        Rectangle2D.Double body = new Rectangle2D.Double(5.0, 0.0, 22.0, 10.0);
        Ellipse2D.Double head = new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0);
        Ellipse2D.Double tail = new Ellipse2D.Double(22.0, 0.0, 10.0, 10.0);
        Area tick = new Area(body);
        tick.add(new Area(head));
        tick.add(new Area(tail));
        return tick;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isPointAtCloseIcon(e.getX(), e.getY())) {
            this.setVisible(false);
            this.interrupt();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private boolean isPointAtCloseIcon(int x, int y) {
        int width = this.getWidth() / 4;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeigth = screenSize.height;
        int iconX = 3 * screenWidth / 8 + width;
        int iconY = 3 * screenHeigth / 8;
        return x >= iconX - 14 && x <= iconX && y >= iconY && y <= iconY + 14;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.isPointAtCloseIcon(event.getX(), event.getY())) {
            return "Close progress splash window";
        }
        return null;
    }

    protected class Animator
    implements Runnable {
        private boolean rampUp = true;

        protected Animator(boolean rampUp) {
            this.rampUp = rampUp;
        }

        @Override
        public void run() {
            Point2D.Double center = new Point2D.Double((double)InfiniteProgressPanel.this.getWidth() / 2.0, (double)InfiniteProgressPanel.this.getHeight() / 2.0);
            double fixedIncrement = Math.PI * 2 / (double)InfiniteProgressPanel.this.barsCount;
            AffineTransform toCircle = AffineTransform.getRotateInstance(fixedIncrement, center.getX(), center.getY());
            long start = System.currentTimeMillis();
            if (InfiniteProgressPanel.this.rampDelay == 0) {
                InfiniteProgressPanel.this.alphaLevel = this.rampUp ? 255 : 0;
            }
            InfiniteProgressPanel.this.started = true;
            boolean inRamp = this.rampUp;
            while (!Thread.interrupted()) {
                block10: {
                    block9: {
                        if (!inRamp) {
                            for (int i = 0; i < InfiniteProgressPanel.this.ticker.length; ++i) {
                                InfiniteProgressPanel.this.ticker[i].transform(toCircle);
                            }
                        }
                        InfiniteProgressPanel.this.repaint();
                        if (!this.rampUp) break block9;
                        if (InfiniteProgressPanel.this.alphaLevel >= 255) break block10;
                        InfiniteProgressPanel.this.alphaLevel = (int)(255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this.rampDelay);
                        if (InfiniteProgressPanel.this.alphaLevel < 255) break block10;
                        InfiniteProgressPanel.this.alphaLevel = 255;
                        inRamp = false;
                        break block10;
                    }
                    if (InfiniteProgressPanel.this.alphaLevel > 0) {
                        InfiniteProgressPanel.this.alphaLevel = (int)(255L - 255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this.rampDelay);
                        if (InfiniteProgressPanel.this.alphaLevel <= 0) {
                            InfiniteProgressPanel.this.alphaLevel = 0;
                            break;
                        }
                    }
                }
                try {
                    Thread.sleep(inRamp ? 10L : (long)((int)(1000.0f / InfiniteProgressPanel.this.fps)));
                }
                catch (InterruptedException ie) {
                    break;
                }
                Thread.yield();
            }
            if (!this.rampUp) {
                InfiniteProgressPanel.this.started = false;
                InfiniteProgressPanel.this.repaint();
                InfiniteProgressPanel.this.setVisible(false);
                InfiniteProgressPanel.this.removeMouseListener(InfiniteProgressPanel.this);
            }
        }
    }
}

